/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.core.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.FrameworkUtil;

public class LogUtil {
    public static IStatus getStatus(int severity, String bundleId, String message, Throwable throwable) {
        return new Status(severity, bundleId, message, throwable);
    }

    public static IStatus error(Throwable throwable) {
        return LogUtil.getStatus(4, "org.eclipse.tips.core", throwable.getMessage(), throwable);
    }

    public static IStatus warn(Throwable throwable) {
        return LogUtil.getStatus(2, "org.eclipse.tips.core", throwable.getMessage(), throwable);
    }

    public static IStatus info(Throwable throwable) {
        return LogUtil.getStatus(1, "org.eclipse.tips.core", throwable.getMessage(), throwable);
    }

    public static IStatus error(Class<?> clazz, Throwable throwable) {
        return LogUtil.getStatus(4, LogUtil.getBundleId(clazz), throwable.getMessage(), throwable);
    }

    public static IStatus warn(Class<?> clazz, Throwable throwable) {
        return LogUtil.getStatus(2, LogUtil.getBundleId(clazz), throwable.getMessage(), throwable);
    }

    public static IStatus info(Class<?> clazz, Throwable throwable) {
        return LogUtil.getStatus(1, LogUtil.getBundleId(clazz), throwable.getMessage(), throwable);
    }

    public static IStatus info(Class<?> clazz, String message) {
        return LogUtil.getStatus(1, LogUtil.getBundleId(clazz), message, null);
    }

    public static IStatus warn(Class<?> clazz, String pessage) {
        return LogUtil.getStatus(2, LogUtil.getBundleId(clazz), pessage, null);
    }

    public static IStatus error(Class<?> clazz, String message) {
        return LogUtil.getStatus(4, LogUtil.getBundleId(clazz), message, null);
    }

    private static String getBundleId(Class<?> clazz) {
        if (FrameworkUtil.getBundle(clazz) != null) {
            return FrameworkUtil.getBundle(clazz).getSymbolicName();
        }
        return "osgi.not.running";
    }

    public static IStatus info(String message) {
        return LogUtil.getStatus(1, "org.eclipse.tips.core", message, null);
    }
}

