/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.internal.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ReportOutputFolder;
import org.jacoco.report.internal.html.HTMLElement;
import org.jacoco.report.internal.html.IHTMLReportContext;
import org.jacoco.report.internal.html.NodePage;
import org.jacoco.report.internal.html.ReportPage;
import org.jacoco.report.internal.html.SourceFilePage;
import org.jacoco.report.internal.html.table.ITableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPage
extends NodePage {
    private final List<MethodItem> methods = new ArrayList<MethodItem>();
    private final Map<String, SourceFilePage> sourceFiles;
    private final String label;
    private final String sourceFileName;

    public ClassPage(IClassCoverage classNode, ReportPage parent, Map<String, SourceFilePage> sourceFiles, ReportOutputFolder folder, IHTMLReportContext context) {
        super(classNode, parent, folder, context);
        this.sourceFiles = sourceFiles;
        this.label = context.getLanguageNames().getClassName(classNode.getName(), classNode.getSignature(), classNode.getSuperName(), classNode.getInterfaceNames());
        this.sourceFileName = classNode.getSourceFileName();
        context.getIndexUpdate().addClass(this, classNode.getId());
    }

    @Override
    public IReportVisitor visitChild(ICoverageNode node) {
        this.methods.add(new MethodItem((IMethodCoverage)node));
        return IReportVisitor.NOP;
    }

    @Override
    protected void headExtra(HTMLElement head) throws IOException {
        super.headExtra(head);
        head.script("text/javascript", this.context.getResources().getLink(this.folder, "sort.js"));
    }

    @Override
    protected String getOnload() {
        return "initialSort(['breadcrumb'])";
    }

    @Override
    protected void content(HTMLElement body) throws IOException {
        this.context.getTable().render(body, this.methods, this.getNode(), this.context.getResources(), this.folder);
    }

    @Override
    protected String getFileName() {
        String vmname = this.getNode().getName();
        int pos = vmname.lastIndexOf(47);
        String shortname = pos == -1 ? vmname : vmname.substring(pos + 1);
        return shortname + ".html";
    }

    @Override
    public String getLinkLabel() {
        return this.label;
    }

    private class MethodItem
    implements ITableItem {
        private final IMethodCoverage node;

        MethodItem(IMethodCoverage node) {
            this.node = node;
        }

        public String getLinkLabel() {
            return ClassPage.this.context.getLanguageNames().getMethodName(ClassPage.this.getNode().getName(), this.node.getName(), this.node.getDesc(), this.node.getSignature());
        }

        public String getLinkStyle() {
            return "el_method";
        }

        public String getLink(ReportOutputFolder base) {
            SourceFilePage sourceFilePage = (SourceFilePage)ClassPage.this.sourceFiles.get(ClassPage.this.sourceFileName);
            if (sourceFilePage == null || !sourceFilePage.exists()) {
                return null;
            }
            String link = sourceFilePage.getLink(base);
            IMethodCoverage source = this.node;
            int first = source.getFirstLine();
            return first != -1 ? link + "#L" + first : link;
        }

        public ICoverageNode getNode() {
            return this.node;
        }
    }
}

