/*******************************************************************************
 * Copyright (c) 2000, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.team.internal.ccvs.ui.subscriber;

import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSSyncInfo;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

/**
 * This action marks the local resource as merged by updating the base
 * resource revision to match the remote resource revision
 */
public class ConfirmMergedOperation extends CVSSubscriberOperation {

	public ConfirmMergedOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
		super(configuration, elements);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.team.internal.ui.actions.TeamOperation#getJobName()
	 */
	protected String getJobName() {
		SyncInfoSet syncSet = getSyncInfoSet();
		return Policy.bind("SubscriberConfirmMergedAction.jobName", new Integer(syncSet.size()).toString()); //$NON-NLS-1$
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.team.internal.ccvs.ui.subscriber.CVSSubscriberOperation#run(org.eclipse.team.core.synchronize.SyncInfoSet, org.eclipse.core.runtime.IProgressMonitor)
	 */
	protected void run(SyncInfoSet syncSet, IProgressMonitor monitor) throws CVSException {
		SyncInfo[] syncResources = syncSet.getSyncInfos();
		monitor.beginTask(null, 100 * syncResources.length);
		try {
			for (int i = 0; i < syncResources.length; i++) {
				SyncInfo info = syncResources[i];
				if (!makeOutgoing(info, Policy.subMonitorFor(monitor, 100))) {
					// Failure was logged in makeOutgoing
				}
			}
		} catch (TeamException e) {
			handle(e);
		} finally {
			monitor.done();
		}
	}

	private boolean makeOutgoing(SyncInfo info, IProgressMonitor monitor) throws CVSException, TeamException {
		monitor.beginTask(null, 100);
		try {
			CVSSyncInfo cvsInfo = getCVSSyncInfo(info);
			if (cvsInfo == null) {
				CVSUIPlugin.log(IStatus.ERROR, Policy.bind("SubscriberConfirmMergedAction.0", cvsInfo.getLocal().getFullPath().toString()), null); //$NON-NLS-1$
				return false;
			}
			// Make sure the parent is managed
			ICVSFolder parent = CVSWorkspaceRoot.getCVSFolderFor(cvsInfo.getLocal().getParent());
			if (!parent.isCVSFolder()) {
				// the parents must be made outgoing before the child can
				SyncInfo parentInfo = cvsInfo.getSubscriber().getSyncInfo(parent.getIResource());
				if (!makeOutgoing(parentInfo, Policy.subMonitorFor(monitor, 20))) {
					return false;
				}
			}
			IStatus status = cvsInfo.makeOutgoing(Policy.subMonitorFor(monitor, 80));
			if (status.getSeverity() == IStatus.ERROR) {
				logError(status);
				return false;
			}
			return true;
		} finally {
			monitor.done();
		}
	}
}
