/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.callgraph.launch;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.linuxtools.callgraph.core.DocWriter;
import org.eclipse.linuxtools.callgraph.core.Helper;
import org.eclipse.linuxtools.callgraph.core.PluginConstants;
import org.eclipse.linuxtools.callgraph.core.SystemTapCommandGenerator;
import org.eclipse.linuxtools.callgraph.core.SystemTapErrorHandler;
import org.eclipse.linuxtools.callgraph.core.SystemTapParser;
import org.eclipse.linuxtools.callgraph.core.SystemTapUIErrorMessages;
import org.eclipse.linuxtools.callgraph.launch.ConfigurationOptionsSetter;
import org.eclipse.linuxtools.callgraph.launch.Messages;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchConfigurationDelegate;

public class SystemTapLaunchConfigurationDelegate
extends ProfileLaunchConfigurationDelegate {
    private static final String TEMP_ERROR_OUTPUT = String.valueOf(PluginConstants.getDefaultOutput()) + "stapTempError.error";
    private String cmd;
    private File temporaryScript = null;
    private String arguments = "";
    private String scriptPath = "";
    private String binaryPath = "";
    private String outputPath = "";
    private boolean needsBinary = false;
    private boolean needsArguments = false;
    private boolean useColour = false;
    private String binaryArguments = "";
    private String partialCommand = "";
    private String stap = "";

    protected String getPluginID() {
        return null;
    }

    private void initialize() {
        this.temporaryScript = null;
        this.arguments = "";
        this.scriptPath = "";
        this.binaryPath = "";
        this.outputPath = "";
        this.needsBinary = false;
        this.needsArguments = false;
        this.useColour = false;
        this.binaryArguments = "";
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor m) throws CoreException {
        if (m == null) {
            m = new NullProgressMonitor();
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)m, (String)"SystemTap runtime monitor", (int)5);
        this.initialize();
        if (monitor.isCanceled()) {
            return;
        }
        if (config.getAttribute("org.eclipse.linuxtools.callgraph.launch.USE_COLOUR", false)) {
            this.useColour = true;
        }
        if (!config.getAttribute("org.eclipse.linuxtools.callgraph.launch.ARGUMENTS", "").equals("")) {
            this.arguments = config.getAttribute("org.eclipse.linuxtools.callgraph.launch.ARGUMENTS", "");
            this.needsArguments = true;
        }
        if (!config.getAttribute("org.eclipse.linuxtools.callgraph.launch.BINARY_PATH", "").equals("")) {
            this.binaryPath = config.getAttribute("org.eclipse.linuxtools.callgraph.launch.BINARY_PATH", "");
            this.needsBinary = true;
        }
        if (!config.getAttribute("org.eclipse.linuxtools.callgraph.launch.BINARY_ARGUMENTS", "").equals("")) {
            this.binaryArguments = config.getAttribute("org.eclipse.linuxtools.callgraph.launch.BINARY_ARGUMENTS", "");
        }
        if (!config.getAttribute("org.eclipse.linuxtools.callgraph.launch.SCRIPT_PATH", "").equals("")) {
            this.scriptPath = config.getAttribute("org.eclipse.linuxtools.callgraph.launch.SCRIPT_PATH", "");
        }
        if (config.getAttribute("org.eclipse.linuxtools.callgraph.launch.NEED_TO_GENERATE", false)) {
            this.temporaryScript = new File(this.scriptPath);
            this.temporaryScript.delete();
            try {
                this.temporaryScript.createNewFile();
                FileWriter fstream = new FileWriter(this.temporaryScript);
                BufferedWriter out = new BufferedWriter(fstream);
                out.write(config.getAttribute("org.eclipse.linuxtools.callgraph.launch.GENERATED_SCRIPT", ""));
                out.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        this.stap = config.getAttribute(".COMMAND", PluginConstants.STAP_PATH);
        this.partialCommand = ConfigurationOptionsSetter.setOptions(config);
        this.outputPath = config.getAttribute("org.eclipse.linuxtools.callgraph.launch.OUTPUT_PATH", PluginConstants.getDefaultOutput());
        this.partialCommand = String.valueOf(this.partialCommand) + "-o " + this.outputPath;
        if (!this.testOutput(this.outputPath) || monitor.isCanceled()) {
            SystemTapUIErrorMessages mess = new SystemTapUIErrorMessages(Messages.getString("SystemTapLaunchConfigurationDelegate.0"), Messages.getString("SystemTapLaunchConfigurationDelegate.1"), String.valueOf(Messages.getString("SystemTapLaunchConfigurationDelegate.2")) + this.outputPath + Messages.getString("SystemTapLaunchConfigurationDelegate.3"));
            mess.schedule();
            return;
        }
        this.finishLaunch(launch, config, m, true);
    }

    public String getCommand() {
        if (this.cmd.length() > 0) {
            return this.cmd;
        }
        return Messages.getString("SystemTapLaunchConfigurationDelegate.NoCommand");
    }

    private void finishLaunch(ILaunch launch, ILaunchConfiguration config, IProgressMonitor monitor, boolean retry) {
        try {
            if (monitor.isCanceled() || launch == null) {
                return;
            }
            monitor.worked(1);
            this.setDefaultSourceLocator(launch, config);
            String parserClass = config.getAttribute("org.eclipse.linuxtools.callgraph.launch.PARSER_CLASS", "");
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IConfigurationElement[] extensions = reg.getConfigurationElementsFor("org.eclipse.linuxtools.callgraph.core", "parser", parserClass);
            if (extensions == null || extensions.length < 1) {
                SystemTapUIErrorMessages mess = new SystemTapUIErrorMessages(Messages.getString("SystemTapLaunchConfigurationDelegate.InvalidParser1"), Messages.getString("SystemTapLaunchConfigurationDelegate.InvalidParser1"), String.valueOf(Messages.getString("SystemTapLaunchConfigurationDelegate.InvalidParser2")) + Messages.getString("SystemTapLaunchConfigurationDelegate.InvalidParser3") + parserClass);
                mess.schedule();
                return;
            }
            IConfigurationElement element = extensions[0];
            SystemTapParser parser = (SystemTapParser)element.createExecutableExtension("class");
            parser.setViewID(config.getAttribute("org.eclipse.linuxtools.callgraph.launch.VIEW_CLASS", "org.eclipse.linuxtools.callgraph.launch.VIEW_CLASS"));
            parser.setSourcePath(this.outputPath);
            parser.setMonitor((IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor));
            parser.setDone(false);
            parser.setSecondaryID(config.getAttribute("org.eclipse.linuxtools.callgraph.launch.SECONDARY_VIEW_ID", ""));
            parser.setKillButtonEnabled(true);
            if (element.getAttribute("realtime").equals("true")) {
                parser.setRealTime(true);
                parser.schedule();
            }
            monitor.worked(1);
            IProcess process = this.createProcess(config, launch);
            monitor.worked(1);
            StreamListener s = new StreamListener();
            process.getStreamsProxy().getErrorStreamMonitor().addListener((IStreamListener)s);
            while (!process.isTerminated()) {
                Thread.sleep(100L);
                if ((monitor == null || !monitor.isCanceled()) && !parser.isDone()) continue;
                parser.cancelJob();
                process.terminate();
                return;
            }
            Thread.sleep(100L);
            s.close();
            parser.setKillButtonEnabled(false);
            if (process.getExitValue() != 0) {
                parser.cancelJob();
                if (process.getExitValue() == 127) {
                    SystemTapUIErrorMessages errorDialog = new SystemTapUIErrorMessages(Messages.getString("SystemTapLaunchConfigurationDelegate.CallGraphGenericError"), Messages.getString("SystemTapLaunchConfigurationDelegate.CallGraphGenericError"), Messages.getString("SystemTapLaunchConfigurationDelegate.stapNotFound"));
                    errorDialog.schedule();
                } else {
                    SystemTapErrorHandler errorHandler = new SystemTapErrorHandler();
                    errorHandler.appendToLog(String.valueOf(config.getName()) + Messages.getString("SystemTapLaunchConfigurationDelegate.stap_command") + this.cmd + "\n" + "\n");
                    errorHandler.handle(monitor, new FileReader(TEMP_ERROR_OUTPUT));
                    if (monitor != null && monitor.isCanceled()) {
                        return;
                    }
                    errorHandler.finishHandling(monitor, this.scriptPath);
                    if (errorHandler.isErrorRecognized()) {
                        SystemTapUIErrorMessages errorDialog = new SystemTapUIErrorMessages(Messages.getString("SystemTapLaunchConfigurationDelegate.CallGraphGenericError"), Messages.getString("SystemTapLaunchConfigurationDelegate.CallGraphGenericError"), errorHandler.getErrorMessage());
                        errorDialog.schedule();
                    }
                }
                return;
            }
            try {
                if (!element.getAttribute("realtime").equals("true")) {
                    parser.schedule();
                } else {
                    parser.cancelJob();
                }
                monitor.worked(1);
                String message = this.generateErrorMessage(config.getName(), this.binaryArguments);
                DocWriter dw = new DocWriter(Messages.getString("SystemTapLaunchConfigurationDelegate.DocWriterName"), Helper.getConsoleByName((String)config.getName()), message);
                dw.schedule();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        finally {
            monitor.done();
        }
    }

    private String generateErrorMessage(String configName, String binaryCommand) {
        String output = "";
        output = binaryCommand == null || binaryCommand.length() < 0 ? "\n\n-------------\n" + Messages.getString("SystemTapLaunchConfigurationDelegate.Relaunch10") + configName + "\n" + Messages.getString("SystemTapLaunchConfigurationDelegate.Relaunch8") + Messages.getString("SystemTapLaunchConfigurationDelegate.Relaunch9") + "configuration in Profile As --> Profile Configurations." + "\n" + "\n" : "\n\n-------------\n" + Messages.getString("SystemTapLaunchConfigurationDelegate.EndMessage1") + configName + "\n" + Messages.getString("SystemTapLaunchConfigurationDelegate.EndMessage2") + binaryCommand + "\n" + Messages.getString("SystemTapLaunchConfigurationDelegate.EndMessage3") + Messages.getString("SystemTapLaunchConfigurationDelegate.EndMessage4") + Messages.getString("SystemTapLaunchConfigurationDelegate.EndMessage5") + "\n" + "\n";
        return output;
    }

    public String generateCommand(ILaunchConfiguration config) {
        this.cmd = SystemTapCommandGenerator.generateCommand((String)this.scriptPath, (String)this.binaryPath, (String)this.partialCommand, (boolean)this.needsBinary, (boolean)this.needsArguments, (String)this.arguments, (String)this.binaryArguments, (String)this.stap);
        return this.cmd;
    }

    private class StreamListener
    implements IStreamListener {
        private int counter;
        private BufferedWriter bw;

        public StreamListener() throws IOException {
            File file = new File(TEMP_ERROR_OUTPUT);
            file.delete();
            file.createNewFile();
            this.bw = Helper.setBufferedWriter((String)TEMP_ERROR_OUTPUT);
            this.counter = 0;
        }

        public void streamAppended(String text, IStreamMonitor monitor) {
            try {
                if (text.length() < 1) {
                    return;
                }
                ++this.counter;
                if (this.counter < 500) {
                    this.bw.append(text);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void close() throws IOException {
            this.bw.close();
        }
    }
}

