/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.linuxtools.internal.cdt.autotools.core.ErrorParserManager;
import org.eclipse.linuxtools.internal.cdt.autotools.core.MarkerGenerator;

public class ErrorParser
extends MarkerGenerator {
    public static final String ID = "org.eclipse.linuxtools.cdt.autotools.core.errorParser";
    private Pattern pkgconfigError = Pattern.compile(".*?(configure:\\s+error:\\s+Package requirements\\s+\\((.*?)\\)\\s+were not met).*");
    private Pattern genconfigError = Pattern.compile(".*?configure:\\s+error:\\s+.*");
    private ErrorParserManager epm;

    public boolean processLine(String line, ErrorParserManager eoParser) {
        Matcher m;
        if (this.epm == null) {
            this.epm = eoParser;
        }
        if ((m = this.pkgconfigError.matcher(line)).matches()) {
            eoParser.generateExternalMarker((IResource)this.epm.getProject(), -1, m.group(1), 3, null, null, m.group(2));
            return true;
        }
        Matcher m2 = this.genconfigError.matcher(line);
        if (m2.matches()) {
            eoParser.generateMarker((IResource)this.epm.getProject(), -1, m.group(1), 3, null);
            return true;
        }
        return false;
    }

    public IProject getProject() {
        if (this.epm != null) {
            return this.epm.getProject();
        }
        return null;
    }
}

