/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.linuxtools.cdt.autotools.core.AutotoolsPlugin;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.AutomakeDocumentProvider;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IMakefileDocumentProvider;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IWorkingCopyManager;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.WorkingCopyManager;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.preferences.ColorManager;
import org.eclipse.swt.graphics.Color;

public class AutomakeEditorFactory {
    private IWorkingCopyManager workingCopyManager;
    private IMakefileDocumentProvider automakeFileDocumentProvider;
    private static AutomakeEditorFactory factory;

    private AutomakeEditorFactory() {
        factory = this;
    }

    public synchronized IMakefileDocumentProvider getAutomakefileDocumentProvider() {
        if (this.automakeFileDocumentProvider == null) {
            this.automakeFileDocumentProvider = new AutomakeDocumentProvider();
        }
        return this.automakeFileDocumentProvider;
    }

    public synchronized IWorkingCopyManager getWorkingCopyManager() {
        if (this.workingCopyManager == null) {
            IMakefileDocumentProvider provider = this.getAutomakefileDocumentProvider();
            this.workingCopyManager = new WorkingCopyManager(provider);
        }
        return this.workingCopyManager;
    }

    public static Color getPreferenceColor(String key) {
        return ColorManager.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)AutotoolsPlugin.getDefault().getPreferenceStore(), (String)key));
    }

    public static AutomakeEditorFactory getDefault() {
        if (factory == null) {
            factory = new AutomakeEditorFactory();
        }
        return factory;
    }
}

