/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.gcov.utils;

import java.io.File;
import java.io.IOException;
import java.util.WeakHashMap;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.binutils.utils.STNMFactory;
import org.eclipse.linuxtools.binutils.utils.STNMSymbolsHandler;
import org.eclipse.linuxtools.binutils.utils.STSymbolManager;

public class STGcovProgramChecker
implements STNMSymbolsHandler {
    private boolean gcovFound = false;
    private long timestamp;
    private static final WeakHashMap<File, STGcovProgramChecker> map = new WeakHashMap();

    private STGcovProgramChecker(long timestamp) {
        this.timestamp = timestamp;
    }

    private static STGcovProgramChecker getProgramChecker(IBinaryParser.IBinaryObject object) throws IOException {
        File program = object.getPath().toFile();
        STGcovProgramChecker pg = map.get(program);
        if (pg == null) {
            pg = new STGcovProgramChecker(program.lastModified());
            STNMFactory.getNM((String)object.getCPU(), (String)object.getPath().toOSString(), (STNMSymbolsHandler)pg);
            map.put(program, pg);
        } else {
            long fileTime = program.lastModified();
            if (fileTime > pg.timestamp) {
                pg.timestamp = fileTime;
                pg.gcovFound = false;
                STNMFactory.getNM((String)object.getCPU(), (String)object.getPath().toOSString(), (STNMSymbolsHandler)pg);
            }
        }
        return pg;
    }

    public static boolean isGCovCompatible(String s) throws IOException {
        IBinaryParser.IBinaryObject object = STSymbolManager.sharedInstance.getBinaryObject((IPath)new Path(s));
        if (object == null) {
            return false;
        }
        return STGcovProgramChecker.isGCovCompatible(object);
    }

    public static boolean isGCovCompatible(IBinaryParser.IBinaryObject object) throws IOException {
        STGcovProgramChecker pg = STGcovProgramChecker.getProgramChecker(object);
        return pg.gcovFound;
    }

    public void foundBssSymbol(String symbol, String address) {
    }

    public void foundDataSymbol(String symbol, String address) {
    }

    public void foundTextSymbol(String symbol, String address) {
        if ("gcov_read_words".equals(symbol) || "_gcov_read_words".equals(symbol)) {
            this.gcovFound = true;
        }
    }

    public void foundUndefSymbol(String symbol) {
    }
}

