/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class TraceHelper {
    public static String getTraceLibDirFromProject(IProject project) {
        if (project != null && project.exists()) {
            return TraceHelper.getProjectPreference(project, "traceLibraryPath");
        }
        return null;
    }

    public static String getProjectPreference(IProject project, String preferenceName) {
        if (project.exists()) {
            IEclipsePreferences prefs = new ProjectScope(project).getNode("org.eclipse.linuxtools.lttng.jni");
            return prefs.get(preferenceName, null);
        }
        return null;
    }

    public static boolean setProjectPreference(IProject project, String preferenceName, String preferenceValue) {
        if (project.exists()) {
            IEclipsePreferences prefs = new ProjectScope(project).getNode("org.eclipse.linuxtools.lttng.jni");
            prefs.put(preferenceName, preferenceValue);
            try {
                prefs.flush();
                return true;
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean removeProjectPreference(IProject project, String preferenceName) {
        if (project.exists()) {
            IEclipsePreferences prefs = new ProjectScope(project).getNode("org.eclipse.linuxtools.lttng.jni");
            prefs.remove(preferenceName);
            try {
                prefs.flush();
                return true;
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

