/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.project.model;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.linuxtools.lttng.ui.views.project.ProjectView;
import org.eclipse.linuxtools.lttng.ui.views.project.model.ILTTngProjectTreeNode;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngProjectNode;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngProjectTreeNode;

public class LTTngProjectRoot
extends LTTngProjectTreeNode {
    private final ProjectView fView;

    public LTTngProjectRoot(ProjectView view) {
        super(null);
        this.fView = view;
        this.refreshChildren();
    }

    @Override
    public void refresh() {
        this.fView.refresh();
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void refreshChildren() {
        IProject[] projects;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = projects = root.getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            LTTngProjectNode node = this.find(project.getName());
            if (node == null) {
                node = new LTTngProjectNode(this, project);
                this.fChildren.add(node);
            } else {
                node.updateState();
            }
            ++n2;
        }
        ArrayList<ILTTngProjectTreeNode> toRemove = new ArrayList<ILTTngProjectTreeNode>();
        for (ILTTngProjectTreeNode node : this.fChildren) {
            if (this.exists(node.getName(), projects)) {
                node.refreshChildren();
                continue;
            }
            toRemove.add(node);
        }
        for (ILTTngProjectTreeNode node : toRemove) {
            this.fChildren.remove(node);
        }
    }

    private LTTngProjectNode find(String name) {
        for (ILTTngProjectTreeNode node : this.fChildren) {
            if (!(node instanceof LTTngProjectNode) || !node.getName().equals(name)) continue;
            return (LTTngProjectNode)node;
        }
        return null;
    }

    private boolean exists(String name, IProject[] projects) {
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.getName().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

