/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.state.model;

import java.util.Stack;
import org.eclipse.linuxtools.lttng.TraceDebug;
import org.eclipse.linuxtools.lttng.state.StateStrings;

public class LttngBdevState
implements Cloneable {
    private Stack<StateStrings.BdevMode> mode_stack = new Stack();

    public LttngBdevState() {
        this.mode_stack.push(StateStrings.BdevMode.LTTV_BDEV_UNKNOWN);
    }

    public void clearBdevStack() {
        this.mode_stack.clear();
    }

    public void clearAndSetBaseToBdevStack(StateStrings.BdevMode newState) {
        this.mode_stack.clear();
        this.mode_stack.push(newState);
    }

    public void pushToBdevStack(StateStrings.BdevMode newState) {
        this.mode_stack.push(newState);
    }

    public StateStrings.BdevMode popFromBdevStack() {
        StateStrings.BdevMode returnedMode = this.mode_stack.pop();
        if (this.mode_stack.size() < 1) {
            TraceDebug.debug("Removing last item from mode stack is not allowed! (popFromModeStack)");
            this.mode_stack.push(StateStrings.BdevMode.LTTV_BDEV_UNKNOWN);
        }
        return returnedMode;
    }

    public StateStrings.BdevMode peekFromBdevStack() {
        return this.mode_stack.peek();
    }

    public LttngBdevState clone() {
        LttngBdevState newState = null;
        try {
            newState = (LttngBdevState)super.clone();
            newState.mode_stack = (Stack)this.mode_stack.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println("Cloning failed with : " + e.getMessage());
        }
        return newState;
    }
}

