/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.project.model;

import java.lang.reflect.Array;
import java.util.Iterator;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.linuxtools.tmf.ui.views.project.model.ITmfProjectTreeNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfProjectNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfProjectTreeNode;
import org.eclipse.linuxtools.tmf.ui.views.project.model.TmfTraceNode;

public class TmfTraceFolderNode
extends TmfProjectTreeNode {
    private final IFolder fTraceFolder;

    public TmfTraceFolderNode(IFolder folder) {
        this(null, folder);
    }

    public TmfTraceFolderNode(ITmfProjectTreeNode parent, IFolder folder) {
        super(parent);
        this.fTraceFolder = folder;
    }

    @Override
    public String getName() {
        return this.fTraceFolder.getName();
    }

    @Override
    public void refreshChildren() {
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = this.fTraceFolder.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                TmfTraceNode node = this.find(resource.getName());
                if (node == null) {
                    node = new TmfTraceNode(this, resource);
                    this.fChildren.add(node);
                }
                ++n2;
            }
            Iterator iterator = this.fChildren.iterator();
            while (iterator.hasNext()) {
                ITmfProjectTreeNode node = (ITmfProjectTreeNode)iterator.next();
                if (this.exists(node.getName(), resources)) continue;
                iterator.remove();
            }
        }
        catch (CoreException coreException) {}
    }

    private TmfTraceNode find(String name) {
        for (ITmfProjectTreeNode node : this.fChildren) {
            if (!(node instanceof TmfTraceNode) || !node.getName().equals(name)) continue;
            return (TmfTraceNode)node;
        }
        return null;
    }

    private boolean exists(String name, IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getName().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public TmfProjectNode getProject() {
        return (TmfProjectNode)this.getParent();
    }

    public IFolder getFolder() {
        return this.fTraceFolder;
    }

    public TmfTraceNode[] getTraces() {
        TmfTraceNode[] result = (TmfTraceNode[])Array.newInstance(TmfTraceNode.class, this.fChildren.size());
        return this.fChildren.toArray(result);
    }

    public TmfTraceNode getTraceForLocation(IPath location) {
        for (ITmfProjectTreeNode node : this.fChildren) {
            TmfTraceNode trace = (TmfTraceNode)node;
            if (!trace.getResource().getLocation().equals((Object)location)) continue;
            return trace;
        }
        return null;
    }

    public void addTrace(IFolder trace) {
    }
}

