/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.widgets;

import org.eclipse.linuxtools.tmf.ui.widgets.ColumnData;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TmfVirtualTable
extends Composite {
    private Table fTable;
    private int fTableRows = 0;
    private int fFullyVisibleRows = 0;
    private int fFrozenRowCount = 0;
    private int fTableTopEventRank = 0;
    private int fSelectedEventRank = 0;
    private boolean fPendingSelection = false;
    private int fTableItemCount = 0;
    private Slider fSlider;
    private int fLinuxItemHeight = 0;

    public TmfVirtualTable(Composite parent, int style) {
        super(parent, style & 0xFFFFFEFF & 0xFFFFFDFF & 0xFFFFFFFB & 0xFFFEFFFF & 0xFFFF7FFF & 0xFFFFFFDF);
        this.createTable(style & 0x18124);
        this.createSlider(style & 0x200);
        this.setTabList(new Control[]{this.fTable});
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        GridData tableGridData = new GridData(4, 4, true, true);
        this.fTable.setLayoutData((Object)tableGridData);
        GridData sliderGridData = new GridData(4, 4, false, true);
        this.fSlider.setLayoutData((Object)sliderGridData);
        this.fTable.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent event) {
                if (TmfVirtualTable.this.fTableItemCount <= TmfVirtualTable.this.fFullyVisibleRows) {
                    return;
                }
                TmfVirtualTable tmfVirtualTable = TmfVirtualTable.this;
                tmfVirtualTable.fTableTopEventRank = tmfVirtualTable.fTableTopEventRank - event.count;
                if (TmfVirtualTable.this.fTableTopEventRank < 0) {
                    TmfVirtualTable.this.fTableTopEventRank = 0;
                }
                int latestFirstRowOffset = TmfVirtualTable.this.fTableItemCount - TmfVirtualTable.this.fFullyVisibleRows;
                if (TmfVirtualTable.this.fTableTopEventRank > latestFirstRowOffset) {
                    TmfVirtualTable.this.fTableTopEventRank = latestFirstRowOffset;
                }
                TmfVirtualTable.this.fSlider.setSelection(TmfVirtualTable.this.fTableTopEventRank);
                TmfVirtualTable.this.refreshTable();
            }
        });
        this.fTable.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
        this.fTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                int tableHeight = Math.max(0, ((TmfVirtualTable)TmfVirtualTable.this).fTable.getClientArea().height - TmfVirtualTable.this.fTable.getHeaderHeight());
                TmfVirtualTable.this.fFullyVisibleRows = tableHeight / TmfVirtualTable.this.getItemHeight();
                if (TmfVirtualTable.this.fTableItemCount > 0) {
                    TmfVirtualTable.this.fSlider.setThumb(Math.max(1, Math.min(TmfVirtualTable.this.fTableRows, TmfVirtualTable.this.fFullyVisibleRows)));
                }
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                TmfVirtualTable.this.resize();
            }
        });
        this.refresh();
    }

    private void createTable(int style) {
        this.fTable = new Table((Composite)this, style | 0x10);
        this.fTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TmfVirtualTable.this.fTable.getSelectionIndices().length > 0) {
                    TmfVirtualTable.this.handleTableSelection();
                }
            }
        });
        this.fTable.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
                TmfVirtualTable.this.handleTableKeyEvent(event);
            }

            public void keyReleased(KeyEvent event) {
            }
        });
    }

    private void handleTableSelection() {
        int selectedRow = this.fTable.getSelectionIndices()[0];
        this.fSelectedEventRank = selectedRow < this.fFrozenRowCount ? selectedRow : this.fTableTopEventRank + selectedRow;
        if (selectedRow >= this.fFullyVisibleRows) {
            final Display display = this.fTable.getDisplay();
            Thread thread = new Thread("Top index check"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(600L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (TmfVirtualTable.this.fTable.isDisposed()) {
                                return;
                            }
                            int topIndex = TmfVirtualTable.this.fTable.getTopIndex();
                            if (topIndex != 0) {
                                TmfVirtualTable tmfVirtualTable = TmfVirtualTable.this;
                                tmfVirtualTable.fTableTopEventRank = tmfVirtualTable.fTableTopEventRank + topIndex;
                                TmfVirtualTable.this.refreshTable();
                                TmfVirtualTable.this.fSlider.setSelection(TmfVirtualTable.this.fTableTopEventRank);
                                TmfVirtualTable.this.fTable.setTopIndex(0);
                            }
                        }
                    });
                }
            };
            thread.start();
        }
    }

    private void handleTableKeyEvent(KeyEvent event) {
        int lastEventRank = this.fTableItemCount - 1;
        int lastPageTopEntryRank = Math.max(0, this.fTableItemCount - this.fFullyVisibleRows);
        int previousSelectedEventRank = this.fSelectedEventRank;
        int selectedRow = this.fSelectedEventRank - this.fTableTopEventRank;
        boolean needsRefresh = false;
        switch (event.keyCode) {
            case 0x1000002: {
                event.doit = false;
                if (this.fSelectedEventRank >= lastEventRank) break;
                ++this.fSelectedEventRank;
                selectedRow = this.fSelectedEventRank - this.fTableTopEventRank;
                if (selectedRow < this.fFullyVisibleRows) break;
                ++this.fTableTopEventRank;
                needsRefresh = true;
                break;
            }
            case 0x1000001: {
                event.doit = false;
                if (this.fSelectedEventRank <= 0) break;
                --this.fSelectedEventRank;
                selectedRow = this.fSelectedEventRank - this.fTableTopEventRank;
                if (selectedRow >= this.fFrozenRowCount || this.fTableTopEventRank <= 0) break;
                --this.fTableTopEventRank;
                needsRefresh = true;
                break;
            }
            case 0x1000008: {
                event.doit = false;
                this.fTableTopEventRank = lastPageTopEntryRank;
                this.fSelectedEventRank = lastEventRank;
                needsRefresh = true;
                break;
            }
            case 0x1000007: {
                event.doit = false;
                this.fSelectedEventRank = this.fFrozenRowCount;
                this.fTableTopEventRank = 0;
                needsRefresh = true;
                break;
            }
            case 0x1000006: {
                event.doit = false;
                if (this.fSelectedEventRank >= lastEventRank) break;
                this.fSelectedEventRank += this.fFullyVisibleRows;
                if (this.fSelectedEventRank > lastEventRank) {
                    this.fSelectedEventRank = lastEventRank;
                }
                if ((selectedRow = this.fSelectedEventRank - this.fTableTopEventRank) <= this.fFullyVisibleRows - 1) break;
                this.fTableTopEventRank += this.fFullyVisibleRows;
                if (this.fTableTopEventRank > lastPageTopEntryRank) {
                    this.fTableTopEventRank = lastPageTopEntryRank;
                }
                needsRefresh = true;
                break;
            }
            case 0x1000005: {
                event.doit = false;
                if (this.fSelectedEventRank <= 0) break;
                this.fSelectedEventRank -= this.fFullyVisibleRows;
                if (this.fSelectedEventRank < this.fFrozenRowCount) {
                    this.fSelectedEventRank = this.fFrozenRowCount;
                }
                if ((selectedRow = this.fSelectedEventRank - this.fTableTopEventRank) >= 0) break;
                this.fTableTopEventRank -= this.fFullyVisibleRows;
                if (this.fTableTopEventRank < 0) {
                    this.fTableTopEventRank = 0;
                }
                needsRefresh = true;
                break;
            }
            default: {
                return;
            }
        }
        boolean done = true;
        if (needsRefresh) {
            done = this.refreshTable();
        } else {
            this.fTable.select(selectedRow);
        }
        if (this.fFullyVisibleRows < this.fTableItemCount) {
            this.fSlider.setSelection(this.fTableTopEventRank);
        }
        if (this.fSelectedEventRank != previousSelectedEventRank && this.fTable.getSelection().length > 0) {
            if (done) {
                Event e = new Event();
                e.item = this.fTable.getSelection()[0];
                this.fTable.notifyListeners(13, e);
            } else {
                this.fPendingSelection = true;
            }
        }
    }

    private boolean setDataItem(int index, TableItem item) {
        if (index != -1) {
            Event event = new Event();
            event.item = item;
            event.index = index < this.fFrozenRowCount ? index : index + this.fTableTopEventRank;
            event.doit = true;
            this.notifyListeners(36, event);
            return event.doit;
        }
        return true;
    }

    private void createSlider(int style) {
        this.fSlider = new Slider((Composite)this, 524800);
        this.fSlider.setMinimum(0);
        this.fSlider.setMaximum(0);
        if ((style & 0x200) == 0) {
            this.fSlider.setVisible(false);
        }
        this.fSlider.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 0: 
                    case 0x1000001: 
                    case 0x1000002: 
                    case 0x1000005: 
                    case 0x1000006: 
                    case 0x1000007: 
                    case 0x1000008: {
                        TmfVirtualTable.this.fTableTopEventRank = TmfVirtualTable.this.fSlider.getSelection();
                        TmfVirtualTable.this.refreshTable();
                    }
                }
            }
        });
    }

    public void setHeaderVisible(boolean b) {
        this.fTable.setHeaderVisible(b);
    }

    public void setLinesVisible(boolean b) {
        this.fTable.setLinesVisible(b);
    }

    public TableItem[] getSelection() {
        return this.fTable.getSelection();
    }

    public void addKeyListener(KeyListener listener) {
        this.fTable.addKeyListener(listener);
    }

    public void addMouseListener(MouseListener listener) {
        this.fTable.addMouseListener(listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.fTable.addSelectionListener(listener);
    }

    public void setMenu(Menu menu) {
        this.fTable.setMenu(menu);
    }

    public void clearAll() {
        this.setItemCount(0);
    }

    public void setItemCount(int nbItems) {
        if ((nbItems = Math.max(0, nbItems)) != this.fTableItemCount) {
            this.fTableItemCount = nbItems;
            this.fTable.remove(this.fTableItemCount, this.fTable.getItemCount() - 1);
            this.fSlider.setMaximum(nbItems);
            this.resize();
            int tableHeight = Math.max(0, this.fTable.getClientArea().height - this.fTable.getHeaderHeight());
            this.fFullyVisibleRows = tableHeight / this.getItemHeight();
            if (this.fTableItemCount > 0) {
                this.fSlider.setThumb(Math.max(1, Math.min(this.fTableRows, this.fFullyVisibleRows)));
            }
        }
    }

    public int getItemCount() {
        return this.fTableItemCount;
    }

    public int getItemHeight() {
        if (this.fLinuxItemHeight >= 0 && System.getProperty("os.name").contains("Linux")) {
            int itemHeight;
            if (this.fLinuxItemHeight != 0) {
                return this.fLinuxItemHeight;
            }
            if (this.fTable.getItemCount() > 1 && (itemHeight = this.fTable.getItem((int)1).getBounds().y - this.fTable.getItem((int)0).getBounds().y) > 0) {
                this.fLinuxItemHeight = itemHeight;
                return this.fLinuxItemHeight;
            }
        } else {
            this.fLinuxItemHeight = -1;
        }
        return this.fTable.getItemHeight();
    }

    public int getTopIndex() {
        return this.fTableTopEventRank + this.fFrozenRowCount;
    }

    public void setTopIndex(int i) {
        if (this.fTableItemCount > 0) {
            i = Math.min(i, this.fTableItemCount - 1);
            i = Math.max(i, this.fFrozenRowCount);
            this.fTableTopEventRank = i - this.fFrozenRowCount;
            if (this.fFullyVisibleRows < this.fTableItemCount) {
                this.fSlider.setSelection(this.fTableTopEventRank);
            }
            this.refreshTable();
        }
    }

    public int indexOf(TableItem ti) {
        int index = this.fTable.indexOf(ti);
        if (index < this.fFrozenRowCount) {
            return index;
        }
        return index - this.fFrozenRowCount + this.getTopIndex();
    }

    public TableColumn[] getColumns() {
        return this.fTable.getColumns();
    }

    public TableItem getItem(Point point) {
        return this.fTable.getItem(point);
    }

    private void resize() {
        int tableHeight = Math.max(0, this.getSize().y - this.fTable.getHeaderHeight());
        int itemHeight = this.getItemHeight();
        this.fTableRows = Math.min((tableHeight + itemHeight - 1) / itemHeight, this.fTableItemCount);
        if (this.fTableTopEventRank + this.fFullyVisibleRows > this.fTableItemCount) {
            this.fTableTopEventRank = Math.max(0, this.fTableItemCount - this.fFullyVisibleRows);
            this.refreshTable();
        } else if (this.fTableRows > this.fTable.getItemCount() || this.fTableItemCount < this.fTable.getItemCount()) {
            this.refreshTable();
        }
    }

    public boolean setFocus() {
        boolean isVisible = this.isVisible();
        if (isVisible) {
            this.fTable.setFocus();
        }
        return isVisible;
    }

    public void refresh() {
        boolean done = this.refreshTable();
        if (this.fPendingSelection && done) {
            this.fPendingSelection = false;
            if (this.fTable.getSelection().length > 0) {
                Event e = new Event();
                e.item = this.fTable.getSelection()[0];
                this.fTable.notifyListeners(13, e);
            }
        }
    }

    public void setColumnHeaders(ColumnData[] columnData) {
        int i = 0;
        while (i < columnData.length) {
            TableColumn column = new TableColumn(this.fTable, columnData[i].alignment, i);
            column.setText(columnData[i].header);
            if (columnData[i].width > 0) {
                column.setWidth(columnData[i].width);
            } else {
                column.pack();
            }
            ++i;
        }
    }

    public int removeAll() {
        this.setItemCount(0);
        this.fSlider.setMaximum(0);
        this.fTable.removeAll();
        this.fSelectedEventRank = this.fFrozenRowCount;
        return 0;
    }

    private boolean refreshTable() {
        boolean done = true;
        int i = 0;
        while (i < this.fTableRows) {
            if (i + this.fTableTopEventRank < this.fTableItemCount) {
                TableItem tableItem = i < this.fTable.getItemCount() ? this.fTable.getItem(i) : new TableItem(this.fTable, 0);
                done &= this.setDataItem(i, tableItem);
            } else if (this.fTable.getItemCount() > this.fTableItemCount - this.fTableTopEventRank) {
                this.fTable.remove(this.fTableItemCount - this.fTableTopEventRank);
            }
            ++i;
        }
        int lastRowOffset = this.fTableTopEventRank + this.fTableRows - 1;
        if (this.fSelectedEventRank >= this.fTableTopEventRank + this.fFrozenRowCount && this.fSelectedEventRank <= lastRowOffset) {
            int selectedRow = this.fSelectedEventRank - this.fTableTopEventRank;
            this.fTable.select(selectedRow);
        } else if (this.fSelectedEventRank < this.fFrozenRowCount) {
            this.fTable.select(this.fSelectedEventRank);
        } else {
            this.fTable.deselectAll();
        }
        return done;
    }

    public void setSelection(int i) {
        if (this.fTableItemCount > 0) {
            i = Math.min(i, this.fTableItemCount - 1);
            this.fSelectedEventRank = i = Math.max(i, 0);
            if (i < this.fTableTopEventRank + this.fFrozenRowCount && i >= this.fFrozenRowCount || i >= this.fTableTopEventRank + this.fFullyVisibleRows) {
                this.fTableTopEventRank = Math.max(0, i - this.fFrozenRowCount - this.fFullyVisibleRows / 2);
            }
            if (this.fFullyVisibleRows < this.fTableItemCount) {
                this.fSlider.setSelection(this.fTableTopEventRank);
            }
            this.refreshTable();
        }
    }

    public int getSelectionIndex() {
        int index = this.fTable.getSelectionIndex();
        if (index == -1) {
            return this.fSelectedEventRank;
        }
        if (index < this.fFrozenRowCount) {
            return index;
        }
        return index - this.fFrozenRowCount + this.getTopIndex();
    }

    public void setFrozenRowCount(int count) {
        this.fFrozenRowCount = count;
        this.refreshTable();
    }

    public TableEditor createTableEditor() {
        return new TableEditor(this.fTable);
    }

    public Control createTableEditorControl(Class<? extends Control> control) {
        try {
            return control.getConstructor(Composite.class, Integer.TYPE).newInstance(this.fTable, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

