/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.filter.model;

import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.filter.model.ITmfFilterTreeNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterRootNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterTreeNode;

public class TmfFilterOrNode
extends TmfFilterTreeNode {
    public static final String NODE_NAME = "OR";
    public static final String NOT_ATTR = "not";
    private boolean fNot = false;

    public TmfFilterOrNode(ITmfFilterTreeNode parent) {
        super(parent);
    }

    @Override
    public String getNodeName() {
        return NODE_NAME;
    }

    public boolean isNot() {
        return this.fNot;
    }

    public void setNot(boolean not) {
        this.fNot = not;
    }

    @Override
    public boolean matches(TmfEvent event) {
        ITmfFilterTreeNode[] iTmfFilterTreeNodeArray = this.getChildren();
        int n = iTmfFilterTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfFilterTreeNode node = iTmfFilterTreeNodeArray[n2];
            if (node.matches(event)) {
                return true ^ this.fNot;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.fNot) {
            buf.append("not ");
        }
        if (this.getParent() != null && !(this.getParent() instanceof TmfFilterRootNode) && !(this.getParent() instanceof TmfFilterNode)) {
            buf.append("( ");
        }
        int i = 0;
        while (i < this.getChildrenCount()) {
            ITmfFilterTreeNode node = this.getChildren()[i];
            buf.append(node.toString());
            if (i < this.getChildrenCount() - 1) {
                buf.append(" or ");
            }
            ++i;
        }
        if (this.getParent() != null && !(this.getParent() instanceof TmfFilterRootNode) && !(this.getParent() instanceof TmfFilterNode)) {
            buf.append(" )");
        }
        return buf.toString();
    }
}

