/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake;

import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.PosixMakefileUtil;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.Util;

public class GNUMakefileUtil
extends PosixMakefileUtil {
    public static boolean isInclude(String line) {
        boolean isSInclude;
        boolean isInclude = (line = line.trim()).startsWith("include") && line.length() > 7 && Character.isWhitespace(line.charAt(7));
        boolean isDashInclude = line.startsWith("-include") && line.length() > 8 && Character.isWhitespace(line.charAt(8));
        boolean bl = isSInclude = line.startsWith("sinclude") && line.length() > 8 && Character.isWhitespace(line.charAt(8));
        return isInclude || isDashInclude || isSInclude;
    }

    public static boolean isVPath(String line) {
        return (line = line.trim()).equals("vpath") || line.startsWith("vpath") && line.length() > 5 && Character.isWhitespace(line.charAt(5));
    }

    public static boolean isExport(String line) {
        return (line = line.trim()).equals("export") || line.startsWith("export") && line.length() > 6 && Character.isWhitespace(line.charAt(6));
    }

    public static boolean isUnExport(String line) {
        return (line = line.trim()).startsWith("unexport") && line.length() > 8 && Character.isWhitespace(line.charAt(8));
    }

    public static boolean isDefine(String line) {
        return (line = line.trim()).startsWith("define") && line.length() > 6 && Character.isWhitespace(line.charAt(6));
    }

    public static boolean isEndef(String line) {
        return line.trim().equals("endef");
    }

    public static boolean isOverride(String line) {
        return (line = line.trim()).startsWith("override") && line.length() > 8 && Character.isWhitespace(line.charAt(8));
    }

    public static boolean isIf(String line) {
        return (line = line.trim()).startsWith("if") && line.length() > 2 && Character.isWhitespace(line.charAt(2)) || line.startsWith("@if") && line.length() > 3 && Character.isWhitespace(line.charAt(3));
    }

    public static boolean isIfeq(String line) {
        return (line = line.trim()).startsWith("ifeq") && line.length() > 4 && Character.isWhitespace(line.charAt(4));
    }

    public static boolean isIfneq(String line) {
        return (line = line.trim()).startsWith("ifneq") && line.length() > 5 && Character.isWhitespace(line.charAt(5));
    }

    public static boolean isIfdef(String line) {
        return (line = line.trim()).startsWith("ifdef") && line.length() > 5 && Character.isWhitespace(line.charAt(5));
    }

    public static boolean isIfndef(String line) {
        return (line = line.trim()).startsWith("ifndef") && line.length() > 6 && Character.isWhitespace(line.charAt(6));
    }

    public static boolean isElse(String line) {
        return line.trim().equals("else");
    }

    public static boolean isEndif(String line) {
        return line.trim().equals("endif") || line.trim().startsWith("@endif");
    }

    public static boolean isOverrideDefine(String line) {
        if ((line = line.trim()).startsWith("override")) {
            int i = 8;
            while (i < line.length() && Character.isWhitespace(line.charAt(i))) {
                ++i;
            }
            if (line.startsWith("define", i)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isTargetVariable(String line) {
        int equal;
        int index = Util.indexOf(line = line.trim(), ':');
        return index > 1 && (equal = Util.indexOf(line = line.substring(index + 1).trim(), '=')) > 1;
    }

    public static boolean isVariableDefinition(String line) {
        return GNUMakefileUtil.isOverrideDefine(line) || GNUMakefileUtil.isTargetVariable(line) || GNUMakefileUtil.isDefine(line) || GNUMakefileUtil.isOverride(line) || GNUMakefileUtil.isExport(line) || GNUMakefileUtil.isMacroDefinition(line);
    }

    public static boolean isStaticTargetRule(String line) {
        int colon1 = Util.indexOf(line = line.trim(), ':');
        if (colon1 > 0) {
            int colon2 = Util.indexOf(line = line.substring(colon1 + 1), ':');
            return colon2 > 0;
        }
        return false;
    }

    public static boolean isGNUTargetRule(String line) {
        int colon = Util.indexOf(line = line.trim(), ':');
        if (colon > 0) {
            if (++colon < line.length()) {
                return line.charAt(colon) != '=';
            }
            return true;
        }
        return false;
    }

    public static boolean isPhonyRule(String line) {
        int colon = Util.indexOf(line = line.trim(), ':');
        if (colon > 0) {
            line = line.substring(0, colon).trim();
            return line.equals(".PHONY");
        }
        return false;
    }

    public static boolean isIntermediateRule(String line) {
        int colon = Util.indexOf(line = line.trim(), ':');
        if (colon > 0) {
            line = line.substring(0, colon).trim();
            return line.equals(".INTERMEDIATE");
        }
        return false;
    }

    public static boolean isSecondaryRule(String line) {
        int colon = Util.indexOf(line = line.trim(), ':');
        if (colon > 0) {
            line = line.substring(0, colon).trim();
            return line.equals(".SECONDARY");
        }
        return false;
    }

    public static boolean isDeleteOnErrorRule(String line) {
        int colon = Util.indexOf(line = line.trim(), ':');
        if (colon > 0) {
            line = line.substring(0, colon).trim();
            return line.equals(".DELETE_ON_ERROR");
        }
        return false;
    }

    public static boolean isLowResolutionTimeRule(String line) {
        int colon = Util.indexOf(line = line.trim(), ':');
        if (colon > 0) {
            line = line.substring(0, colon).trim();
            return line.equals(".LOW_RESOLUTION_TIME");
        }
        return false;
    }

    public static boolean isExportAllVariablesRule(String line) {
        int colon = Util.indexOf(line = line.trim(), ':');
        if (colon > 0) {
            line = line.substring(0, colon).trim();
            return line.equals(".EXPORT_ALL_VARIABLES");
        }
        return false;
    }

    public static boolean isNotParallelRule(String line) {
        int colon = Util.indexOf(line = line.trim(), ':');
        if (colon > 0) {
            line = line.substring(0, colon).trim();
            return line.equals(".NOTPARALLEL");
        }
        return false;
    }
}

