/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.AutomakeEditorFactory;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IMacroDefinition;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IMakefile;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IWorkingCopyManager;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.WordPartDetector;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;

public class MakefileTextHover
implements ITextHover {
    private IEditorPart fEditor;

    public MakefileTextHover(IEditorPart editor) {
        this.fEditor = editor;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (hoverRegion != null) {
            try {
                IWorkingCopyManager fManager;
                IMakefile makefile;
                int len = hoverRegion.getLength();
                int offset = hoverRegion.getOffset();
                textViewer.getDocument().get(offset, len);
                if (this.fEditor != null && len > -1 && (makefile = (fManager = AutomakeEditorFactory.getDefault().getWorkingCopyManager()).getWorkingCopy(this.fEditor.getEditorInput())) != null) {
                    WordPartDetector wordPart = new WordPartDetector(textViewer, offset);
                    String name = wordPart.toString();
                    IMacroDefinition[] statements = null;
                    if (WordPartDetector.inMacro(textViewer, offset) && ((statements = makefile.getMacroDefinitions(name)) == null || statements.length == 0)) {
                        statements = makefile.getBuiltinMacroDefinitions(name);
                    }
                    if (statements == null) {
                        statements = new IMacroDefinition[]{};
                    }
                    StringBuffer buffer = new StringBuffer();
                    int i = 0;
                    while (i < statements.length) {
                        if (i > 0) {
                            buffer.append("\n");
                        }
                        String infoString = statements[i].getValue().toString();
                        buffer.append(name);
                        buffer.append(" - ");
                        buffer.append(infoString);
                        ++i;
                    }
                    return buffer.toString();
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return "";
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        Point selection = textViewer.getSelectedRange();
        if (selection.x <= offset && offset < selection.x + selection.y) {
            return new Region(selection.x, selection.y);
        }
        return new Region(offset, 0);
    }
}

