/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.devhelp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.help.AbstractTocProvider;
import org.eclipse.help.IToc;
import org.eclipse.help.ITocContribution;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.cdt.libhover.devhelp.DevHelpPlugin;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.preferences.PreferenceConstants;

public class DevHelpTocProvider
extends AbstractTocProvider {
    public ITocContribution[] getTocContributions(String locale) {
        ITocContribution contribution = new ITocContribution(){

            public String getId() {
                return "org.eclipse.linuxtools.cdt.libhover.devhelp.toc";
            }

            public String getCategoryId() {
                return null;
            }

            public boolean isPrimary() {
                return true;
            }

            public IToc getToc() {
                return new IToc(){

                    public String getLabel() {
                        return "Devhelp Documents";
                    }

                    public String getHref() {
                        return null;
                    }

                    public boolean isEnabled(IEvaluationContext context) {
                        return true;
                    }

                    public IUAElement[] getChildren() {
                        return this.getTopics();
                    }

                    public ITopic[] getTopics() {
                        try {
                            ArrayList<DevhelpTopic> topics = new ArrayList<DevhelpTopic>();
                            IPreferenceStore ps = DevHelpPlugin.getDefault().getPreferenceStore();
                            Path devhelpLocation = new Path(ps.getString(PreferenceConstants.DEVHELP_DIRECTORY));
                            IFileSystem fs = EFS.getLocalFileSystem();
                            IFileStore htmlDir = fs.getStore((IPath)devhelpLocation);
                            IFileStore[] files = htmlDir.childStores(0, null);
                            Arrays.sort(files, new Comparator<IFileStore>(){

                                @Override
                                public int compare(IFileStore arg0, IFileStore arg1) {
                                    return arg0.getName().compareToIgnoreCase(arg1.getName());
                                }
                            });
                            int i = 0;
                            while (i < files.length) {
                                IFileStore file = files[i];
                                String name = file.fetchInfo().getName();
                                DevhelpTopic topic = new DevhelpTopic(name);
                                topics.add(topic);
                                ++i;
                            }
                            ITopic[] retval = new ITopic[topics.size()];
                            return topics.toArray(retval);
                        }
                        catch (CoreException coreException) {
                            return null;
                        }
                    }

                    public ITopic getTopic(String href) {
                        return null;
                    }
                };
            }

            public String getLocale() {
                return "en_US";
            }

            public String[] getExtraDocuments() {
                return new String[0];
            }

            public String getLinkTo() {
                return "../org.eclipse.linuxtools.cdt.libhover.library.docs/libraries.xml#devhelpdocs";
            }

            public String getContributorId() {
                return "org.eclipse.linuxtools.cdt.libhover.devhelp";
            }
        };
        return new ITocContribution[]{contribution};
    }

    private class DevhelpTopic
    implements ITopic {
        private String name;

        DevhelpTopic(String name) {
            this.name = name;
        }

        public boolean isEnabled(IEvaluationContext context) {
            return true;
        }

        public IUAElement[] getChildren() {
            return new IUAElement[0];
        }

        public String getHref() {
            return "/org.eclipse.linuxtools.cdt.libhover.devhelp/" + this.name + "/index.html";
        }

        public String getLabel() {
            return this.name;
        }

        public ITopic[] getSubtopics() {
            return null;
        }
    }
}

