/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.STDataViewersCSVExporter;
import org.eclipse.linuxtools.dataviewers.abstractviewers.STDataViewersImages;
import org.eclipse.linuxtools.dataviewers.abstractviewers.STDataViewersMessages;
import org.eclipse.linuxtools.dataviewers.dialogs.STDataViewersExportToCSVDialog;
import org.eclipse.swt.graphics.Image;

public class STExportToCSVAction
extends Action {
    private final AbstractSTViewer stViewer;
    private STDataViewersCSVExporter exporter;

    public STExportToCSVAction(AbstractSTViewer stViewer) {
        super(STDataViewersMessages.exportToCSVAction_title);
        Image img = STDataViewersImages.getImage("export.gif");
        super.setImageDescriptor(ImageDescriptor.createFromImage((Image)img));
        this.stViewer = stViewer;
        this.exporter = new STDataViewersCSVExporter(stViewer);
    }

    public void run() {
        STDataViewersExportToCSVDialog dialog = new STDataViewersExportToCSVDialog(this.stViewer.getViewer().getControl().getShell(), this.exporter);
        if (dialog.open() == 0) {
            Job exportToCSVJob = new Job("Export to CSV"){

                public IStatus run(IProgressMonitor monitor) {
                    STExportToCSVAction.this.exporter.export(monitor);
                    return Status.OK_STATUS;
                }
            };
            exportToCSVJob.setUser(true);
            exportToCSVJob.schedule();
        }
    }

    public STDataViewersCSVExporter getExporter() {
        return this.exporter;
    }
}

