/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.event;

import org.eclipse.linuxtools.tmf.event.TmfEventType;

public class LttngEventType
extends TmfEventType {
    private String tracefileName = null;
    private Long cpuId = null;
    private String markerName = null;
    private int markerId = -1;

    public LttngEventType() {
    }

    public LttngEventType(String thisTracefileName, Long thisCpuId, String thisMarkerName, int thisMarkerId, String[] thisMarkerfieldsName) {
        super(String.valueOf(thisTracefileName) + "/" + thisCpuId + "/" + thisMarkerName, thisMarkerfieldsName);
        this.tracefileName = thisTracefileName;
        this.cpuId = thisCpuId;
        this.markerName = thisMarkerName;
        this.markerId = thisMarkerId;
    }

    public LttngEventType(LttngEventType oldType) {
        this(oldType.tracefileName, oldType.cpuId, oldType.markerName, oldType.markerId, oldType.getLabels());
    }

    public String getTracefileName() {
        return this.tracefileName;
    }

    public Long getCpuId() {
        return this.cpuId;
    }

    public String getMarkerName() {
        return this.markerName;
    }

    public int getMarkerId() {
        return this.markerId;
    }

    public String toString() {
        return String.valueOf(this.tracefileName) + "/" + this.cpuId.toString() + "/" + this.markerName;
    }

    public LttngEventType clone() {
        LttngEventType clone = (LttngEventType)super.clone();
        clone.tracefileName = new String(this.tracefileName);
        clone.cpuId = new Long(this.cpuId);
        clone.markerName = new String(this.markerName);
        clone.markerId = this.markerId;
        return clone;
    }
}

