/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.state.model;

import java.util.Stack;
import org.eclipse.linuxtools.lttng.TraceDebug;
import org.eclipse.linuxtools.lttng.state.StateStrings;
import org.eclipse.linuxtools.lttng.state.model.LttngExecutionState;

public class LttngProcessState
implements Cloneable {
    private Long cpu = null;
    private Long pid = null;
    private Long tgid = null;
    private String name = null;
    private Long creation_time = null;
    private String brand = null;
    private StateStrings.ProcessType type = null;
    private Long current_function = null;
    private Long ppid = null;
    private Long insertion_time = null;
    private String pid_time = null;
    private Long free_events = null;
    private LttngExecutionState state = null;
    private Stack<LttngExecutionState> execution_stack = new Stack();
    private Stack<Long> user_stack = new Stack();
    private String userTrace = null;
    private Long target_pid = null;
    private String trace_id = null;

    public LttngProcessState(Long startTime, String traceId) {
        this.cpu = 0L;
        this.pid = 0L;
        this.tgid = 0L;
        this.name = StateStrings.ProcessStatus.LTTV_STATE_UNNAMED.getInName();
        this.insertion_time = startTime;
        this.trace_id = traceId;
        this.init();
    }

    public LttngProcessState(Long cpu, Long pid, Long tgid, String name, Long startTime, String traceId) {
        this.cpu = cpu;
        this.pid = pid;
        this.tgid = tgid;
        this.name = name;
        this.insertion_time = startTime;
        this.trace_id = traceId;
        this.init();
    }

    private void init() {
        this.brand = "";
        this.type = StateStrings.ProcessType.LTTV_STATE_USER_THREAD;
        this.current_function = 0L;
        this.ppid = 0L;
        this.creation_time = 0L;
        this.free_events = 0L;
        LttngExecutionState es = new LttngExecutionState();
        es.setExec_mode(StateStrings.ExecutionMode.LTTV_STATE_USER_MODE);
        es.setExec_submode(StateStrings.ExecutionSubMode.LTTV_STATE_SUBMODE_NONE.getInName());
        es.setExec_submode_id(StateStrings.ExecutionSubMode.LTTV_STATE_SUBMODE_NONE.ordinal() | 0x10000000);
        es.setEntry_Time(this.insertion_time);
        es.setChange_Time(this.insertion_time);
        es.setCum_cpu_time(0L);
        es.setProc_status(StateStrings.ProcessStatus.LTTV_STATE_RUN);
        this.execution_stack.push(es);
        es = new LttngExecutionState();
        es.setExec_mode(StateStrings.ExecutionMode.LTTV_STATE_SYSCALL);
        es.setExec_submode(StateStrings.ExecutionSubMode.LTTV_STATE_SUBMODE_NONE.getInName());
        es.setExec_submode_id(StateStrings.ExecutionSubMode.LTTV_STATE_SUBMODE_NONE.ordinal() | 0x10000000);
        es.setEntry_Time(this.insertion_time);
        es.setChange_Time(this.insertion_time);
        es.setCum_cpu_time(0L);
        es.setProc_status(StateStrings.ProcessStatus.LTTV_STATE_WAIT_FORK);
        this.execution_stack.push(es);
        this.state = es;
    }

    public LttngProcessState clone() {
        LttngProcessState newState = null;
        try {
            newState = (LttngProcessState)super.clone();
            newState.cpu = this.cpu;
            newState.pid = this.pid;
            newState.tgid = this.tgid;
            newState.name = this.name;
            newState.brand = this.brand;
            newState.type = this.type;
            newState.current_function = this.current_function;
            newState.ppid = this.ppid;
            newState.pid_time = this.pid_time;
            newState.free_events = this.free_events;
            newState.userTrace = this.userTrace;
            newState.target_pid = this.target_pid;
            newState.trace_id = this.trace_id;
            newState.creation_time = this.creation_time;
            newState.insertion_time = this.insertion_time;
            newState.state = this.state.clone();
            newState.user_stack = (Stack)this.user_stack.clone();
            newState.execution_stack = new Stack();
            Stack<LttngExecutionState> tmpStack = new Stack<LttngExecutionState>();
            while (!this.execution_stack.empty()) {
                tmpStack.push(this.execution_stack.peek());
                newState.execution_stack.push(this.execution_stack.pop().clone());
            }
            while (!tmpStack.empty()) {
                this.execution_stack.push((LttngExecutionState)tmpStack.pop());
            }
        }
        catch (CloneNotSupportedException e) {
            System.out.println("Cloning failed with : " + e.getMessage());
        }
        return newState;
    }

    public Long getPid() {
        return this.pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Long getTgid() {
        return this.tgid;
    }

    public void setTgid(Long tgid) {
        this.tgid = tgid;
    }

    public Long getPpid() {
        return this.ppid;
    }

    public void setPpid(Long ppid) {
        this.ppid = ppid;
    }

    public void setPpid(Long ppid, Long creationTime) {
        if (ppid != null) {
            this.ppid = ppid;
        }
        if (creationTime != null) {
            this.setCreation_time(creationTime);
        }
    }

    public Long getCreation_time() {
        return this.creation_time;
    }

    public void setCreation_time(Long creationTime) {
        if (creationTime != null && this.pid != null) {
            this.creation_time = creationTime;
            StringBuilder sb = new StringBuilder(String.valueOf(this.pid.toString()) + "-" + creationTime.toString());
            this.pid_time = sb.toString();
        }
    }

    public Long getInsertion_time() {
        return this.insertion_time;
    }

    public void setInsertion_time(Long insertionTime) {
        this.insertion_time = insertionTime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public String getPid_time() {
        return this.pid_time;
    }

    public Long getCpu() {
        return this.cpu;
    }

    public void setCpu(Long cpu) {
        this.cpu = cpu;
    }

    public Long getCurrent_function() {
        return this.current_function;
    }

    public void setCurrent_function(Long currentFunction) {
        this.current_function = currentFunction;
    }

    public Long getTarget_pid() {
        return this.target_pid;
    }

    public void setTarget_pid(Long targetPid) {
        this.target_pid = targetPid;
    }

    public String getTrace_id() {
        return this.trace_id;
    }

    public void setTrace_id(String traceId) {
        this.trace_id = traceId;
    }

    public Long getFree_events() {
        return this.free_events;
    }

    public void setFree_events(Long freeEvents) {
        this.free_events = freeEvents;
    }

    public void incrementFree_events() {
        this.free_events = this.free_events + 1L;
    }

    public LttngExecutionState getState() {
        return this.state;
    }

    public void setState(LttngExecutionState state) {
        this.state = state;
    }

    public StateStrings.ProcessType getType() {
        return this.type;
    }

    public void setType(StateStrings.ProcessType type) {
        this.type = type;
    }

    public String getUserTrace() {
        return this.userTrace;
    }

    public void setUserTrace(String userTrace) {
        this.userTrace = userTrace;
    }

    public void clearUserStack() {
        this.user_stack.clear();
    }

    public void pushToUserStack(Long newState) {
        this.user_stack.push(newState);
    }

    public Long popFromUserStack() {
        if (this.user_stack.size() <= 1) {
            TraceDebug.debug("Removing last item from user stack is not allowed! (popFromUserStack)");
            return null;
        }
        return this.user_stack.pop();
    }

    public Long peekFromUserStack() {
        return this.user_stack.peek();
    }

    public void clearExecutionStack() {
        this.execution_stack.clear();
    }

    public void pushToExecutionStack(LttngExecutionState newState) {
        this.execution_stack.push(newState);
        this.setState(newState);
    }

    public LttngExecutionState popFromExecutionStack() {
        if (this.execution_stack.size() <= 1) {
            TraceDebug.debug("Removing last item from execution stack is not allowed! (popFromExecutionStack)");
            return null;
        }
        LttngExecutionState popedState = this.execution_stack.pop();
        this.setState(this.peekFromExecutionStack());
        return popedState;
    }

    public LttngExecutionState peekFromExecutionStack() {
        return this.execution_stack.peek();
    }

    public LttngExecutionState getFirstElementFromExecutionStack() {
        return (LttngExecutionState)this.execution_stack.firstElement();
    }

    public String toString() {
        String stateSt = this.state.toString();
        String eStackSt = this.execution_stack.toString();
        return "[LttngProcessState: cpu=" + this.cpu + ",pid=" + this.pid + ",tgid=" + this.tgid + ",name=" + this.name + ",ctime=" + this.creation_time + ",brand=" + this.brand + ",type=" + (Object)((Object)this.type) + ",cfunc=" + this.current_function + ",ppid=" + this.ppid + ",itime=" + this.insertion_time + ",ptime=" + this.pid_time + ",fevents=" + this.free_events + ",state=" + stateSt + ",estack=" + eStackSt + ",ustack=" + this.user_stack + ",utrace=" + this.userTrace + ",tpid=" + this.target_pid + ",trace=" + this.trace_id + "]";
    }
}

