/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.model.trange;

import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeComposite;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeEvent;

public class TimeRangeEventProcess
extends TimeRangeComposite
implements Comparable<TimeRangeEventProcess> {
    private Long pid = 0L;
    private Long tgid = 0L;
    private Long ppid = 0L;
    private Long creationTime = 0L;
    private String traceID = "";
    private String processType = "User";
    private Long cpu = 0L;
    private String brand = "";

    public TimeRangeEventProcess(int id, String name, long startTime, long stopTime, String groupName, String className, Long cpu, long insertionTime) {
        super(id, startTime, stopTime, name, TimeRangeComposite.CompositeType.PROCESS, insertionTime);
        this.cpu = cpu;
    }

    public void addChildren(TimeRangeEvent newEvent) {
        if (newEvent != null) {
            this.ChildEventLeafs.add(newEvent);
        }
    }

    public Long getPid() {
        return this.pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Long getTgid() {
        return this.tgid;
    }

    public void setTgid(Long tgid) {
        this.tgid = tgid;
    }

    public Long getPpid() {
        return this.ppid;
    }

    public void setPpid(Long ppid) {
        this.ppid = ppid;
    }

    public Long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Long creationTime) {
        this.creationTime = creationTime;
    }

    public String getTraceID() {
        return this.traceID;
    }

    public void setTraceID(String traceID) {
        this.traceID = traceID != null ? traceID : "";
    }

    public String getProcessType() {
        return this.processType;
    }

    public void setProcessType(String processType) {
        if (processType != null) {
            this.processType = processType;
        }
    }

    public Long getCpu() {
        return this.cpu;
    }

    public void setCpu(Long cpu) {
        if (cpu != null) {
            this.cpu = cpu;
        } else {
            cpu = 0L;
        }
    }

    public String getBrand() {
        return this.brand;
    }

    public void setBrand(String brand) {
        if (brand != null) {
            this.brand = brand;
        } else {
            brand = "";
        }
    }

    @Override
    public int compareTo(TimeRangeEventProcess process) {
        if (process != null) {
            int result = 0;
            Long anotherPid = process.getPid();
            result = this.pid.compareTo(anotherPid);
            if (result != 0) {
                return result;
            }
            Long anotherCpu = process.getCpu();
            result = this.cpu.compareTo(anotherCpu);
            if (result != 0) {
                return result;
            }
            String anotherTraceId = process.getTraceID();
            return this.traceID.compareTo(anotherTraceId);
        }
        return 0;
    }

    @Override
    public String toString() {
        return "[TimeRangeEventProcess:" + super.toString() + ",pid=" + this.pid + ",tgid=" + this.tgid + ",ppid=" + this.ppid + ",ctime=" + this.creationTime + ",trace=" + this.traceID + ",ptype=" + this.processType + ",cpu=" + this.cpu + ",brand=" + this.brand + "]";
    }
}

