/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.tracecontrol.dialogs;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.lttng.tracecontrol.model.TargetResource;
import org.eclipse.linuxtools.lttng.tracecontrol.model.TraceResource;
import org.eclipse.linuxtools.lttng.tracecontrol.model.config.TraceConfig;
import org.eclipse.linuxtools.lttng.ui.LTTngUiPlugin;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.Messages;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.subsystems.TraceSubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewTraceDialog
extends Dialog {
    private String fTraceName;
    private String fTraceTransport;
    private String fTracePath;
    private int fMode;
    private int fNumChannel;
    private Boolean fIsAppend;
    private Boolean fIsLocal;
    private Text fNameText;
    private Text fTransportText;
    private Text fPathText;
    private Text fNumLttdThreadsText;
    private Button fFinishButton;
    private Button fHostButton;
    private Button fTargetButton;
    private Button fIsAppendButton;
    private Button fFlightRecorderButton;
    private Button fNormalButton;
    private Boolean fFinishButtonClicked;
    private Display fDisplay;
    private String fTraceNameError;
    private String fTracePathError;
    private Label fErrorLabel;
    private Button fBrowseButton;
    private TraceSubSystem fSubSystem;
    private TargetResource fTargetResource;
    private IProject fProject;
    private static IProject defaultProject;

    public NewTraceDialog(Shell parent, TraceSubSystem subSystem, TargetResource targetResource) {
        super(parent);
        this.fSubSystem = subSystem;
        this.fTargetResource = targetResource;
    }

    public TraceConfig open() {
        Shell parent = this.getParent();
        final Shell shell = new Shell(parent, 67616);
        shell.setText(Messages.NewTraceDialog_Title);
        shell.setLayout((Layout)new GridLayout());
        shell.setImage(LTTngUiPlugin.getDefault().getImage("ICON_ID_NEW_TRACE"));
        GridData griddata = new GridData();
        this.fFinishButtonClicked = false;
        this.fTraceNameError = "";
        this.fTracePathError = "";
        griddata = new GridData();
        Composite composite1 = new Composite((Composite)shell, 0);
        GridLayout compositeLayout1 = new GridLayout(2, false);
        composite1.setSize(520, 300);
        composite1.setLayout((Layout)compositeLayout1);
        griddata.horizontalSpan = 3;
        griddata.widthHint = 520;
        griddata.minimumWidth = 520;
        composite1.setLayoutData((Object)griddata);
        Label nameLabel = new Label(composite1, 0);
        nameLabel.setText(String.valueOf(Messages.NewTraceDialog_TraceName) + ":");
        griddata = new GridData();
        griddata.verticalIndent = 20;
        nameLabel.setLayoutData((Object)griddata);
        this.fNameText = new Text(composite1, 2052);
        if (this.fTargetResource.isUst()) {
            this.fNameText.setText("auto");
            this.fNameText.setEnabled(false);
        }
        griddata = new GridData();
        griddata.horizontalAlignment = 4;
        griddata.grabExcessHorizontalSpace = true;
        griddata.verticalIndent = 20;
        this.fNameText.setLayoutData((Object)griddata);
        this.fNameText.setSize(500, 50);
        Label transportLabel = new Label(composite1, 0);
        transportLabel.setText(String.valueOf(Messages.ConfigureTraceDialog_Trace_Transport) + ":");
        griddata = new GridData();
        transportLabel.setLayoutData((Object)griddata);
        this.fTransportText = new Text(composite1, 2052);
        griddata = new GridData();
        griddata.horizontalAlignment = 4;
        griddata.grabExcessHorizontalSpace = true;
        this.fTransportText.setLayoutData((Object)griddata);
        this.fTransportText.setSize(500, 50);
        this.fTransportText.setText("relay");
        this.fTransportText.setEnabled(false);
        griddata = new GridData();
        Group composite21 = new Group(composite1, 8);
        composite21.setSize(300, 300);
        composite21.setText(Messages.ConfigureTraceDialog_Trace_Location);
        griddata.horizontalAlignment = 4;
        griddata.horizontalSpan = 2;
        griddata.verticalIndent = 10;
        griddata.widthHint = 300;
        griddata.minimumWidth = 300;
        composite21.setLayoutData((Object)griddata);
        GridLayout compositeLayout21 = new GridLayout(4, false);
        composite21.setLayout((Layout)compositeLayout21);
        this.fTargetButton = new Button((Composite)composite21, 16);
        this.fTargetButton.setText(Messages.ConfigureTraceDialog_Target);
        this.fTargetButton.setSelection(true);
        this.fHostButton = new Button((Composite)composite21, 16);
        this.fHostButton.setText(Messages.ConfigureTraceDialog_Host);
        griddata = new GridData();
        griddata.horizontalSpan = 3;
        this.fHostButton.setLayoutData((Object)griddata);
        this.fIsLocal = false;
        this.fHostButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (NewTraceDialog.this.fHostButton.getSelection()) {
                    NewTraceDialog.this.fIsLocal = true;
                    NewTraceDialog.this.fBrowseButton.setEnabled(true);
                } else {
                    NewTraceDialog.this.fIsLocal = false;
                    NewTraceDialog.this.fBrowseButton.setEnabled(false);
                }
                NewTraceDialog.this.validatePathName(NewTraceDialog.this.fPathText.getText());
                NewTraceDialog.this.validate();
            }
        });
        Label pathLabel = new Label((Composite)composite21, 0);
        pathLabel.setText(Messages.ConfigureTraceDialog_Trace_Path);
        griddata = new GridData();
        griddata.verticalIndent = 10;
        pathLabel.setLayoutData((Object)griddata);
        this.fPathText = new Text((Composite)composite21, 2052);
        griddata = new GridData();
        griddata.horizontalAlignment = 4;
        griddata.grabExcessHorizontalSpace = true;
        griddata.verticalIndent = 10;
        this.fPathText.setLayoutData((Object)griddata);
        this.fPathText.setData((Object)"");
        this.fBrowseButton = new Button((Composite)composite21, 8);
        this.fBrowseButton.setText(String.valueOf(Messages.ConfigureTraceDialog_Browse) + "...");
        griddata = new GridData();
        griddata.grabExcessHorizontalSpace = false;
        griddata.widthHint = 100;
        griddata.verticalIndent = 10;
        this.fBrowseButton.setLayoutData((Object)griddata);
        this.fBrowseButton.setEnabled(false);
        this.fBrowseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog dialog = new DirectoryDialog(shell);
                String newPath = dialog.open();
                if (newPath != null) {
                    NewTraceDialog.this.fPathText.setText(newPath);
                }
            }
        });
        this.fNameText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewTraceDialog.this.validateTraceName(NewTraceDialog.this.fNameText.getText());
                NewTraceDialog.this.validate();
            }
        });
        this.fTransportText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewTraceDialog.this.validate();
            }
        });
        this.fPathText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (!NewTraceDialog.this.fPathText.isEnabled()) {
                    return;
                }
                NewTraceDialog.this.validatePathName(NewTraceDialog.this.fPathText.getText());
                NewTraceDialog.this.validate();
            }
        });
        Composite projectComposite = new Composite(composite1, 0);
        projectComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 10;
        projectComposite.setLayout((Layout)gl);
        Label projectLabel = new Label(projectComposite, 0);
        projectLabel.setText(String.valueOf(Messages.NewTraceDialog_Tracing_Project) + ":");
        final Combo projectCombo = new Combo(projectComposite, 8);
        projectCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.isOpen() && project.hasNature("org.eclipse.linuxtools.lttng.LTTngProjectNature")) {
                    projectCombo.add(project.getName());
                    projectCombo.setData(project.getName(), (Object)project);
                    if (this.fProject == null || project.equals((Object)defaultProject)) {
                        projectCombo.select(projectCombo.getItemCount() - 1);
                        this.fProject = project;
                    }
                }
            }
            catch (CoreException e) {
                SystemBasePlugin.logError((String)"NewTraceDialog", (Throwable)e);
            }
            ++n2;
        }
        projectCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewTraceDialog.this.fProject = (IProject)projectCombo.getData(projectCombo.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        griddata = new GridData();
        Composite composite2 = new Composite(composite1, 0);
        GridLayout compositeLayout2 = new GridLayout(2, false);
        compositeLayout2.marginWidth = 0;
        composite2.setLayout((Layout)compositeLayout2);
        griddata.horizontalSpan = 2;
        composite2.setLayoutData((Object)griddata);
        Label numLttdThreadsLabel = new Label(composite2, 0);
        numLttdThreadsLabel.setText(String.valueOf(Messages.ConfigureTraceDialog_Num_Lttd_Threads) + ":");
        this.fNumLttdThreadsText = new Text(composite2, 2052);
        griddata = new GridData();
        griddata.horizontalAlignment = 1;
        griddata.widthHint = 50;
        griddata.minimumWidth = 50;
        this.fNumLttdThreadsText.setLayoutData((Object)griddata);
        if (this.fTargetResource.isUst()) {
            this.fNumLttdThreadsText.setText("1");
            this.fNumLttdThreadsText.setEnabled(false);
        } else {
            this.fNumLttdThreadsText.setText("2");
        }
        this.fNumLttdThreadsText.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String string = e.text;
                char[] chars = new char[string.length()];
                string.getChars(0, chars.length, chars, 0);
                int i = 0;
                while (i < chars.length) {
                    if ('0' > chars[i] || chars[i] > '9') {
                        e.doit = false;
                        return;
                    }
                    ++i;
                }
            }
        });
        this.fNumLttdThreadsText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewTraceDialog.this.validate();
            }
        });
        this.fIsAppendButton = new Button(composite1, 32);
        this.fIsAppendButton.setText(Messages.ConfigureTraceDialog_Append);
        griddata = new GridData();
        griddata.horizontalAlignment = 1;
        griddata.horizontalSpan = 2;
        griddata.verticalIndent = 10;
        this.fIsAppendButton.setLayoutData((Object)griddata);
        this.fIsAppend = false;
        this.fIsAppendButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (NewTraceDialog.this.fIsAppendButton.getSelection()) {
                    NewTraceDialog.this.fIsAppend = true;
                } else {
                    NewTraceDialog.this.fIsAppend = false;
                }
            }
        });
        if (this.fTargetResource.isUst()) {
            this.fIsAppendButton.setEnabled(false);
        }
        griddata = new GridData();
        Group composite22 = new Group(composite1, 8);
        composite22.setText(Messages.ConfigureTraceDialog_Trace_Mode);
        griddata.horizontalSpan = 2;
        griddata.verticalIndent = 10;
        composite22.setLayoutData((Object)griddata);
        GridLayout compositeLayout22 = new GridLayout(2, false);
        composite22.setLayout((Layout)compositeLayout22);
        this.fNormalButton = new Button((Composite)composite22, 16);
        this.fNormalButton.setText(Messages.ConfigureTraceDialog_Mode_Normal);
        this.fFlightRecorderButton = new Button((Composite)composite22, 16);
        this.fFlightRecorderButton.setText(Messages.ConfigureTraceDialog_Mode_Flight_Recorder);
        this.fMode = 0;
        this.fNormalButton.setSelection(true);
        this.fNormalButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (NewTraceDialog.this.fNormalButton.getSelection()) {
                    NewTraceDialog.this.fMode = 0;
                }
            }
        });
        this.fFlightRecorderButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (NewTraceDialog.this.fFlightRecorderButton.getSelection()) {
                    NewTraceDialog.this.fMode = 1;
                }
            }
        });
        if (this.fTargetResource.isUst()) {
            this.fFlightRecorderButton.setEnabled(false);
            this.fNormalButton.setEnabled(false);
        }
        this.fErrorLabel = new Label((Composite)shell, 0);
        this.fDisplay = parent.getDisplay();
        this.fErrorLabel.setForeground(this.fDisplay.getSystemColor(3));
        griddata = new GridData();
        griddata.widthHint = 400;
        griddata.minimumWidth = 400;
        this.fErrorLabel.setLayoutData((Object)griddata);
        Label shadow_sep_h = new Label((Composite)shell, 266);
        griddata = new GridData();
        griddata.horizontalAlignment = 4;
        griddata.grabExcessHorizontalSpace = true;
        griddata.verticalIndent = 20;
        shadow_sep_h.setLayoutData((Object)griddata);
        Composite buttonComposite = new Composite((Composite)shell, 0);
        buttonComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        buttonComposite.setLayout((Layout)new GridLayout(2, false));
        Button cancelButton = new Button(buttonComposite, 8);
        cancelButton.setText(Messages.ConfigureTraceDialog_Cancel);
        cancelButton.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.fFinishButton = new Button(buttonComposite, 8);
        this.fFinishButton.setText(Messages.ConfigureTraceDialog_Finish);
        this.fFinishButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.fFinishButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewTraceDialog.this.fFinishButtonClicked = true;
                shell.dispose();
            }
        });
        this.validate();
        cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewTraceDialog.this.fTraceName = null;
                NewTraceDialog.this.fTraceTransport = null;
                NewTraceDialog.this.fTracePath = null;
                shell.dispose();
            }
        });
        shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 2) {
                    event.doit = false;
                }
            }
        });
        shell.pack();
        shell.open();
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (this.fTraceName == null || this.fTraceTransport == null || this.fTracePath == null || !this.fFinishButtonClicked.booleanValue()) {
            return null;
        }
        TraceConfig result = new TraceConfig();
        result.setTraceName(this.fTraceName);
        result.setTraceTransport(this.fTraceTransport);
        result.setTracePath(this.fTracePath);
        result.setNetworkTrace(this.fIsLocal.booleanValue());
        result.setIsAppend(this.fIsAppend.booleanValue());
        result.setMode(this.fMode);
        result.setNumChannel(this.fNumChannel);
        result.setProject(this.fProject);
        defaultProject = this.fProject;
        return result;
    }

    private boolean validateTraceName(String name) {
        if (name.length() > 0) {
            TraceResource[] traces = new TraceResource[]{};
            try {
                traces = this.fSubSystem.getAllTraces();
            }
            catch (SystemMessageException e) {
                SystemBasePlugin.logError((String)"NewTraceDialog ", (Throwable)e);
            }
            int i = 0;
            while (i < traces.length) {
                if (traces[i].getName().compareTo(name) == 0) {
                    this.fTraceNameError = Messages.NewTraceDialog_Error_Already_Exists;
                    this.fErrorLabel.setText(this.fTraceNameError);
                    return false;
                }
                ++i;
            }
            char[] chars = name.toCharArray();
            int x = 0;
            while (x < chars.length) {
                char c = chars[x];
                if (!(x != 0 || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                    this.fTraceNameError = Messages.NewTraceDialog_Error_Invalid_First_Char;
                    this.fErrorLabel.setText(this.fTraceNameError);
                    return false;
                }
                if (!(x == 0 || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                    this.fTraceNameError = Messages.NewTraceDialog_Error_Invalid_Name;
                    this.fErrorLabel.setText(this.fTraceNameError);
                    return false;
                }
                ++x;
            }
        }
        if (this.fTracePathError.length() > 0) {
            this.fErrorLabel.setText(this.fTracePathError);
        } else {
            this.fErrorLabel.setText("");
        }
        this.fTraceNameError = "";
        return true;
    }

    private boolean validatePathName(String path) {
        if (path.length() > 0) {
            char c0 = path.charAt(0);
            if (c0 != '/') {
                this.fTracePathError = Messages.ConfigureTraceDialog_Error_Invalid_Path;
                this.fErrorLabel.setText(this.fTracePathError);
                return false;
            }
            String[] folders = path.split("/");
            int i = 0;
            while (i < folders.length) {
                char[] chars = folders[i].toCharArray();
                int x = 0;
                while (x < chars.length) {
                    char c = chars[x];
                    if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                        this.fTracePathError = Messages.ConfigureTraceDialog_Error_Invalid_Folder;
                        this.fErrorLabel.setText(this.fTracePathError);
                        return false;
                    }
                    ++x;
                }
                ++i;
            }
            if (path.length() > 1) {
                i = 0;
                while (i < path.length() - 1) {
                    if (path.charAt(i) == '/' && path.charAt(i + 1) == '/') {
                        this.fTracePathError = Messages.ConfigureTraceDialog_Error_Multiple_Seps;
                        this.fErrorLabel.setText(this.fTracePathError);
                        return false;
                    }
                    ++i;
                }
            }
            if (this.fIsLocal.booleanValue()) {
                File file = new File(path);
                if (file.isFile()) {
                    this.fTracePathError = Messages.ConfigureTraceDialog_Error_File_Exists;
                    this.fErrorLabel.setText(this.fTracePathError);
                    return false;
                }
                if (path.length() > 1 && !file.getParentFile().canWrite()) {
                    this.fTracePathError = Messages.ConfigureTraceDialog_Error_Can_Not_Write;
                    this.fErrorLabel.setText(this.fTracePathError);
                    return false;
                }
            }
        }
        if (this.fTraceNameError.length() > 0) {
            this.fErrorLabel.setText(this.fTraceNameError);
        } else {
            this.fErrorLabel.setText("");
        }
        this.fTracePathError = "";
        return true;
    }

    private void validate() {
        if (this.fTracePathError.length() > 0 || this.fTraceNameError.length() > 0) {
            this.fFinishButton.setEnabled(false);
            return;
        }
        if (this.fNameText.getText() == null || this.fNameText.getText().length() == 0) {
            this.fErrorLabel.setText(Messages.NewTraceDialog_Error_No_Name);
            this.fFinishButton.setEnabled(false);
            return;
        }
        if (this.fTransportText.getText() == null || this.fTransportText.getText().length() == 0) {
            this.fFinishButton.setEnabled(false);
            return;
        }
        if (this.fPathText.getText().length() == 0) {
            this.fErrorLabel.setText(Messages.NewTraceDialog_Error_No_Path);
            this.fFinishButton.setEnabled(false);
            return;
        }
        if (this.fProject == null) {
            this.fErrorLabel.setText(Messages.NewTraceDialog_Error_No_Project);
            this.fFinishButton.setEnabled(false);
            return;
        }
        if (this.fNumLttdThreadsText.getText().length() == 0 || this.fNumLttdThreadsText.getText().length() == 0) {
            this.fErrorLabel.setText(Messages.NewTraceDialog_Error_No_NumLttdThreads);
            this.fFinishButton.setEnabled(false);
            return;
        }
        this.fErrorLabel.setText("");
        this.fTraceName = this.fNameText.getText();
        this.fTraceTransport = this.fTransportText.getText();
        this.fTracePath = this.fPathText.getText();
        this.fNumChannel = Integer.parseInt(this.fNumLttdThreadsText.getText());
        this.fFinishButton.setEnabled(true);
    }
}

