/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.project.dialogs;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.lttng.ui.views.project.dialogs.Messages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class TraceErrorDialog
extends SelectionStatusDialog {
    private String[] messages = null;

    public TraceErrorDialog(Shell parentShell, String[] newMessages) {
        super(parentShell);
        this.messages = newMessages;
        this.setTitle(Messages.TraceErrorDialog_DalogTitle);
        this.setStatusLineAboveButtons(true);
    }

    protected void computeResult() {
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(true);
        this.getButton(0).setAlignment(2);
        this.getButton(1).setVisible(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createFolderNameGroup(composite);
        return composite;
    }

    private void createFolderNameGroup(Composite parent) {
        Font font = parent.getFont();
        Composite folderGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 3;
        folderGroup.setLayout((Layout)layout);
        folderGroup.setLayoutData((Object)new GridData(768));
        GridData positionningData = new GridData(1040);
        Label lblMessage = new Label(folderGroup, 0);
        lblMessage.setFont(font);
        lblMessage.setText(Messages.TraceErrorDialog_DialogMsgLabel);
        lblMessage.setLayoutData((Object)positionningData);
        GC graphicContext = new GC((Drawable)parent);
        String longuestLine = "";
        int msgSize = 0;
        Font errorFont = new Font(graphicContext.getDevice(), font.getFontData()[0].getName(), font.getFontData()[0].getHeight(), 2);
        Label[] lblErrorMessages = new Label[this.messages.length];
        int x = 0;
        while (x < this.messages.length) {
            lblErrorMessages[x] = new Label(folderGroup, 0);
            lblErrorMessages[x].setFont(errorFont);
            lblErrorMessages[x].setForeground(new Color(lblErrorMessages[x].getForeground().getDevice(), 255, 0, 0));
            lblErrorMessages[x].setText(this.messages[x]);
            lblErrorMessages[x].setLayoutData((Object)positionningData);
            if (this.messages[x].length() > longuestLine.length()) {
                longuestLine = this.messages[x];
            }
            ++x;
        }
        int pos = 0;
        while (pos < longuestLine.length()) {
            msgSize += graphicContext.getAdvanceWidth(longuestLine.charAt(pos));
            ++pos;
        }
        positionningData.widthHint = msgSize += graphicContext.getAdvanceWidth('\n');
        positionningData.grabExcessHorizontalSpace = true;
        graphicContext.dispose();
    }

    protected void updateStatus(IStatus status) {
        if (status != null) {
            Status newStatus = new Status(0, status.getPlugin(), status.getCode(), status.getMessage(), status.getException());
            super.updateStatus((IStatus)newStatus);
        } else {
            super.updateStatus(status);
        }
    }

    protected void okPressed() {
        super.okPressed();
    }
}

