/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpmstubby;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.linuxtools.internal.rpmstubby.FeatureVisitor;
import org.eclipse.linuxtools.internal.rpmstubby.SpecfileWriter;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyLog;
import org.eclipse.linuxtools.internal.rpmstubby.model.IPackage;
import org.eclipse.linuxtools.internal.rpmstubby.model.IPackagePreamble;
import org.eclipse.linuxtools.internal.rpmstubby.model.MainPackage;
import org.eclipse.linuxtools.internal.rpmstubby.model.PackageItem;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.FeatureModel;
import org.eclipse.update.core.model.FeatureModelFactory;
import org.eclipse.update.core.model.ImportModel;
import org.eclipse.update.core.model.PluginEntryModel;
import org.eclipse.update.core.model.URLEntryModel;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StubbyPackageModel {
    private static final String VALUE_NOT_FOUND = "#FIXME";
    private String featurePropertiesFile;
    private IPath featureDir;
    private FeatureModel featureModel;
    private List<IFile> includedFeatureFiles = new ArrayList<IFile>();
    private List<String> includedFeatureIdentifiers;
    private List<String> includedFeatureIdentifiersAdded;

    public StubbyPackageModel(IFile featureFile) {
        this.featureDir = featureFile.getLocation().removeLastSegments(1);
        this.featurePropertiesFile = String.valueOf(this.featureDir.toOSString()) + "/feature.properties";
        FeatureModelFactory featureModelFactory = new FeatureModelFactory();
        try {
            this.featureModel = featureModelFactory.parseFeature(featureFile.getContents());
        }
        catch (CoreException e) {
            StubbyLog.logError(e);
        }
        catch (SAXException e) {
            StubbyLog.logError(e);
        }
    }

    public void populateDocFiles(MainPackage packageModel) {
        String[] files = this.featureDir.toFile().list();
        ArrayList<String> docFiles = new ArrayList<String>();
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            if (file.matches("(epl-.*|license)\\.html")) {
                docFiles.add(file);
            }
            ++n2;
        }
        packageModel.setDocFiles(docFiles);
        packageModel.setDocFilesRoot(this.featureDir.lastSegment());
    }

    public void populatePackageData(IPackage packageModel) {
        packageModel.setName(this.getFeatureName());
        packageModel.setVersion(this.getVersion());
        packageModel.setSummary(this.getSummary());
        packageModel.setDescription(this.getDescription());
        packageModel.setProvides(this.getProvides());
        packageModel.setRequires(this.getRequires());
    }

    public void populatePackagePreambleData(IPackagePreamble packagePreambleModel) {
        packagePreambleModel.setURL(this.getURL());
        packagePreambleModel.setLicense(this.getLicense());
    }

    public List<IFile> getIncudedFeatures() {
        FeatureModelFactory featureModelFactory = new FeatureModelFactory();
        IIncludedFeatureReference[] includedFeatureReferences = this.featureModel.getFeatureIncluded();
        this.includedFeatureIdentifiers = new ArrayList<String>();
        this.includedFeatureIdentifiersAdded = new ArrayList<String>();
        try {
            IProject[] projects;
            IIncludedFeatureReference[] iIncludedFeatureReferenceArray = includedFeatureReferences;
            int n = includedFeatureReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IIncludedFeatureReference includedFeatureReference = iIncludedFeatureReferenceArray[n2];
                VersionedIdentifier versionedIdentifier = includedFeatureReference.getVersionedIdentifier();
                this.includedFeatureIdentifiers.add(versionedIdentifier.getIdentifier());
                ++n2;
            }
            IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] iProjectArray = projects = workspace.getProjects();
            int n3 = projects.length;
            int n4 = 0;
            while (n4 < n3) {
                IProject project = iProjectArray[n4];
                FeatureVisitor featureVisitor = new FeatureVisitor();
                project.accept((IResourceVisitor)featureVisitor);
                for (IFile featureFile : featureVisitor.getFeatures()) {
                    FeatureModel includedFeatureModel = featureModelFactory.parseFeature(featureFile.getContents());
                    if (!this.isFeatureIncluded(includedFeatureModel.getFeatureIdentifier())) continue;
                    if (includedFeatureModel.getFeatureIncluded().length > 0) {
                        SpecfileWriter specfileWriter = new SpecfileWriter();
                        specfileWriter.write(featureFile);
                    } else {
                        this.includedFeatureIdentifiersAdded.add(includedFeatureModel.getFeatureIdentifier());
                    }
                    this.includedFeatureFiles.add(featureFile);
                }
                ++n4;
            }
        }
        catch (CoreException e) {
            StubbyLog.logError(e);
        }
        catch (SAXException e) {
            StubbyLog.logError(e);
        }
        return this.includedFeatureFiles;
    }

    public boolean isAllIncludedFeatureFound() {
        return this.includedFeatureFiles.size() == this.includedFeatureIdentifiers.size();
    }

    public String getMissingFeaturesAsString() {
        String toRet = "";
        for (String includedFeatureIdentifier : this.includedFeatureIdentifiers) {
            if (!this.includedFeatureIdentifiersAdded.contains(includedFeatureIdentifier)) {
                // empty if block
            }
            toRet = String.valueOf(toRet) + includedFeatureIdentifier + ", ";
        }
        return toRet.substring(0, toRet.length() - 2);
    }

    private boolean isFeatureIncluded(String featureIdetifier) {
        for (String includedFeatureIdentifier : this.includedFeatureIdentifiers) {
            if (!includedFeatureIdentifier.equals(featureIdetifier)) continue;
            for (String includedFeatureID : this.includedFeatureIdentifiersAdded) {
                if (!includedFeatureID.equals(featureIdetifier)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private String getFeatureName() {
        return this.featureModel.getFeatureIdentifier();
    }

    private String getVersion() {
        return this.featureModel.getFeatureVersion();
    }

    private String getSummary() {
        return this.resolveFeatureProperties(this.featureModel.getLabel());
    }

    private String getLicense() {
        String license = VALUE_NOT_FOUND;
        URLEntryModel licenseModel = this.featureModel.getLicenseModel();
        if (licenseModel != null) {
            String urlString = this.resolveFeatureProperties(licenseModel.getURLString());
            String urlAnotation = this.resolveFeatureProperties(licenseModel.getAnnotation());
            if (urlString != null && urlAnotation != null) {
                if (urlString.indexOf("epl") > -1 || urlAnotation.indexOf("epl") > -1) {
                    license = "EPL";
                } else if (urlString.indexOf("cpl") > -1 || urlAnotation.indexOf("cpl") > -1) {
                    license = "CPL";
                }
            }
        }
        return license;
    }

    private String getURL() {
        String url = VALUE_NOT_FOUND;
        URLEntryModel descriptionModel = this.featureModel.getDescriptionModel();
        if (descriptionModel != null && descriptionModel.getURLString() != null) {
            url = descriptionModel.getURLString();
        }
        return url;
    }

    private String getDescription() {
        URLEntryModel descriptionModel = this.featureModel.getDescriptionModel();
        if (descriptionModel.getAnnotation() != null) {
            String[] descriptionToken = this.resolveFeatureProperties(descriptionModel.getAnnotation()).split(" ");
            String description = String.valueOf(descriptionToken[0]) + " ";
            int lineLenght = descriptionToken[0].length() + 2;
            int i = 2;
            while (i < descriptionToken.length) {
                if ((lineLenght += descriptionToken[i].length() + 2) > 80) {
                    description = String.valueOf(description) + descriptionToken[i - 1] + "\n";
                    lineLenght = 0;
                } else {
                    description = String.valueOf(description) + descriptionToken[i - 1] + " ";
                }
                ++i;
            }
            description = String.valueOf(description) + descriptionToken[i - 1];
            return description;
        }
        return VALUE_NOT_FOUND;
    }

    private List<PackageItem> getProvides() {
        PluginEntryModel[] includedPlugins = this.featureModel.getPluginEntryModels();
        ArrayList<PackageItem> providesList = new ArrayList<PackageItem>();
        PluginEntryModel[] pluginEntryModelArray = includedPlugins;
        int n = includedPlugins.length;
        int n2 = 0;
        while (n2 < n) {
            PluginEntryModel includedPlugin = pluginEntryModelArray[n2];
            PackageItem provide = new PackageItem();
            provide.setName(includedPlugin.getPluginIdentifier());
            provide.setOperator("=");
            String pluginVersion = includedPlugin.getPluginVersion();
            if (pluginVersion.equals("0.0.0") && (pluginVersion = this.getBundleValue(provide.getName(), "Bundle-Version")) == null) {
                pluginVersion = "0.0.0";
            }
            provide.setVersion(pluginVersion);
            providesList.add(provide);
            ++n2;
        }
        PackageItem featureItem = new PackageItem();
        featureItem.setName(this.featureModel.getFeatureIdentifier());
        featureItem.setOperator("=");
        featureItem.setVersion(this.featureModel.getFeatureVersion());
        providesList.add(featureItem);
        return providesList;
    }

    private List<PackageItem> getRequires() {
        ImportModel[] importModels = this.featureModel.getImportModels();
        ArrayList<PackageItem> requiresList = new ArrayList<PackageItem>();
        ImportModel[] importModelArray = importModels;
        int n = importModels.length;
        int n2 = 0;
        while (n2 < n) {
            ImportModel importModel = importModelArray[n2];
            PackageItem require = new PackageItem();
            require.setName(importModel.getIdentifier());
            String pluginVersion = importModel.getVersion();
            String operator = "";
            if (pluginVersion.equals("0.0.0") && (pluginVersion = this.getBundleValue(require.getName(), "Bundle-Version")) == null) {
                pluginVersion = "0.0.0";
            }
            if (!pluginVersion.equals("0.0.0")) {
                require.setVersion(pluginVersion);
                operator = importModel.getMatchingRuleName().equals("greaterOrEqual") ? ">=" : (importModel.getMatchingRuleName().equals("greater") ? ">" : (importModel.getMatchingRuleName().equals("lessOrEqual") ? "<=" : (importModel.getMatchingRuleName().equals("less") ? "<" : "=")));
            } else {
                require.setVersion("");
            }
            require.setOperator(operator);
            requiresList.add(require);
            ++n2;
        }
        return requiresList;
    }

    private String resolveFeatureProperties(String key) {
        Properties properties = new Properties();
        if (key != null && key.startsWith("%")) {
            try {
                properties.load(new FileInputStream(this.featurePropertiesFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                StubbyLog.logError(e);
            }
            return properties.getProperty(key.replaceAll("%", ""));
        }
        return key;
    }

    private String getBundleValue(String bundleID, String bundleKey) {
        try {
            return (String)Platform.getBundle((String)bundleID).getHeaders().get(bundleKey);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }
}

