/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.ide.preferences;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.linuxtools.systemtap.ui.ide.internal.IDEPlugin;
import org.eclipse.linuxtools.systemtap.ui.ide.internal.Localization;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SyntaxColoringPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ColorFieldEditor stpDC;
    private ColorFieldEditor stpKC;
    private ColorFieldEditor stpEC;
    private ColorFieldEditor stpEE;
    private ColorFieldEditor stpCC;
    private ColorFieldEditor stpTC;
    private ColorFieldEditor stpSC;
    private ColorFieldEditor cDC;
    private ColorFieldEditor cKC;
    private ColorFieldEditor cPC;
    private ColorFieldEditor cCC;
    private ColorFieldEditor cTC;
    private ColorFieldEditor cSC;

    public SyntaxColoringPreferencePage() {
        LogManager.logDebug((String)"Start SyntaxColoringPreferencePage:", (Object)((Object)this));
        this.setPreferenceStore(IDEPlugin.getDefault().getPreferenceStore());
        this.setDescription(Localization.getString("SyntaxColoringPreferencePage.SyntaxColoringOptions"));
        LogManager.logDebug((String)"End SyntaxColoringPreferencePage:", (Object)((Object)this));
    }

    public void init(IWorkbench workbench) {
        LogManager.logInfo((String)"Initializing", (Object)((Object)this));
    }

    protected Control createContents(Composite parent) {
        LogManager.logDebug((String)("Start createContents: parent-" + parent), (Object)((Object)this));
        TabFolder tabFolder = new TabFolder(parent, 2048);
        TabItem stpEditor = new TabItem(tabFolder, 0);
        stpEditor.setText(Localization.getString("SyntaxColoringPreferencePage.STPEditor"));
        Composite comp = new Composite((Composite)tabFolder, 0);
        stpEditor.setControl((Control)comp);
        this.stpDC = this.createColorFieldEditor("stpDefaultColorPreference", Localization.getString("SyntaxColoringPreferencePage.DefaultColor"), comp);
        this.stpKC = this.createColorFieldEditor("stpKeywordColorPreference", Localization.getString("SyntaxColoringPreferencePage.KeywordColor"), comp);
        this.stpEC = this.createColorFieldEditor("stpEmbeddedCColorPreference", Localization.getString("SyntaxColoringPreferencePage.EmbeddedCColor"), comp);
        this.stpEE = this.createColorFieldEditor("stpEmbeddedColorPreference", Localization.getString("SyntaxColoringPreferencePage.EmbeddedColor"), comp);
        this.stpCC = this.createColorFieldEditor("stpCommentColorPreference", Localization.getString("SyntaxColoringPreferencePage.CommentColor"), comp);
        this.stpTC = this.createColorFieldEditor("stpTypeColorPreference", Localization.getString("SyntaxColoringPreferencePage.TypeColor"), comp);
        this.stpSC = this.createColorFieldEditor("stpStringColorPreference", Localization.getString("SyntaxColoringPreferencePage.StringColor"), comp);
        TabItem cEditor = new TabItem(tabFolder, 0);
        cEditor.setText(Localization.getString("SyntaxColoringPreferencePage.CEditor"));
        comp = new Composite((Composite)tabFolder, 0);
        cEditor.setControl((Control)comp);
        this.cDC = this.createColorFieldEditor("cDefaultColorPreference", Localization.getString("SyntaxColoringPreferencePage.DefaultColor"), comp);
        this.cKC = this.createColorFieldEditor("cKeywordColorPreference", Localization.getString("SyntaxColoringPreferencePage.KeywordColor"), comp);
        this.cPC = this.createColorFieldEditor("cPreprocessorColorPreference", Localization.getString("SyntaxColoringPreferencePage.PreprocessorColor"), comp);
        this.cCC = this.createColorFieldEditor("cCommentColorPreference", Localization.getString("SyntaxColoringPreferencePage.CommentColor"), comp);
        this.cTC = this.createColorFieldEditor("cTypeColorPreference", Localization.getString("SyntaxColoringPreferencePage.TypeColor"), comp);
        this.cSC = this.createColorFieldEditor("cStringColorPreference", Localization.getString("SyntaxColoringPreferencePage.StringColor"), comp);
        LogManager.logDebug((String)("End createContents: returnVal-" + tabFolder), (Object)((Object)this));
        return tabFolder;
    }

    private ColorFieldEditor createColorFieldEditor(String name, String lblText, Composite parent) {
        LogManager.logDebug((String)("Start createColorFieldEditor: name-" + name + ", lblText-" + lblText + ", parent-" + parent), (Object)((Object)this));
        ColorFieldEditor cfe = new ColorFieldEditor(name, lblText, parent);
        cfe.setPage((DialogPage)this);
        cfe.setPreferenceStore(this.getPreferenceStore());
        cfe.load();
        LogManager.logDebug((String)("End createColorFieldEditor: returnVal-" + cfe), (Object)((Object)this));
        return cfe;
    }

    protected void performDefaults() {
        LogManager.logDebug((String)"Start performDefaults:", (Object)((Object)this));
        this.stpDC.loadDefault();
        this.stpKC.loadDefault();
        this.stpEC.loadDefault();
        this.stpEE.loadDefault();
        this.stpCC.loadDefault();
        this.stpTC.loadDefault();
        this.stpSC.loadDefault();
        this.cDC.loadDefault();
        this.cKC.loadDefault();
        this.cPC.loadDefault();
        this.cCC.loadDefault();
        this.cTC.loadDefault();
        this.cSC.loadDefault();
        super.performDefaults();
        LogManager.logDebug((String)"End performDefaults:", (Object)((Object)this));
    }

    public boolean performOk() {
        LogManager.logDebug((String)"Start performOk:", (Object)((Object)this));
        this.stpDC.store();
        this.stpKC.store();
        this.stpEC.store();
        this.stpEE.store();
        this.stpCC.store();
        this.stpTC.store();
        this.stpSC.store();
        this.cDC.store();
        this.cKC.store();
        this.cPC.store();
        this.cCC.store();
        this.cTC.store();
        this.cSC.store();
        LogManager.logDebug((String)"End performOk returnVal-true", (Object)((Object)this));
        return true;
    }

    public void dispose() {
        LogManager.logInfo((String)"Disposing", (Object)((Object)this));
        super.dispose();
        this.stpDC.dispose();
        this.stpKC.dispose();
        this.stpEC.dispose();
        this.stpEE.dispose();
        this.stpCC.dispose();
        this.stpTC.dispose();
        this.stpSC.dispose();
        this.cDC.dispose();
        this.cKC.dispose();
        this.cPC.dispose();
        this.cCC.dispose();
        this.cTC.dispose();
        this.cSC.dispose();
        this.stpDC = null;
        this.stpKC = null;
        this.stpEC = null;
        this.stpEE = null;
        this.stpCC = null;
        this.stpTC = null;
        this.stpSC = null;
        this.cDC = null;
        this.cKC = null;
        this.cPC = null;
        this.cCC = null;
        this.cTC = null;
        this.cSC = null;
    }
}

