/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.event;

public class TmfTimestamp
implements Cloneable,
Comparable<TmfTimestamp> {
    protected long fValue;
    protected byte fScale;
    protected long fPrecision;
    public static final TmfTimestamp BigBang = new TmfTimestamp(Long.MIN_VALUE, 127, 0L);
    public static final TmfTimestamp BigCrunch = new TmfTimestamp(Long.MAX_VALUE, 127, 0L);
    public static final TmfTimestamp Zero = new TmfTimestamp(0L, 0, 0L);
    private static final long[] scalingFactors = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private static final long[] scalingLimits = new long[]{Long.MAX_VALUE, 0xCCCCCCCCCCCCCCCL, 92233720368547758L, 9223372036854775L, 922337203685477L, 92233720368547L, 9223372036854L, 922337203685L, 92233720368L, 9223372036L, 922337203L, 92233720L, 0x8CBCCCL, 922337L, 92233L, 9223L, 922L, 92L, 9L};

    public TmfTimestamp() {
        this(0L, 0, 0L);
    }

    public TmfTimestamp(long value) {
        this(value, 0, 0L);
    }

    public TmfTimestamp(long value, byte scale) {
        this(value, scale, 0L);
    }

    public TmfTimestamp(long value, byte scale, long precision) {
        this.fValue = value;
        this.fScale = scale;
        this.fPrecision = Math.abs(precision);
    }

    public TmfTimestamp(TmfTimestamp other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        this.fValue = other.fValue;
        this.fScale = other.fScale;
        this.fPrecision = other.fPrecision;
    }

    public long getValue() {
        return this.fValue;
    }

    public byte getScale() {
        return this.fScale;
    }

    public long getPrecision() {
        return this.fPrecision;
    }

    public TmfTimestamp synchronize(long offset, byte newScale) throws ArithmeticException {
        long newValue = this.fValue;
        long newPrecision = this.fPrecision;
        if (this.fScale == newScale && offset == 0L) {
            return this;
        }
        if (this.fScale != newScale) {
            int scaleDiff = Math.abs(this.fScale - newScale);
            if (scaleDiff >= scalingFactors.length) {
                throw new ArithmeticException("Scaling exception");
            }
            long scalingFactor = scalingFactors[scaleDiff];
            if (newScale < this.fScale) {
                newValue *= scalingFactor;
                newPrecision *= scalingFactor;
            } else {
                newValue /= scalingFactor;
                newPrecision /= scalingFactor;
            }
        }
        newValue = offset < 0L ? (newValue < Long.MIN_VALUE - offset ? Long.MIN_VALUE : newValue + offset) : (newValue > Long.MAX_VALUE - offset ? Long.MAX_VALUE : newValue + offset);
        return new TmfTimestamp(newValue, newScale, newPrecision);
    }

    public static long getScalingFactor(byte scale) {
        return scalingFactors[scale];
    }

    public long getAdjustment(TmfTimestamp reference, byte scale) throws ArithmeticException {
        TmfTimestamp ts1 = this.synchronize(0L, scale);
        TmfTimestamp ts2 = reference.synchronize(0L, scale);
        return ts2.fValue - ts1.fValue;
    }

    public TmfTimestamp getDelta(TmfTimestamp other) throws ArithmeticException {
        TmfTimestamp newSecond = other;
        if (this.fScale != other.fScale || this.fPrecision != other.fPrecision) {
            newSecond = other.synchronize(0L, this.fScale);
        }
        return new TmfTimestamp(this.fValue - newSecond.fValue, this.fScale, newSecond.fPrecision > this.fPrecision ? newSecond.fPrecision : this.fPrecision);
    }

    public int compareTo(TmfTimestamp other, boolean withinPrecision) {
        long limit;
        long factor;
        if (this.fScale == other.fScale) {
            if (withinPrecision) {
                return TmfTimestamp.compareWithinPrecision(this.fValue, this.fPrecision, other.fValue, other.fPrecision);
            }
            return TmfTimestamp.compareNoPrecision(this.fValue, other.fValue);
        }
        int scaleDiff = Math.abs(this.fScale - other.fScale);
        if (scaleDiff < scalingFactors.length) {
            factor = scalingFactors[scaleDiff];
            limit = scalingLimits[scaleDiff];
        } else {
            factor = 0L;
            limit = 0L;
        }
        if (this.fScale < other.fScale) {
            if (withinPrecision) {
                if (other.fValue > limit || other.fValue < -limit || other.fPrecision > limit || other.fPrecision < -limit) {
                    return other.fValue > 0L ? -1 : 1;
                }
                return TmfTimestamp.compareWithinPrecision(this.fValue, this.fPrecision, other.fValue * factor, other.fPrecision * factor);
            }
            if (other.fValue > limit || other.fValue < -limit) {
                return other.fValue > 0L ? -1 : 1;
            }
            return TmfTimestamp.compareNoPrecision(this.fValue, other.fValue * factor);
        }
        if (withinPrecision) {
            if (this.fValue > limit || this.fValue < -limit || this.fPrecision > limit || this.fPrecision < -limit) {
                return this.fValue > 0L ? 1 : -1;
            }
            return TmfTimestamp.compareWithinPrecision(this.fValue * factor, this.fPrecision * factor, other.fValue, other.fPrecision);
        }
        if (this.fValue > limit || this.fValue < -limit) {
            return this.fValue > 0L ? 1 : -1;
        }
        return TmfTimestamp.compareNoPrecision(this.fValue * factor, other.fValue);
    }

    private static int compareNoPrecision(long thisValue, long otherValue) {
        return thisValue == otherValue ? 0 : (thisValue < otherValue ? -1 : 1);
    }

    private static int compareWithinPrecision(long thisValue, long thisPrecision, long otherValue, long otherPrecision) {
        if (thisValue + thisPrecision < otherValue - otherPrecision) {
            return -1;
        }
        if (thisValue - thisPrecision > otherValue + otherPrecision) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (int)(this.fValue ^ this.fValue >>> 32);
        result = 37 * result + this.fScale;
        result = 37 * result + (int)(this.fPrecision ^ this.fPrecision >>> 32);
        return result;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TmfTimestamp)) {
            return false;
        }
        TmfTimestamp o = (TmfTimestamp)other;
        return this.compareTo(o, false) == 0;
    }

    public String toString() {
        return "[TmfTimestamp(" + this.fValue + "," + this.fScale + "," + this.fPrecision + ")]";
    }

    public TmfTimestamp clone() {
        TmfTimestamp clone = null;
        try {
            clone = (TmfTimestamp)super.clone();
            clone.fValue = this.fValue;
            clone.fScale = this.fScale;
            clone.fPrecision = this.fPrecision;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    @Override
    public int compareTo(TmfTimestamp o) {
        return this.compareTo(o, false);
    }
}

