/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.filter.model;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.event.TmfNoSuchFieldException;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.filter.model.ITmfFilterTreeNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterTreeNode;

public class TmfFilterCompareNode
extends TmfFilterTreeNode {
    public static final String NODE_NAME = "COMPARE";
    public static final String NOT_ATTR = "not";
    public static final String FIELD_ATTR = "field";
    public static final String RESULT_ATTR = "result";
    public static final String TYPE_ATTR = "type";
    public static final String VALUE_ATTR = "value";
    private boolean fNot = false;
    private String fField;
    private int fResult;
    private Type fType = Type.NUM;
    private String fValue;
    private Number fValueNumber;
    private TmfTimestamp fValueTimestamp;

    public TmfFilterCompareNode(ITmfFilterTreeNode parent) {
        super(parent);
    }

    public boolean isNot() {
        return this.fNot;
    }

    public void setNot(boolean not) {
        this.fNot = not;
    }

    public String getField() {
        return this.fField;
    }

    public void setField(String field) {
        this.fField = field;
    }

    public int getResult() {
        return this.fResult;
    }

    public void setResult(int result) {
        this.fResult = result;
    }

    public Type getType() {
        return this.fType;
    }

    public void setType(Type type) {
        this.fType = type;
        this.setValue(this.fValue);
    }

    public String getValue() {
        return this.fValue;
    }

    public void setValue(String value) {
        this.fValue = value;
        this.fValueNumber = null;
        this.fValueTimestamp = null;
        if (value == null) {
            return;
        }
        if (this.fType == Type.NUM) {
            try {
                this.fValueNumber = NumberFormat.getInstance().parse(value).doubleValue();
            }
            catch (ParseException parseException) {}
        } else if (this.fType == Type.TIMESTAMP) {
            try {
                this.fValueTimestamp = new TmfTimestamp((long)(1.0E9 * NumberFormat.getInstance().parse(value.toString()).doubleValue()));
            }
            catch (ParseException parseException) {}
        }
    }

    @Override
    public String getNodeName() {
        return NODE_NAME;
    }

    @Override
    public boolean matches(TmfEvent event) {
        try {
            Object value = event.getContent().getField(this.fField);
            if (value == null) {
                return this.fNot;
            }
            if (this.fType == Type.NUM) {
                if (this.fValueNumber instanceof Number) {
                    if (value instanceof Number) {
                        Double valueDouble = ((Number)value).doubleValue();
                        return valueDouble.compareTo(this.fValueNumber.doubleValue()) == this.fResult ^ this.fNot;
                    }
                    try {
                        Double valueDouble = NumberFormat.getInstance().parse(value.toString()).doubleValue();
                        return valueDouble.compareTo(this.fValueNumber.doubleValue()) == this.fResult ^ this.fNot;
                    }
                    catch (ParseException parseException) {}
                }
            } else {
                if (this.fType == Type.ALPHA) {
                    String valueString = value.toString();
                    return valueString.compareTo(this.fValue.toString()) == this.fResult ^ this.fNot;
                }
                if (this.fType == Type.TIMESTAMP && this.fValueTimestamp instanceof TmfTimestamp) {
                    if (value instanceof TmfTimestamp) {
                        TmfTimestamp valueTimestamp = (TmfTimestamp)value;
                        return valueTimestamp.compareTo(this.fValueTimestamp, false) == this.fResult ^ this.fNot;
                    }
                    try {
                        TmfTimestamp valueTimestamp = new TmfTimestamp((long)(1.0E9 * NumberFormat.getInstance().parse(value.toString()).doubleValue()));
                        return valueTimestamp.compareTo(this.fValueTimestamp, false) == this.fResult ^ this.fNot;
                    }
                    catch (ParseException parseException) {}
                }
            }
        }
        catch (TmfNoSuchFieldException tmfNoSuchFieldException) {}
        return this.fNot;
    }

    @Override
    public List<String> getValidChildren() {
        return new ArrayList<String>(0);
    }

    public String toString() {
        String open;
        String result;
        String string = this.fResult == 0 ? "= " : (result = this.fResult < 0 ? "< " : "> ");
        String string2 = this.fType == Type.NUM ? "" : (open = this.fType == Type.ALPHA ? "\"" : "[");
        String close = this.fType == Type.NUM ? "" : (this.fType == Type.ALPHA ? "\"" : "]");
        return String.valueOf(this.fField) + (this.fNot ? " not " : " ") + result + open + this.fValue + close;
    }

    @Override
    public ITmfFilterTreeNode clone() {
        TmfFilterCompareNode clone = (TmfFilterCompareNode)super.clone();
        clone.fField = new String(this.fField);
        clone.setValue(new String(this.fValue));
        return clone;
    }

    public static enum Type {
        NUM,
        ALPHA,
        TIMESTAMP;

    }
}

