/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.trace;

import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.trace.ITmfLocation;

public class TmfCheckpoint
implements Comparable<TmfCheckpoint>,
Cloneable {
    private TmfTimestamp fTimestamp;
    private ITmfLocation<? extends Comparable> fLocation;

    private TmfCheckpoint() {
        this.fTimestamp = null;
        this.fLocation = null;
    }

    public TmfCheckpoint(TmfTimestamp ts, ITmfLocation<? extends Comparable> location) {
        this.fTimestamp = ts;
        this.fLocation = location;
    }

    public TmfCheckpoint(TmfCheckpoint other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        this.fTimestamp = other.fTimestamp.clone();
        this.fLocation = other.fLocation.clone();
    }

    public TmfTimestamp getTimestamp() {
        return this.fTimestamp;
    }

    public ITmfLocation<?> getLocation() {
        return this.fLocation;
    }

    public TmfCheckpoint clone() {
        TmfCheckpoint result = null;
        try {
            result = (TmfCheckpoint)super.clone();
            result.fTimestamp = new TmfTimestamp(this.fTimestamp);
            result.fLocation = this.fLocation.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return result;
        }
    }

    public int hashCode() {
        return this.fTimestamp.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof TmfCheckpoint)) {
            return false;
        }
        TmfCheckpoint o = (TmfCheckpoint)other;
        return this.fTimestamp.equals(o.fTimestamp);
    }

    public String toString() {
        return "[TmfCheckpoint(" + this.fTimestamp + "," + this.fLocation + ")]";
    }

    @Override
    public int compareTo(TmfCheckpoint other) {
        if (this.fTimestamp == null || other.fTimestamp == null) {
            return this.fLocation.getLocation().compareTo(other.fLocation.getLocation());
        }
        return this.fTimestamp.compareTo(other.fTimestamp, false);
    }
}

