/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.parsers.custom;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.event.TmfEventReference;
import org.eclipse.linuxtools.tmf.event.TmfEventSource;
import org.eclipse.linuxtools.tmf.event.TmfEventType;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.io.BufferedRandomAccessFile;
import org.eclipse.linuxtools.tmf.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.trace.TmfContext;
import org.eclipse.linuxtools.tmf.trace.TmfLocation;
import org.eclipse.linuxtools.tmf.trace.TmfTrace;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomEventContent;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomTraceDefinition;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomXmlEvent;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomXmlEventType;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomXmlTraceContext;
import org.eclipse.linuxtools.tmf.ui.parsers.custom.CustomXmlTraceDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CustomXmlTrace
extends TmfTrace<CustomXmlEvent> {
    private static final TmfLocation<Long> NULL_LOCATION = new TmfLocation(null);
    private CustomXmlTraceDefinition fDefinition;
    private CustomXmlEventType fEventType;
    private CustomXmlTraceDefinition.InputElement fRecordInputElement;

    public CustomXmlTrace(String name, CustomXmlTraceDefinition definition, String path, int cacheSize) throws FileNotFoundException {
        super(name, CustomXmlEvent.class, path, cacheSize);
        this.fDefinition = definition;
        this.fEventType = new CustomXmlEventType(this.fDefinition);
        this.fRecordInputElement = this.getRecordInputElement(this.fDefinition.rootInputElement);
    }

    public TmfContext seekLocation(ITmfLocation<?> location) {
        CustomXmlTraceContext context = new CustomXmlTraceContext((ITmfLocation<?>)NULL_LOCATION, -1L);
        if (NULL_LOCATION.equals(location) || !new File(this.getPath()).isFile()) {
            return context;
        }
        try {
            String line;
            context.raFile = new BufferedRandomAccessFile(this.getPath(), "r");
            if (location != null && location.getLocation() instanceof Long) {
                context.raFile.seek(((Long)location.getLocation()).longValue());
            }
            String recordElementStart = "<" + this.fRecordInputElement.elementName;
            long rawPos = context.raFile.getFilePointer();
            while ((line = context.raFile.getNextLine()) != null) {
                int idx = line.indexOf(recordElementStart);
                if (idx != -1) {
                    context.setLocation((ITmfLocation)new TmfLocation((Comparable)Long.valueOf(rawPos + (long)idx)));
                    return context;
                }
                rawPos = context.raFile.getFilePointer();
            }
            return context;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return context;
        }
        catch (IOException e) {
            e.printStackTrace();
            return context;
        }
    }

    public TmfContext seekLocation(double ratio) {
        try {
            BufferedRandomAccessFile raFile = new BufferedRandomAccessFile(this.getPath(), "r");
            long pos = (long)(ratio * (double)raFile.length());
            while (pos > 0L) {
                raFile.seek(pos - 1L);
                if (raFile.read() == 10) break;
                --pos;
            }
            TmfLocation location = new TmfLocation((Comparable)new Long(pos));
            TmfContext context = this.seekLocation((ITmfLocation<?>)location);
            context.setRank(-2L);
            return context;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return new CustomXmlTraceContext((ITmfLocation<?>)NULL_LOCATION, -1L);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new CustomXmlTraceContext((ITmfLocation<?>)NULL_LOCATION, -1L);
        }
    }

    public double getLocationRatio(ITmfLocation<?> location) {
        try {
            if (location.getLocation() instanceof Long) {
                RandomAccessFile raFile = new RandomAccessFile(this.getPath(), "r");
                return (double)((Long)location.getLocation()).longValue() / (double)raFile.length();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    public ITmfTrace copy() {
        return null;
    }

    public ITmfLocation<?> getCurrentLocation() {
        return null;
    }

    public synchronized TmfEvent getNextEvent(TmfContext context) {
        TmfContext savedContext = context.clone();
        TmfEvent event = this.parseEvent(context);
        if (event != null) {
            this.updateIndex((ITmfContext)savedContext, savedContext.getRank(), event.getTimestamp());
            context.updateRank(1);
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TmfEvent parseEvent(TmfContext tmfContext) {
        if (!(tmfContext instanceof CustomXmlTraceContext)) {
            return null;
        }
        CustomXmlTraceContext context = (CustomXmlTraceContext)tmfContext;
        if (!(context.getLocation().getLocation() instanceof Long) || NULL_LOCATION.equals((Object)context.getLocation())) {
            return null;
        }
        BufferedRandomAccessFile bufferedRandomAccessFile = context.raFile;
        synchronized (bufferedRandomAccessFile) {
            CustomXmlEvent event = null;
            try {
                String line;
                if (context.raFile.getFilePointer() != (Long)context.getLocation().getLocation() + 1L) {
                    context.raFile.seek((Long)context.getLocation().getLocation() + 1L);
                }
                StringBuffer elementBuffer = new StringBuffer("<");
                this.readElement(elementBuffer, (RandomAccessFile)context.raFile);
                Element element = this.parseElementBuffer(elementBuffer);
                event = this.extractEvent(element, this.fRecordInputElement);
                ((StringBuffer)event.getContent().getContent()).append(elementBuffer);
                String recordElementStart = "<" + this.fRecordInputElement.elementName;
                long rawPos = context.raFile.getFilePointer();
                while ((line = context.raFile.getNextLine()) != null) {
                    int idx = line.indexOf(recordElementStart);
                    if (idx != -1) {
                        context.setLocation((ITmfLocation)new TmfLocation((Comparable)Long.valueOf(rawPos + (long)idx)));
                        return event;
                    }
                    rawPos = context.raFile.getFilePointer();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            context.setLocation((ITmfLocation)NULL_LOCATION);
            return event;
        }
    }

    private Element parseElementBuffer(StringBuffer elementBuffer) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            EntityResolver resolver = new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    String empty = "";
                    ByteArrayInputStream bais = new ByteArrayInputStream(empty.getBytes());
                    return new InputSource(bais);
                }
            };
            db.setEntityResolver(resolver);
            db.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException saxparseexception) throws SAXException {
                }

                @Override
                public void warning(SAXParseException saxparseexception) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException saxparseexception) throws SAXException {
                    throw saxparseexception;
                }
            });
            Document doc = db.parse(new ByteArrayInputStream(elementBuffer.toString().getBytes()));
            return doc.getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void readElement(StringBuffer buffer, RandomAccessFile raFile) {
        try {
            int i;
            int numRead = 0;
            boolean startTagClosed = false;
            while ((i = raFile.read()) != -1) {
                ++numRead;
                char c = (char)i;
                buffer.append(c);
                if (c == '\"') {
                    this.readQuote(buffer, raFile, '\"');
                    continue;
                }
                if (c == '\'') {
                    this.readQuote(buffer, raFile, '\'');
                    continue;
                }
                if (c == '<') {
                    this.readElement(buffer, raFile);
                    continue;
                }
                if (c == '/' && numRead == 1) break;
                if (c == '-' && numRead == 3 && buffer.substring(buffer.length() - 3, buffer.length() - 1).equals("!-")) {
                    this.readComment(buffer, raFile);
                    continue;
                }
                if (i != 62) continue;
                if (buffer.charAt(buffer.length() - 2) == '/' || startTagClosed) break;
                startTagClosed = true;
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void readQuote(StringBuffer buffer, RandomAccessFile raFile, char eq) {
        try {
            int i;
            while ((i = raFile.read()) != -1) {
                char c = (char)i;
                buffer.append(c);
                if (c == eq) break;
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void readComment(StringBuffer buffer, RandomAccessFile raFile) {
        try {
            int i;
            int numRead = 0;
            while ((i = raFile.read()) != -1) {
                char c = (char)i;
                buffer.append(c);
                if (c == '>' && ++numRead >= 2 && buffer.substring(buffer.length() - 3, buffer.length() - 1).equals("--")) break;
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static StringBuffer parseElement(Element parentElement, StringBuffer buffer) {
        NodeList nodeList = parentElement.getChildNodes();
        String separator = null;
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                if (separator == null) {
                    separator = " | ";
                } else {
                    buffer.append(separator);
                }
                Element element = (Element)node;
                if (!element.hasChildNodes()) {
                    buffer.append(element.getNodeName());
                } else if (element.getChildNodes().getLength() == 1 && element.getFirstChild().getNodeType() == 3) {
                    buffer.append(String.valueOf(element.getNodeName()) + ":" + element.getFirstChild().getNodeValue().trim());
                } else {
                    buffer.append(element.getNodeName());
                    buffer.append(" [ ");
                    CustomXmlTrace.parseElement(element, buffer);
                    buffer.append(" ]");
                }
            } else if (node.getNodeType() == 3 && node.getNodeValue().trim().length() != 0) {
                buffer.append(node.getNodeValue().trim());
            }
            ++i;
        }
        return buffer;
    }

    public CustomXmlTraceDefinition.InputElement getRecordInputElement(CustomXmlTraceDefinition.InputElement inputElement) {
        if (inputElement.logEntry) {
            return inputElement;
        }
        if (inputElement.childElements != null) {
            for (CustomXmlTraceDefinition.InputElement childInputElement : inputElement.childElements) {
                CustomXmlTraceDefinition.InputElement recordInputElement = this.getRecordInputElement(childInputElement);
                if (recordInputElement == null) continue;
                return recordInputElement;
            }
        }
        return null;
    }

    public CustomXmlEvent extractEvent(Element element, CustomXmlTraceDefinition.InputElement inputElement) {
        CustomXmlEvent event = new CustomXmlEvent(this.fDefinition, TmfTimestamp.Zero, new TmfEventSource((Object)""), (TmfEventType)this.fEventType, new TmfEventReference((Object)""));
        event.setContent(new CustomEventContent(event, new StringBuffer()));
        this.parseElement(element, event, inputElement);
        return event;
    }

    private void parseElement(Element element, CustomXmlEvent event, CustomXmlTraceDefinition.InputElement inputElement) {
        if (inputElement.inputName != null && !inputElement.inputName.equals(CustomXmlTraceDefinition.TAG_IGNORE)) {
            event.parseInput(CustomXmlTrace.parseElement(element, new StringBuffer()).toString(), inputElement.inputName, inputElement.inputAction, inputElement.inputFormat);
        }
        if (inputElement.attributes != null) {
            for (CustomXmlTraceDefinition.InputAttribute attribute : inputElement.attributes) {
                event.parseInput(element.getAttribute(attribute.attributeName), attribute.inputName, attribute.inputAction, attribute.inputFormat);
            }
        }
        NodeList childNodes = element.getChildNodes();
        if (inputElement.childElements != null) {
            int i = 0;
            while (i < childNodes.getLength()) {
                Node node = childNodes.item(i);
                if (node instanceof Element) {
                    for (CustomXmlTraceDefinition.InputElement child : inputElement.childElements) {
                        if (!node.getNodeName().equals(child.elementName)) continue;
                        this.parseElement((Element)node, event, child);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    public CustomTraceDefinition getDefinition() {
        return this.fDefinition;
    }
}

