/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.statistics.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.ui.views.statistics.ITmfExtraEventInfo;
import org.eclipse.linuxtools.tmf.ui.views.statistics.model.TmfStatisticsTreeNode;
import org.eclipse.linuxtools.tmf.util.TmfFixedArray;

public abstract class AbsTmfStatisticsTree {
    protected static StringBuilder fBuilder = new StringBuilder();
    public static final TmfFixedArray<String> ROOT = new TmfFixedArray((Object[])new String[]{"root"});
    protected Map<String, Set<String>> fKeys;
    protected HashMap<TmfFixedArray<String>, TmfStatisticsTreeNode> fNodes = new HashMap();

    public static synchronized String mergeString(String ... strings) {
        fBuilder.setLength(0);
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            fBuilder.append(s);
            ++n2;
        }
        return fBuilder.toString();
    }

    public AbsTmfStatisticsTree() {
        this.fKeys = new HashMap<String, Set<String>>();
    }

    public TmfStatisticsTreeNode get(TmfFixedArray<String> path) {
        return this.fNodes.get(path);
    }

    public abstract Collection<TmfStatisticsTreeNode> getChildren(TmfFixedArray<String> var1);

    public abstract Collection<TmfStatisticsTreeNode> getAllChildren(TmfFixedArray<String> var1);

    public Map<String, Set<String>> getKeys() {
        return this.fKeys;
    }

    public TmfStatisticsTreeNode getOrCreate(TmfFixedArray<String> path) {
        TmfStatisticsTreeNode current = this.fNodes.get(path);
        if (current == null) {
            this.registerName(path);
            current = new TmfStatisticsTreeNode(path, this);
            this.fNodes.put(path, current);
        }
        return current;
    }

    public TmfStatisticsTreeNode getParent(TmfFixedArray<String> path) {
        if (path.size() == 1) {
            if (path.equals(ROOT)) {
                return null;
            }
            return this.get(ROOT);
        }
        return this.get((TmfFixedArray<String>)path.subArray(0, path.size() - 1));
    }

    public abstract void increase(TmfEvent var1, ITmfExtraEventInfo var2, int var3);

    public abstract void registerEvent(TmfEvent var1, ITmfExtraEventInfo var2);

    protected abstract void registerName(TmfFixedArray<String> var1);

    public void reset(TmfFixedArray<String> path) {
        for (TmfStatisticsTreeNode node : this.getAllChildren(path)) {
            this.reset(node.getPath());
            this.fNodes.remove(node.getPath());
        }
    }
}

