/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.tmf.component.TmfComponent;
import org.eclipse.linuxtools.tmf.event.TmfData;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.event.TmfEventField;
import org.eclipse.linuxtools.tmf.event.TmfNoSuchFieldException;
import org.eclipse.linuxtools.tmf.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.request.TmfEventRequest;
import org.eclipse.linuxtools.tmf.signal.TmfExperimentDisposedSignal;
import org.eclipse.linuxtools.tmf.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.signal.TmfRangeSynchSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.SDView;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Frame;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.Lifeline;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.core.SyncMessage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDAdvancedPagingProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDFilterProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.provider.ISDFindProvider;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.widgets.Criteria;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.widgets.FilterCriteria;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.handlers.widgets.FilterListDialog;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.impl.Messages;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.impl.TmfSyncMessage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.load.IUml2SDLoader;
import org.eclipse.linuxtools.tmf.uml2sd.ITmfSyncSequenceDiagramEvent;
import org.eclipse.linuxtools.tmf.uml2sd.TmfSyncSequenceDiagramEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

public class TmfUml2SDSyncLoader
extends TmfComponent
implements IUml2SDLoader,
ISDFindProvider,
ISDFilterProvider,
ISDAdvancedPagingProvider,
ISelectionListener {
    protected static final String TITLE = Messages.TmfUml2SDSyncLoader_ViewName;
    protected static final int DEFAULT_BLOCK_SIZE = 50000;
    protected static final int MAX_NUM_OF_MSG = 10000;
    protected static final long INITIAL_WINDOW_OFFSET = 100000000L;
    protected TmfExperiment<TmfEvent> fExperiment = null;
    protected ITmfEventRequest<TmfEvent> fIndexRequest = null;
    protected ITmfEventRequest<TmfEvent> fPageRequest = null;
    protected volatile boolean fIsSignalSent = false;
    protected volatile long fInitialWindow = 100000000L;
    protected SDView fView = null;
    protected Frame fFrame = null;
    protected List<ITmfSyncSequenceDiagramEvent> fEvents = new ArrayList<ITmfSyncSequenceDiagramEvent>();
    protected List<TmfTimeRange> fCheckPoints = new ArrayList<TmfTimeRange>(10000);
    protected volatile int fCurrentPage = 0;
    protected TmfTimestamp fCurrentTime = null;
    protected volatile boolean fIsSelect = false;
    protected SearchJob fFindJob = null;
    protected List<GraphNode> fFindResults = new ArrayList<GraphNode>();
    protected Criteria fFindCriteria = null;
    protected volatile int fCurrentFindIndex = 0;
    protected List<FilterCriteria> fFilterCriteria = null;
    protected ReentrantLock fLock = new ReentrantLock();

    public TmfUml2SDSyncLoader() {
        super(TITLE);
    }

    public TmfUml2SDSyncLoader(String name) {
        super(name);
    }

    public TmfTimestamp getCurrentTime() {
        this.fLock.lock();
        try {
            if (this.fCurrentTime != null) {
                TmfTimestamp tmfTimestamp = this.fCurrentTime.clone();
                return tmfTimestamp;
            }
            return null;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public void waitForCompletion() {
        this.fLock.lock();
        ITmfEventRequest<TmfEvent> request = this.fPageRequest;
        this.fLock.unlock();
        if (request != null) {
            try {
                request.waitForCompletion();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @TmfSignalHandler
    public void experimentSelected(TmfExperimentSelectedSignal<TmfEvent> signal) {
        this.fLock.lock();
        try {
            TmfExperiment exp = signal.getExperiment();
            if (!exp.equals(this.fExperiment)) {
                this.fExperiment = exp;
            }
            TmfTimeRange window = TmfTimeRange.Eternity;
            this.fIndexRequest = new TmfEventRequest<TmfEvent>(TmfEvent.class, window, Integer.MAX_VALUE, 50000, ITmfDataRequest.ExecutionType.BACKGROUND){
                private TmfTimestamp fFirstTime;
                private TmfTimestamp fLastTime;
                private int fNbSeqEvents;
                private List<ITmfSyncSequenceDiagramEvent> fSdEvents;
                {
                    this.fFirstTime = null;
                    this.fLastTime = null;
                    this.fNbSeqEvents = 0;
                    this.fSdEvents = new ArrayList<ITmfSyncSequenceDiagramEvent>(10000);
                }

                public void handleData(TmfEvent event) {
                    super.handleData((TmfData)event);
                    ITmfSyncSequenceDiagramEvent sdEvent = TmfUml2SDSyncLoader.this.getSequnceDiagramEvent(event);
                    if (sdEvent != null) {
                        ++this.fNbSeqEvents;
                        if (this.fFirstTime == null) {
                            this.fFirstTime = event.getTimestamp().clone();
                        }
                        this.fLastTime = event.getTimestamp().clone();
                        if (this.fNbSeqEvents % 10000 == 0) {
                            TmfUml2SDSyncLoader.this.fLock.lock();
                            try {
                                TmfUml2SDSyncLoader.this.fCheckPoints.add(new TmfTimeRange(this.fFirstTime, this.fLastTime));
                                if (TmfUml2SDSyncLoader.this.fView != null) {
                                    TmfUml2SDSyncLoader.this.fView.updateCoolBar();
                                }
                            }
                            finally {
                                TmfUml2SDSyncLoader.this.fLock.unlock();
                            }
                            this.fFirstTime = null;
                        }
                        if (this.fNbSeqEvents > 10000) {
                            return;
                        }
                        this.fSdEvents.add(sdEvent);
                        if (this.fNbSeqEvents == 10000) {
                            TmfUml2SDSyncLoader.this.fillCurrentPage(this.fSdEvents);
                        }
                    }
                }

                public void handleSuccess() {
                    if (this.fFirstTime != null && this.fLastTime != null) {
                        TmfUml2SDSyncLoader.this.fLock.lock();
                        try {
                            TmfUml2SDSyncLoader.this.fCheckPoints.add(new TmfTimeRange(this.fFirstTime, this.fLastTime));
                            if (TmfUml2SDSyncLoader.this.fView != null) {
                                TmfUml2SDSyncLoader.this.fView.updateCoolBar();
                            }
                        }
                        finally {
                            TmfUml2SDSyncLoader.this.fLock.unlock();
                        }
                    }
                    if (this.fNbSeqEvents <= 10000) {
                        TmfUml2SDSyncLoader.this.fillCurrentPage(this.fSdEvents);
                    }
                    super.handleSuccess();
                }

                public void handleCompleted() {
                    if (TmfUml2SDSyncLoader.this.fEvents.size() == 0) {
                        TmfUml2SDSyncLoader.this.fFrame = new Frame();
                        TmfUml2SDSyncLoader.this.fView.setFrameSync(TmfUml2SDSyncLoader.this.fFrame);
                    }
                    super.handleCompleted();
                }
            };
            this.fExperiment.sendRequest(this.fIndexRequest);
        }
        finally {
            this.fLock.unlock();
        }
    }

    @TmfSignalHandler
    public void experimentDisposed(TmfExperimentDisposedSignal<TmfEvent> signal) {
        this.fLock.lock();
        try {
            if (this.fIndexRequest != null && !this.fIndexRequest.isCompleted()) {
                this.fIndexRequest.cancel();
                this.fIndexRequest = null;
            }
            this.cancelOngoingRequests();
            if (this.fFilterCriteria != null) {
                this.fFilterCriteria.clear();
            }
            FilterListDialog.deactivateSavedGlobalFilters();
            this.resetLoader();
        }
        finally {
            this.fLock.unlock();
        }
    }

    @TmfSignalHandler
    public void synchToTime(TmfTimeSynchSignal signal) {
        this.fLock.lock();
        try {
            if (signal.getSource() != this && this.fFrame != null) {
                this.fCurrentTime = signal.getCurrentTime();
                this.fIsSelect = true;
                this.moveToMessage();
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    @TmfSignalHandler
    public void synchToTimeRange(TmfRangeSynchSignal signal) {
        this.fLock.lock();
        try {
            if (signal.getSource() != this && this.fFrame != null && !this.fIsSignalSent) {
                TmfTimeRange newTimeRange = signal.getCurrentRange();
                TmfTimestamp delta = newTimeRange.getEndTime().getDelta(newTimeRange.getStartTime());
                this.fInitialWindow = delta.getValue();
                this.fIsSelect = false;
                this.fCurrentTime = newTimeRange.getStartTime();
                this.moveToMessage();
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void setViewer(SDView viewer) {
        this.fLock.lock();
        try {
            this.fView = viewer;
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
            this.fView.setSDFindProvider(this);
            this.fView.setSDPagingProvider(this);
            this.fView.setSDFilterProvider(this);
            this.resetLoader();
            this.fExperiment = TmfExperiment.getCurrentExperiment();
            if (this.fExperiment != null) {
                this.experimentSelected((TmfExperimentSelectedSignal<TmfEvent>)new TmfExperimentSelectedSignal((Object)this, this.fExperiment));
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public String getTitleString() {
        return this.getName();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fLock.lock();
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
            this.fView.setSDFindProvider(null);
            this.fView.setSDPagingProvider(null);
            this.fView.setSDFilterProvider(null);
            this.fView = null;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public boolean isNodeSupported(int nodeType) {
        switch (nodeType) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getNodeName(int nodeType, String loaderClassName) {
        switch (nodeType) {
            case 0: {
                return Messages.TmfUml2SDSyncLoader_CategoryLifeline;
            }
            case 1: {
                return Messages.TmfUml2SDSyncLoader_CategoryMessage;
            }
        }
        return "";
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        StructuredSelection stSel;
        ISelection sel = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (sel != null && sel instanceof StructuredSelection && (stSel = (StructuredSelection)sel).getFirstElement() instanceof TmfSyncMessage) {
            TmfSyncMessage syncMsg = (TmfSyncMessage)stSel.getFirstElement();
            this.broadcast((TmfSignal)new TmfTimeSynchSignal((Object)this, syncMsg.getStartTime()));
        }
    }

    @Override
    public boolean find(Criteria toSearch) {
        this.fLock.lock();
        try {
            if (this.fFrame == null) {
                return false;
            }
            if (this.fFindResults == null || this.fFindCriteria == null || !this.fFindCriteria.compareTo(toSearch)) {
                List<GraphNode> selection;
                this.fFindResults = new CopyOnWriteArrayList<GraphNode>();
                this.fFindCriteria = toSearch;
                if (this.fFindCriteria.isLifeLineSelected()) {
                    int i = 0;
                    while (i < this.fFrame.lifeLinesCount()) {
                        if (this.fFindCriteria.matches(this.fFrame.getLifeline(i).getName())) {
                            this.fFindResults.add(this.fFrame.getLifeline(i));
                        }
                        ++i;
                    }
                }
                ArrayList<SyncMessage> msgs = new ArrayList<SyncMessage>();
                if (this.fFindCriteria.isSyncMessageSelected()) {
                    int i = 0;
                    while (i < this.fFrame.syncMessageCount()) {
                        if (this.fFindCriteria.matches(this.fFrame.getSyncMessage(i).getName())) {
                            msgs.add(this.fFrame.getSyncMessage(i));
                        }
                        ++i;
                    }
                }
                if (msgs.size() > 0) {
                    this.fFindResults.addAll(msgs);
                }
                this.fCurrentFindIndex = (selection = this.fView.getSDWidget().getSelection()) != null && selection.size() == 1 ? this.fFindResults.indexOf(selection.get(0)) + 1 : 0;
            } else {
                ++this.fCurrentFindIndex;
            }
            if (this.fFindResults.size() > this.fCurrentFindIndex) {
                GraphNode current = this.fFindResults.get(this.fCurrentFindIndex);
                this.fView.getSDWidget().moveTo(current);
                return true;
            }
            this.fFindResults = null;
            this.fCurrentFindIndex = 0;
            boolean bl = this.findInNextPages(this.fFindCriteria);
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void cancel() {
        this.cancelOngoingRequests();
    }

    @Override
    public boolean filter(List<?> filters) {
        this.fLock.lock();
        try {
            this.cancelOngoingRequests();
            List<?> list = filters;
            this.fFilterCriteria = new ArrayList(list);
            this.fillCurrentPage(this.fEvents);
        }
        finally {
            this.fLock.unlock();
        }
        return true;
    }

    @Override
    public boolean hasNextPage() {
        this.fLock.lock();
        try {
            int size = this.fCheckPoints.size();
            if (size > 0) {
                boolean bl = this.fCurrentPage < size - 1;
                return bl;
            }
        }
        finally {
            this.fLock.unlock();
        }
        return false;
    }

    @Override
    public boolean hasPrevPage() {
        this.fLock.lock();
        try {
            boolean bl = this.fCurrentPage > 0;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void nextPage() {
        this.fLock.lock();
        try {
            if (this.fCurrentPage >= this.fCheckPoints.size() - 1) {
                return;
            }
            this.cancelOngoingRequests();
            this.fCurrentTime = null;
            ++this.fCurrentPage;
            this.moveToPage();
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void prevPage() {
        this.fLock.lock();
        try {
            if (this.fCurrentPage <= 0) {
                return;
            }
            this.cancelOngoingRequests();
            this.fCurrentTime = null;
            --this.fCurrentPage;
            this.moveToPage();
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void firstPage() {
        this.fLock.lock();
        try {
            this.cancelOngoingRequests();
            this.fCurrentTime = null;
            this.fCurrentPage = 0;
            this.moveToPage();
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void lastPage() {
        this.fLock.lock();
        try {
            this.cancelOngoingRequests();
            this.fCurrentTime = null;
            this.fCurrentPage = this.fCheckPoints.size() - 1;
            this.moveToPage();
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public int currentPage() {
        this.fLock.lock();
        try {
            int n = this.fCurrentPage;
            return n;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public int pagesCount() {
        this.fLock.lock();
        try {
            int n = this.fCheckPoints.size();
            return n;
        }
        finally {
            this.fLock.unlock();
        }
    }

    @Override
    public void pageNumberChanged(int pageNumber) {
        this.fLock.lock();
        try {
            int size;
            this.cancelOngoingRequests();
            if (pageNumber < 0) {
                pageNumber = 0;
            }
            if (pageNumber > (size = this.fCheckPoints.size()) - 1) {
                pageNumber = size - 1;
            }
            this.fCurrentPage = pageNumber;
            this.moveToPage();
        }
        finally {
            this.fLock.unlock();
        }
    }

    public void broadcast(TmfSignal signal) {
        this.fIsSignalSent = true;
        super.broadcast(signal);
        this.fIsSignalSent = false;
    }

    protected void cancelOngoingRequests() {
        this.fLock.lock();
        try {
            if (this.fFindJob != null) {
                this.fFindJob.cancel();
            }
            this.fFindResults = null;
            this.fFindCriteria = null;
            this.fCurrentFindIndex = 0;
            if (this.fPageRequest != null && !this.fPageRequest.isCompleted()) {
                this.fPageRequest.cancel();
                this.fPageRequest = null;
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    protected void resetLoader() {
        this.fLock.lock();
        try {
            this.fCurrentTime = null;
            this.fEvents.clear();
            this.fCheckPoints.clear();
            this.fCurrentPage = 0;
            this.fCurrentFindIndex = 0;
            this.fFindCriteria = null;
            this.fFindResults = null;
            this.fInitialWindow = 100000000L;
            this.fView.setFrameSync(new Frame());
            this.fFrame = null;
        }
        finally {
            this.fLock.unlock();
        }
    }

    protected void fillCurrentPage(List<ITmfSyncSequenceDiagramEvent> events) {
        this.fLock.lock();
        try {
            this.fEvents = new ArrayList<ITmfSyncSequenceDiagramEvent>(events);
            if (this.fView != null) {
                this.fView.toggleWaitCursorAsync(true);
            }
        }
        finally {
            this.fLock.unlock();
        }
        final Frame frame = new Frame();
        if (events.size() > 0) {
            HashMap<String, Lifeline> nodeToLifelineMap = new HashMap<String, Lifeline>();
            frame.setName(Messages.TmfUml2SDSyncLoader_FrameName);
            int i = 0;
            while (i < events.size()) {
                Lifeline lifeline;
                ITmfSyncSequenceDiagramEvent sdEvent = events.get(i);
                if (nodeToLifelineMap.get(sdEvent.getSender()) == null && !this.filterLifeLine(sdEvent.getSender())) {
                    lifeline = new Lifeline();
                    lifeline.setName(sdEvent.getSender());
                    nodeToLifelineMap.put(sdEvent.getSender(), lifeline);
                    frame.addLifeLine(lifeline);
                }
                if (nodeToLifelineMap.get(sdEvent.getReceiver()) == null && !this.filterLifeLine(sdEvent.getReceiver())) {
                    lifeline = new Lifeline();
                    lifeline.setName(sdEvent.getReceiver());
                    nodeToLifelineMap.put(sdEvent.getReceiver(), lifeline);
                    frame.addLifeLine(lifeline);
                }
                ++i;
            }
            int eventOccurence = 1;
            int i2 = 0;
            while (i2 < events.size()) {
                TmfSyncSequenceDiagramEvent sdEvent = (TmfSyncSequenceDiagramEvent)events.get(i2);
                if (!this.filterMessage((ITmfSyncSequenceDiagramEvent)sdEvent)) {
                    Lifeline startLifeline = (Lifeline)nodeToLifelineMap.get(sdEvent.getSender());
                    Lifeline endLifeline = (Lifeline)nodeToLifelineMap.get(sdEvent.getReceiver());
                    if (startLifeline != null && endLifeline != null) {
                        int tmp = Math.max(startLifeline.getEventOccurrence(), endLifeline.getEventOccurrence());
                        eventOccurence = Math.max(eventOccurence, tmp);
                        startLifeline.setCurrentEventOccurrence(eventOccurence);
                        endLifeline.setCurrentEventOccurrence(eventOccurence);
                        TmfSyncMessage message = new TmfSyncMessage((ITmfSyncSequenceDiagramEvent)sdEvent, eventOccurence++);
                        message.setStartLifeline(startLifeline);
                        message.setEndLifeline(endLifeline);
                        message.setTime(sdEvent.getStartTime());
                        frame.addMessage(message);
                    }
                }
                ++i2;
            }
            this.fLock.lock();
            try {
                if (!this.fView.getSDWidget().isDisposed()) {
                    this.fView.getSDWidget().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TmfUml2SDSyncLoader.this.fLock.lock();
                            try {
                                if (TmfUml2SDSyncLoader.this.fView != null && !TmfUml2SDSyncLoader.this.fView.getSDWidget().isDisposed()) {
                                    TmfUml2SDSyncLoader.this.fFrame = frame;
                                    TmfUml2SDSyncLoader.this.fView.setFrame(TmfUml2SDSyncLoader.this.fFrame);
                                    if (TmfUml2SDSyncLoader.this.fCurrentTime != null) {
                                        TmfUml2SDSyncLoader.this.moveToMessageInPage();
                                    }
                                    if (TmfUml2SDSyncLoader.this.fFindCriteria != null) {
                                        TmfUml2SDSyncLoader.this.find(TmfUml2SDSyncLoader.this.fFindCriteria);
                                    }
                                    TmfUml2SDSyncLoader.this.fView.toggleWaitCursorAsync(false);
                                }
                            }
                            finally {
                                TmfUml2SDSyncLoader.this.fLock.unlock();
                            }
                        }
                    });
                }
            }
            finally {
                this.fLock.unlock();
            }
        }
    }

    protected void moveToMessage() {
        int page = 0;
        this.fLock.lock();
        try {
            page = this.getPage(this.fCurrentTime);
            if (page == this.fCurrentPage) {
                this.moveToMessageInPage();
                return;
            }
            this.fCurrentPage = page;
            this.moveToPage(false);
        }
        finally {
            this.fLock.unlock();
        }
    }

    protected void moveToMessageInPage() {
        this.fLock.lock();
        try {
            if (!this.fView.getSDWidget().isDisposed()) {
                if (Display.getCurrent() != null) {
                    TmfSyncMessage prevMessage = null;
                    TmfSyncMessage syncMessage = null;
                    boolean isExactTime = false;
                    int i = 0;
                    while (i < this.fFrame.syncMessageCount()) {
                        if (this.fFrame.getSyncMessage(i) instanceof TmfSyncMessage) {
                            syncMessage = (TmfSyncMessage)this.fFrame.getSyncMessage(i);
                            if (syncMessage.getStartTime().compareTo(this.fCurrentTime, false) == 0) {
                                isExactTime = true;
                                break;
                            }
                            if (syncMessage.getStartTime().compareTo(this.fCurrentTime, false) > 0 && prevMessage != null) {
                                syncMessage = prevMessage;
                                break;
                            }
                            prevMessage = syncMessage;
                        }
                        ++i;
                    }
                    if (this.fIsSelect && isExactTime) {
                        this.fView.getSDWidget().moveTo(syncMessage);
                    } else {
                        this.fView.getSDWidget().ensureVisible(syncMessage);
                        this.fView.getSDWidget().clearSelection();
                        this.fView.getSDWidget().redraw();
                    }
                } else {
                    this.fView.getSDWidget().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TmfUml2SDSyncLoader.this.moveToMessageInPage();
                        }
                    });
                }
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    protected void moveToPage() {
        this.moveToPage(true);
    }

    protected void moveToPage(boolean notifyAll) {
        TmfTimeRange window = TmfTimeRange.Eternity;
        this.fLock.lock();
        try {
            if (this.fCurrentPage > this.fCheckPoints.size()) {
                return;
            }
            window = this.fCheckPoints.get(this.fCurrentPage);
        }
        finally {
            this.fLock.unlock();
        }
        this.fPageRequest = new TmfEventRequest<TmfEvent>(TmfEvent.class, window, Integer.MAX_VALUE, 1, ITmfDataRequest.ExecutionType.FOREGROUND){
            private List<ITmfSyncSequenceDiagramEvent> fSdEvent;
            {
                this.fSdEvent = new ArrayList<ITmfSyncSequenceDiagramEvent>();
            }

            public void handleData(TmfEvent event) {
                super.handleData((TmfData)event);
                ITmfSyncSequenceDiagramEvent sdEvent = TmfUml2SDSyncLoader.this.getSequnceDiagramEvent(event);
                if (sdEvent != null) {
                    this.fSdEvent.add(sdEvent);
                }
            }

            public void handleSuccess() {
                TmfUml2SDSyncLoader.this.fillCurrentPage(this.fSdEvent);
                super.handleSuccess();
            }
        };
        this.fExperiment.sendRequest(this.fPageRequest);
        if (notifyAll) {
            TmfTimeRange timeRange = this.getSignalTimeRange(window.getStartTime());
            this.broadcast((TmfSignal)new TmfRangeSynchSignal((Object)this, timeRange, timeRange.getStartTime()));
        }
    }

    protected int getPage(TmfTimestamp time) {
        this.fLock.lock();
        try {
            int size = this.fCheckPoints.size();
            int page = 0;
            while (page < size) {
                TmfTimeRange timeRange = this.fCheckPoints.get(page);
                if (timeRange.getEndTime().compareTo(time, false) >= 0) break;
                ++page;
            }
            if (page >= size) {
                page = size - 1;
            }
            int n = page;
            return n;
        }
        finally {
            this.fLock.unlock();
        }
    }

    protected boolean findInNextPages(Criteria findCriteria) {
        this.fLock.lock();
        try {
            if (this.fFindJob != null) {
                return true;
            }
            int nextPage = this.fCurrentPage + 1;
            if (nextPage >= this.fCheckPoints.size()) {
                return false;
            }
            TmfTimeRange window = new TmfTimeRange(this.fCheckPoints.get(nextPage).getStartTime().clone(), this.fCheckPoints.get(this.fCheckPoints.size() - 1).getEndTime().clone());
            this.fFindJob = new SearchJob(findCriteria, window);
            this.fFindJob.schedule();
            this.fView.toggleWaitCursorAsync(true);
        }
        finally {
            this.fLock.unlock();
        }
        return true;
    }

    protected TmfTimeRange getSignalTimeRange(TmfTimestamp startTime) {
        this.fLock.lock();
        try {
            TmfTimestamp initialEndOfWindow = new TmfTimestamp(startTime.getValue() + this.fInitialWindow, startTime.getScale(), startTime.getPrecision());
            TmfTimeRange tmfTimeRange = new TmfTimeRange(startTime, initialEndOfWindow);
            return tmfTimeRange;
        }
        finally {
            this.fLock.unlock();
        }
    }

    protected boolean filterMessage(ITmfSyncSequenceDiagramEvent sdEvent) {
        this.fLock.lock();
        try {
            if (this.fFilterCriteria != null) {
                for (FilterCriteria criteria : this.fFilterCriteria) {
                    if (!criteria.isActive() || !criteria.getCriteria().isSyncMessageSelected() || !criteria.getCriteria().matches(sdEvent.getName())) continue;
                    return true;
                }
            }
        }
        finally {
            this.fLock.unlock();
        }
        return false;
    }

    protected boolean filterLifeLine(String lifeline) {
        this.fLock.lock();
        try {
            if (this.fFilterCriteria != null) {
                for (FilterCriteria criteria : this.fFilterCriteria) {
                    if (!criteria.isActive() || !criteria.getCriteria().isLifeLineSelected() || !criteria.getCriteria().matches(lifeline)) continue;
                    return true;
                }
            }
        }
        finally {
            this.fLock.unlock();
        }
        return false;
    }

    protected ITmfSyncSequenceDiagramEvent getSequnceDiagramEvent(TmfEvent tmfEvent) {
        String eventType = tmfEvent.getType().toString();
        if (eventType.contains(Messages.TmfUml2SDSyncCloader_EventTypeSend) || eventType.contains(Messages.TmfUml2SDSyncCloader_EventTypeReceive)) {
            try {
                Object sender = tmfEvent.getContent().getField(Messages.TmfUml2SDSyncCloader_FieldSender);
                Object receiver = tmfEvent.getContent().getField(Messages.TmfUml2SDSyncCloader_FieldReceiver);
                Object name = tmfEvent.getContent().getField(Messages.TmfUml2SDSyncCloader_FieldSignal);
                if (sender instanceof TmfEventField && receiver instanceof TmfEventField && name instanceof TmfEventField) {
                    TmfSyncSequenceDiagramEvent sdEvent = new TmfSyncSequenceDiagramEvent(tmfEvent, ((TmfEventField)sender).getValue().toString(), ((TmfEventField)receiver).getValue().toString(), ((TmfEventField)name).getValue().toString());
                    return sdEvent;
                }
            }
            catch (TmfNoSuchFieldException tmfNoSuchFieldException) {}
        }
        return null;
    }

    protected class SearchEventRequest
    extends TmfEventRequest<TmfEvent> {
        private final Criteria fCriteria;
        private IProgressMonitor fMonitor;
        private boolean fIsFound;
        private TmfTimestamp fFoundTime;

        public SearchEventRequest(TmfTimeRange range, int nbRequested, int blockSize, ITmfDataRequest.ExecutionType execType, Criteria criteria) {
            this(range, nbRequested, blockSize, execType, criteria, null);
        }

        public SearchEventRequest(TmfTimeRange range, int nbRequested, int blockSize, ITmfDataRequest.ExecutionType execType, Criteria criteria, IProgressMonitor monitor) {
            super(TmfEvent.class, range, nbRequested, blockSize, execType);
            this.fIsFound = false;
            this.fFoundTime = null;
            this.fCriteria = new Criteria(criteria);
            this.fMonitor = monitor;
        }

        public void handleData(TmfEvent event) {
            super.handleData((TmfData)event);
            if (this.fMonitor != null && this.fMonitor.isCanceled()) {
                super.cancel();
                return;
            }
            ITmfSyncSequenceDiagramEvent sdEvent = TmfUml2SDSyncLoader.this.getSequnceDiagramEvent(event);
            if (sdEvent != null) {
                if (this.fCriteria.isLifeLineSelected()) {
                    if (this.fCriteria.matches(sdEvent.getSender())) {
                        this.fFoundTime = event.getTimestamp().clone();
                        this.fIsFound = true;
                        super.cancel();
                    }
                    if (this.fCriteria.matches(sdEvent.getReceiver())) {
                        this.fFoundTime = event.getTimestamp().clone();
                        this.fIsFound = true;
                        super.cancel();
                    }
                }
                if (this.fCriteria.isSyncMessageSelected() && this.fCriteria.matches(sdEvent.getName())) {
                    this.fFoundTime = event.getTimestamp().clone();
                    this.fIsFound = true;
                    super.cancel();
                }
            }
        }

        public void handleCompleted() {
            super.handleCompleted();
        }

        public void setMonitor(IProgressMonitor monitor) {
            this.fMonitor = monitor;
        }

        public boolean isFound() {
            return this.fIsFound;
        }

        public TmfTimestamp getFoundTime() {
            return this.fFoundTime;
        }
    }

    protected class SearchJob
    extends Job {
        protected final SearchEventRequest fSearchRequest;

        public SearchJob(Criteria findCriteria, TmfTimeRange window) {
            super(Messages.TmfUml2SDSyncLoader_SearchJobDescrition);
            this.fSearchRequest = new SearchEventRequest(window, Integer.MAX_VALUE, 1, ITmfDataRequest.ExecutionType.FOREGROUND, findCriteria);
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.fSearchRequest.setMonitor(monitor);
            TmfUml2SDSyncLoader.this.fExperiment.sendRequest((ITmfDataRequest)this.fSearchRequest);
            try {
                this.fSearchRequest.waitForCompletion();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Object status = Status.OK_STATUS;
            if (this.fSearchRequest.isFound() && this.fSearchRequest.getFoundTime() != null) {
                TmfUml2SDSyncLoader.this.fCurrentTime = this.fSearchRequest.getFoundTime();
                TmfUml2SDSyncLoader.this.fIsSelect = false;
                if (!TmfUml2SDSyncLoader.this.fView.getSDWidget().isDisposed()) {
                    TmfUml2SDSyncLoader.this.fView.getSDWidget().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            TmfUml2SDSyncLoader.this.moveToMessage();
                        }
                    });
                }
            } else {
                status = monitor.isCanceled() ? Status.CANCEL_STATUS : new Status(2, "org.eclipse.linuxtools.tmf.ui", Messages.TmfUml2SDSyncLoader_SearchNotFound);
                this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
            }
            monitor.done();
            TmfUml2SDSyncLoader.this.fLock.lock();
            try {
                TmfUml2SDSyncLoader.this.fView.toggleWaitCursorAsync(false);
                TmfUml2SDSyncLoader.this.fFindJob = null;
            }
            finally {
                TmfUml2SDSyncLoader.this.fLock.unlock();
            }
            return status;
        }

        protected void canceling() {
            this.fSearchRequest.cancel();
            TmfUml2SDSyncLoader.this.fLock.lock();
            try {
                TmfUml2SDSyncLoader.this.fFindJob = null;
            }
            finally {
                TmfUml2SDSyncLoader.this.fLock.unlock();
            }
        }
    }
}

