/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.uml2sd.preferences;

import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.preferences.SDViewPref;
import org.eclipse.linuxtools.tmf.ui.views.uml2sd.util.SDMessages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SDViewerPage
extends PreferencePage
implements IWorkbenchPreferencePage,
SelectionListener {
    protected SDViewPref pref = null;
    protected ColorFieldEditor lineColor = null;
    protected ColorFieldEditor backGroundColor = null;
    protected ColorFieldEditor textColor = null;
    protected List classItemList = null;
    protected FontFieldEditor font = null;
    protected BooleanFieldEditor link = null;
    protected BooleanFieldEditor tooltip = null;
    protected BooleanFieldEditor noExternalTime = null;
    protected BooleanFieldEditor useGrad = null;
    protected Composite buttonArea;
    protected IntegerFieldEditor lifelineWidth = null;
    protected static final String TEMP_TAG = "_TEMP";

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite page = new Composite(parent, 0);
        GridLayout pageLayout = new GridLayout();
        pageLayout.numColumns = 2;
        GridData pageLayoutdata = new GridData(1808);
        page.setLayoutData((Object)pageLayoutdata);
        page.setLayout((Layout)pageLayout);
        this.tooltip = new BooleanFieldEditor("PREF_TOOLTIP", SDMessages._97, page);
        this.tooltip.setPreferenceStore(this.pref.getPreferenceStore());
        this.tooltip.load();
        this.link = new BooleanFieldEditor("PREF_LINK_FONT", SDMessages._82, page);
        this.link.setPreferenceStore(this.pref.getPreferenceStore());
        this.link.load();
        this.noExternalTime = new BooleanFieldEditor("PREF_EXCLUDE_EXTERNAL_TIME", SDMessages._83, page);
        this.noExternalTime.setPreferenceStore(this.pref.getPreferenceStore());
        this.noExternalTime.load();
        this.useGrad = new BooleanFieldEditor("PREF_USE_GRADIENT", SDMessages._84, page);
        this.useGrad.setPreferenceStore(this.pref.getPreferenceStore());
        this.useGrad.load();
        Label separator = new Label(page, 290);
        GridData sepData = new GridData(784);
        separator.setLayoutData((Object)sepData);
        Composite prefPage = new Composite(page, 0);
        GridLayout prefPageLayout = new GridLayout();
        prefPage.setLayoutData((Object)pageLayoutdata);
        prefPageLayout.numColumns = 1;
        prefPage.setLayout((Layout)prefPageLayout);
        this.lifelineWidth = new IntegerFieldEditor("PREF_LIFELINE_WIDTH", SDMessages._80, prefPage);
        this.lifelineWidth.setPreferenceStore(this.pref.getPreferenceStore());
        this.lifelineWidth.setValidRange(119, 500);
        this.lifelineWidth.load();
        new Label(prefPage, 290);
        new Label(prefPage, 290);
        this.classItemList = new List(prefPage, 2820);
        GridData tabItemLayoutdata = new GridData(1808);
        this.classItemList.setLayoutData((Object)tabItemLayoutdata);
        String[] fontList2 = SDViewPref.getFontList2();
        int i = 0;
        while (i < fontList2.length) {
            this.classItemList.add(fontList2[i]);
            ++i;
        }
        this.classItemList.setSelection(0);
        this.classItemList.addSelectionListener((SelectionListener)this);
        this.buttonArea = new Composite(prefPage, 0);
        GridData tabItemLayoutdata2 = new GridData(1296);
        this.buttonArea.setLayoutData((Object)tabItemLayoutdata2);
        GridLayout buttonAreaLayout = new GridLayout();
        buttonAreaLayout.numColumns = 1;
        this.buttonArea.setLayout((Layout)buttonAreaLayout);
        String[] fontList = SDViewPref.getFontList();
        this.font = new FontFieldEditor(fontList[0], "", SDMessages._81, this.buttonArea);
        this.font.getPreviewControl().setSize(500, 500);
        this.font.setPreferenceStore(this.pref.getPreferenceStore());
        this.font.load();
        this.backGroundColor = new ColorFieldEditor(String.valueOf(fontList[0]) + "_BACK_COLOR", SDMessages._85, this.buttonArea);
        this.backGroundColor.setPreferenceStore(this.pref.getPreferenceStore());
        this.backGroundColor.load();
        this.lineColor = new ColorFieldEditor(String.valueOf(fontList[0]) + "_FORE_COLOR", SDMessages._86, this.buttonArea);
        this.lineColor.setPreferenceStore(this.pref.getPreferenceStore());
        this.lineColor.load();
        this.textColor = new ColorFieldEditor(String.valueOf(fontList[0]) + "_TEXT_COLOR", SDMessages._87, this.buttonArea);
        this.textColor.setPreferenceStore(this.pref.getPreferenceStore());
        this.textColor.load();
        this.swapPref(true);
        Dialog.applyDialogFont((Control)page);
        return page;
    }

    public void init(IWorkbench workbench) {
        this.pref = SDViewPref.getInstance();
    }

    protected void performApply() {
        if (!this.lifelineWidth.isValid()) {
            this.lifelineWidth.showErrorMessage();
            return;
        }
        this.font.store();
        this.backGroundColor.store();
        this.lineColor.store();
        this.link.store();
        this.tooltip.store();
        this.noExternalTime.store();
        this.textColor.store();
        this.useGrad.store();
        this.lifelineWidth.store();
        this.swapPref(false);
        this.pref.apply();
        this.swapPref(true);
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    protected void performDefaults() {
        this.link.loadDefault();
        this.tooltip.loadDefault();
        this.noExternalTime.loadDefault();
        this.useGrad.loadDefault();
        this.lifelineWidth.loadDefault();
        Set<String> keySet = SDViewPref.getInstance().fontPref.keySet();
        for (String prefName : keySet) {
            if (!(prefName instanceof String)) continue;
            this.font.setPreferenceName(prefName);
            this.font.loadDefault();
            this.font.setPreferenceName(String.valueOf(prefName) + TEMP_TAG);
            this.font.store();
        }
        keySet = SDViewPref.getInstance().backColorPref.keySet();
        for (String prefName : keySet) {
            if (!(prefName instanceof String)) continue;
            this.backGroundColor.setPreferenceName(prefName);
            this.backGroundColor.loadDefault();
            this.backGroundColor.setPreferenceName(String.valueOf(prefName) + TEMP_TAG);
            this.backGroundColor.store();
        }
        String[] fontList = SDViewPref.getFontList();
        this.backGroundColor.setPreferenceName(String.valueOf(fontList[this.classItemList.getSelectionIndex()]) + "_BACK_COLOR" + TEMP_TAG);
        this.backGroundColor.load();
        keySet = SDViewPref.getInstance().foreColorPref.keySet();
        for (String prefName : keySet) {
            if (!(prefName instanceof String)) continue;
            this.lineColor.setPreferenceName(prefName);
            this.lineColor.loadDefault();
            this.lineColor.setPreferenceName(String.valueOf(prefName) + TEMP_TAG);
            this.lineColor.store();
        }
        this.lineColor.setPreferenceName(String.valueOf(fontList[this.classItemList.getSelectionIndex()]) + "_FORE_COLOR" + TEMP_TAG);
        this.lineColor.load();
        keySet = SDViewPref.getInstance().textColorPref.keySet();
        for (String prefName : keySet) {
            if (!(prefName instanceof String)) continue;
            this.textColor.setPreferenceName(prefName);
            this.textColor.loadDefault();
            this.textColor.setPreferenceName(String.valueOf(prefName) + TEMP_TAG);
            this.textColor.store();
        }
        this.textColor.setPreferenceName(String.valueOf(fontList[this.classItemList.getSelectionIndex()]) + "_TEXT_COLOR" + TEMP_TAG);
        this.textColor.load();
    }

    public void widgetSelected(SelectionEvent e) {
        this.font.store();
        this.lineColor.store();
        this.backGroundColor.store();
        this.textColor.store();
        String[] fontList = SDViewPref.getFontList();
        this.font.setPreferenceName(String.valueOf(fontList[this.classItemList.getSelectionIndex()]) + TEMP_TAG);
        this.font.load();
        this.backGroundColor.setPreferenceName(String.valueOf(fontList[this.classItemList.getSelectionIndex()]) + "_BACK_COLOR" + TEMP_TAG);
        this.backGroundColor.load();
        this.lineColor.setPreferenceName(String.valueOf(fontList[this.classItemList.getSelectionIndex()]) + "_FORE_COLOR" + TEMP_TAG);
        this.lineColor.load();
        this.textColor.setPreferenceName(String.valueOf(fontList[this.classItemList.getSelectionIndex()]) + "_TEXT_COLOR" + TEMP_TAG);
        this.textColor.load();
        if (fontList[this.classItemList.getSelectionIndex()].equals("PREF_SYNC_MESS") || fontList[this.classItemList.getSelectionIndex()].equals("PREF_SYNC_MESS_RET") || fontList[this.classItemList.getSelectionIndex()].equals("PREF_ASYNC_MESS") || fontList[this.classItemList.getSelectionIndex()].equals("PREF_ASYNC_MESS_RET")) {
            this.backGroundColor.setEnabled(false, this.buttonArea);
        } else {
            this.backGroundColor.setEnabled(true, this.buttonArea);
        }
        if (fontList[this.classItemList.getSelectionIndex()].equals("PREF_EXEC") || fontList[this.classItemList.getSelectionIndex()].equals("PREF_FRAME")) {
            this.textColor.setEnabled(false, this.buttonArea);
        } else {
            this.textColor.setEnabled(true, this.buttonArea);
        }
        if (fontList[this.classItemList.getSelectionIndex()].equals("PREF_FRAME")) {
            this.font.setEnabled(false, this.buttonArea);
        } else {
            this.font.setEnabled(true, this.buttonArea);
        }
    }

    protected void swapPref(boolean toTemp) {
        String TAG1 = "";
        String TAG2 = TEMP_TAG;
        if (!toTemp) {
            TAG1 = TEMP_TAG;
            TAG2 = "";
        }
        Set<String> keySet = SDViewPref.getInstance().fontPref.keySet();
        for (String prefName : keySet) {
            if (!(prefName instanceof String)) continue;
            this.font.setPreferenceName(String.valueOf(prefName) + TAG1);
            this.font.load();
            this.font.setPreferenceName(String.valueOf(prefName) + TAG2);
            this.font.store();
        }
        keySet = SDViewPref.getInstance().backColorPref.keySet();
        for (String prefName : keySet) {
            if (!(prefName instanceof String)) continue;
            this.backGroundColor.setPreferenceName(String.valueOf(prefName) + TAG1);
            this.backGroundColor.load();
            this.backGroundColor.setPreferenceName(String.valueOf(prefName) + TAG2);
            this.backGroundColor.store();
        }
        keySet = SDViewPref.getInstance().foreColorPref.keySet();
        for (String prefName : keySet) {
            if (!(prefName instanceof String)) continue;
            this.lineColor.setPreferenceName(String.valueOf(prefName) + TAG1);
            this.lineColor.load();
            this.lineColor.setPreferenceName(String.valueOf(prefName) + TAG2);
            this.lineColor.store();
        }
        keySet = SDViewPref.getInstance().textColorPref.keySet();
        for (String prefName : keySet) {
            if (!(prefName instanceof String)) continue;
            this.textColor.setPreferenceName(String.valueOf(prefName) + TAG1);
            this.textColor.load();
            this.textColor.setPreferenceName(String.valueOf(prefName) + TAG2);
            this.textColor.store();
        }
        String[] fontList = SDViewPref.getFontList();
        if (toTemp) {
            this.font.setPreferenceName(String.valueOf(fontList[this.classItemList.getSelectionIndex()]) + TEMP_TAG);
            this.font.load();
            this.backGroundColor.setPreferenceName(String.valueOf(fontList[this.classItemList.getSelectionIndex()]) + "_BACK_COLOR" + TEMP_TAG);
            this.backGroundColor.load();
            this.lineColor.setPreferenceName(String.valueOf(fontList[this.classItemList.getSelectionIndex()]) + "_FORE_COLOR" + TEMP_TAG);
            this.lineColor.load();
            this.textColor.setPreferenceName(String.valueOf(fontList[this.classItemList.getSelectionIndex()]) + "_TEXT_COLOR" + TEMP_TAG);
            this.textColor.load();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

