/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.core.latency.analyzer;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngEvent;

public class StackWrapper {
    private HashMap<String, Stack<LttngEvent>> fStacks = new HashMap();

    public void put(LttngEvent event) {
        String key = event.getMarkerName();
        if (this.fStacks.containsKey(key)) {
            this.fStacks.get(key).add(event);
        } else {
            Stack<LttngEvent> newStack = new Stack<LttngEvent>();
            newStack.add(event);
            this.fStacks.put(key, newStack);
        }
    }

    public boolean containsKey(String key) {
        return this.fStacks.containsKey(key);
    }

    public Stack<LttngEvent> getStackOf(String key) {
        return this.fStacks.get(key);
    }

    public boolean removeEvent(String key, LttngEvent event) {
        Stack<LttngEvent> stack = this.fStacks.get(key);
        boolean removed = false;
        try {
            stack.pop();
            removed = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (stack.isEmpty()) {
            this.fStacks.remove(key);
        }
        return removed;
    }

    public void clear() {
        this.fStacks.clear();
    }

    public void printContent() {
        Collection<Stack<LttngEvent>> values = this.fStacks.values();
        Iterator<Stack<LttngEvent>> valueIt = values.iterator();
        Set<String> keys = this.fStacks.keySet();
        Iterator<String> keyIt = keys.iterator();
        while (valueIt.hasNext() && keyIt.hasNext()) {
            Stack<LttngEvent> stack = valueIt.next();
            System.out.println("   " + keyIt.next() + " [" + stack.size() + "] : " + stack);
        }
    }
}

