/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.statistics.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.linuxtools.internal.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.internal.lttng.core.state.StateStrings;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngProcessState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngTraceState;
import org.eclipse.linuxtools.internal.lttng.ui.views.statistics.model.FixedArray;
import org.eclipse.linuxtools.internal.lttng.ui.views.statistics.model.Messages;
import org.eclipse.linuxtools.internal.lttng.ui.views.statistics.model.StatisticsData;
import org.eclipse.linuxtools.internal.lttng.ui.views.statistics.model.StatisticsTreeNode;

public class KernelStatisticsData
extends StatisticsData {
    public static final String HEADER_CPUS = Messages.KernelStatisticsData_CPUs;
    public static final int HEADER_CPUS_INT = -1073741568;
    public static final String HEADER_EVENT_TYPES = Messages.KernelStatisticsData_EventTypes;
    public static final int HEADER_EVENT_TYPES_INT = -1073741567;
    public static final String HEADER_FUNCTIONS = Messages.KernelStatisticsData_Functions;
    public static final int HEADER_FUNCTIONS_INT = -1073741566;
    public static final String HEADER_MODES = Messages.KernelStatisticsData_Modes;
    public static final int HEADER_MODES_INT = -1073741565;
    public static final String HEADER_PROCESSES = Messages.KernelStatisticsData_Processes;
    public static final int HEADER_PROCESSES_INT = -1073741564;
    public static final String HEADER_SUBMODES = Messages.KernelStatisticsData_SubModes;
    public static final int HEADER_SUBMODES_INT = -1073741563;
    private ProcessKeyProvider fPidKeys = new ProcessKeyProvider(-1610612736);
    private KeyProvider fTypeKeys = new KeyProvider(-1342177280);
    private KeyProvider fSubModeKeys = new KeyProvider();
    private static final int PLACE_HOLDER = 0;
    private final FixedArray[] fTypedPaths = new FixedArray[]{new FixedArray(0, -1073741567, 0), new FixedArray(0, -1073741565, 0, -1073741567, 0), new FixedArray(0, -1073741565, 0, -1073741563, 0, -1073741567, 0), new FixedArray(0, -1073741564, 0, -1073741567, 0), new FixedArray(0, -1073741564, 0, -1073741568, 0, -1073741567, 0), new FixedArray(0, -1073741564, 0, -1073741568, 0, -1073741566, 0, -1073741567, 0), new FixedArray(0, -1073741564, 0, -1073741568, 0, -1073741566, 0, -1073741565, 0, -1073741567, 0), new FixedArray(0, -1073741564, 0, -1073741568, 0, -1073741566, 0, -1073741565, 0, -1073741563, 0, -1073741567, 0), new FixedArray(0, -1073741564, 0, -1073741568, 0, -1073741565, 0, -1073741567, 0), new FixedArray(0, -1073741564, 0, -1073741568, 0, -1073741565, 0, -1073741563, 0, -1073741567, 0), new FixedArray(0, -1073741564, 0, -1073741565, 0, -1073741567, 0), new FixedArray(0, -1073741564, 0, -1073741565, 0, -1073741563, 0, -1073741567, 0), new FixedArray(0, -1073741568, 0, -1073741567, 0), new FixedArray(0, -1073741568, 0, -1073741565, 0, -1073741567, 0), new FixedArray(0, -1073741568, 0, -1073741565, 0, -1073741563, 0, -1073741567, 0)};
    final FixedArray[] fNormalPaths = new FixedArray[]{new FixedArray(0), new FixedArray(0, -1073741565, 0), new FixedArray(0, -1073741565, 0, -1073741563, 0), new FixedArray(0, -1073741564, 0), new FixedArray(0, -1073741564, 0, -1073741568, 0), new FixedArray(0, -1073741564, 0, -1073741568, 0, -1073741566, 0), new FixedArray(0, -1073741564, 0, -1073741568, 0, -1073741566, 0, -1073741565, 0), new FixedArray(0, -1073741564, 0, -1073741568, 0, -1073741566, 0, -1073741565, 0, -1073741563, 0), new FixedArray(0, -1073741564, 0, -1073741568, 0, -1073741565, 0), new FixedArray(0, -1073741564, 0, -1073741568, 0, -1073741565, 0, -1073741563, 0), new FixedArray(0, -1073741564, 0, -1073741565, 0), new FixedArray(0, -1073741564, 0, -1073741565, 0, -1073741563, 0), new FixedArray(0, -1073741568, 0), new FixedArray(0, -1073741568, 0, -1073741565, 0), new FixedArray(0, -1073741568, 0, -1073741565, 0, -1073741563, 0)};
    private static final Integer NODE = -1;
    private static final Integer ROOT_NODE_KEY = -2;

    public KernelStatisticsData(String traceName) {
        Map<Integer, Set<Integer>> keys = this.getKeys();
        keys.put(-1073741564, new HashSet());
        keys.put(-1073741565, new HashSet());
        keys.put(-1073741568, new HashSet(4));
        keys.put(-1073741563, new HashSet());
        keys.put(-1073741567, new HashSet());
        keys.put(-1073741566, new HashSet(4));
        HashSet<Integer> temp = new HashSet<Integer>(8);
        temp.add(-1073741564);
        temp.add(-1073741565);
        temp.add(-1073741568);
        temp.add(-1073741567);
        keys.put(ROOT_NODE_KEY, temp);
        temp = new HashSet(4);
        temp.add(-1073741565);
        temp.add(-1073741568);
        temp.add(-1073741567);
        keys.put(-1073741564 * NODE, temp);
        temp = new HashSet(4);
        temp.add(-1073741565);
        temp.add(-1073741567);
        keys.put(-1073741568 * NODE, temp);
        temp = new HashSet(4);
        temp.add(-1073741565);
        temp.add(-1073741567);
        keys.put(-1073741566 * NODE, temp);
        temp = new HashSet(4);
        temp.add(-1073741563);
        temp.add(-1073741567);
        keys.put(-1073741565 * NODE, temp);
        temp = new HashSet(2);
        temp.add(-1073741567);
        keys.put(-1073741563 * NODE, temp);
        temp = new HashSet(16);
        keys.put(-1073741567 * NODE, temp);
        keys.put(ROOT.get(0), new HashSet(2));
        StatisticsTreeNode node = this.getOrCreate(ROOT);
        node.setName("root");
    }

    @Override
    public void endTraceset(LttngEvent event, LttngTraceState traceState) {
    }

    @Override
    public Collection<StatisticsTreeNode> getChildren(FixedArray path) {
        LinkedList<StatisticsTreeNode> result = new LinkedList<StatisticsTreeNode>();
        if (path.size() % 2 == 0) {
            StatisticsTreeNode current = null;
            for (int value : this.getKeys().get(path.get(path.size() - 1))) {
                current = this.get(path.append(value));
                if (current == null || current.getValue().nbEvents == 0L) continue;
                result.add(current);
            }
        } else if (path.size() == 1) {
            if (path.equals(ROOT)) {
                for (int value : this.getKeys().get(ROOT.get(0))) {
                    result.add(this.getOrCreate(new FixedArray(value)));
                }
            } else {
                for (int value : this.getKeys().get(ROOT_NODE_KEY)) {
                    StatisticsTreeNode node = this.getOrCreate(path.append(value));
                    node.setName(KernelStatisticsData.getCategoryFromId(value));
                    result.add(node);
                }
            }
        } else {
            for (int value : this.getKeys().get(path.get(path.size() - 2) * NODE)) {
                StatisticsTreeNode node = this.getOrCreate(path.append(value));
                node.setName(KernelStatisticsData.getCategoryFromId(value));
                result.add(node);
            }
            if (path.size() == 5 && path.get(3) == -1073741568) {
                StatisticsTreeNode node = this.getOrCreate(path.append(-1073741566));
                node.setName(KernelStatisticsData.getCategoryFromId(-1073741566));
                result.add(node);
            }
        }
        return result;
    }

    private FixedArray[] getNormalPaths(LttngEvent event, LttngTraceState traceState) {
        int trace = (int)traceState.getContext().getIdentifier();
        Long cpu = event.getCpuId();
        int cpus = cpu.intValue() | 0x70000000;
        LttngProcessState process = (LttngProcessState)traceState.getRunning_process().get(cpu);
        int processName = this.fPidKeys.getUniqueId(process.getPid().intValue(), process.getCpu().intValue(), process.getCreation_time());
        int mode = process.getState().getExec_mode().ordinal() | Integer.MIN_VALUE;
        int submode = this.fSubModeKeys.getUniqueId(process.getState().getExec_submode_id(), process.getState().getExec_submode());
        int function = process.getCurrent_function().intValue() | 0x90000000;
        this.fNormalPaths[0].set(0, trace);
        this.fNormalPaths[1].set(0, trace);
        this.fNormalPaths[1].set(2, mode);
        this.fNormalPaths[2].set(0, trace);
        this.fNormalPaths[2].set(2, mode);
        this.fNormalPaths[2].set(4, submode);
        this.fNormalPaths[3].set(0, trace);
        this.fNormalPaths[3].set(2, processName);
        this.fNormalPaths[4].set(0, trace);
        this.fNormalPaths[4].set(2, processName);
        this.fNormalPaths[4].set(4, cpus);
        this.fNormalPaths[5].set(0, trace);
        this.fNormalPaths[5].set(2, processName);
        this.fNormalPaths[5].set(4, cpus);
        this.fNormalPaths[5].set(6, function);
        this.fNormalPaths[6].set(0, trace);
        this.fNormalPaths[6].set(2, processName);
        this.fNormalPaths[6].set(4, cpus);
        this.fNormalPaths[6].set(6, function);
        this.fNormalPaths[6].set(8, mode);
        this.fNormalPaths[7].set(0, trace);
        this.fNormalPaths[7].set(2, processName);
        this.fNormalPaths[7].set(4, cpus);
        this.fNormalPaths[7].set(6, function);
        this.fNormalPaths[7].set(8, mode);
        this.fNormalPaths[7].set(10, submode);
        this.fNormalPaths[8].set(0, trace);
        this.fNormalPaths[8].set(2, processName);
        this.fNormalPaths[8].set(4, cpus);
        this.fNormalPaths[8].set(6, mode);
        this.fNormalPaths[9].set(0, trace);
        this.fNormalPaths[9].set(2, processName);
        this.fNormalPaths[9].set(4, cpus);
        this.fNormalPaths[9].set(6, mode);
        this.fNormalPaths[9].set(8, submode);
        this.fNormalPaths[10].set(0, trace);
        this.fNormalPaths[10].set(2, processName);
        this.fNormalPaths[10].set(4, mode);
        this.fNormalPaths[11].set(0, trace);
        this.fNormalPaths[11].set(2, processName);
        this.fNormalPaths[11].set(4, mode);
        this.fNormalPaths[11].set(6, submode);
        this.fNormalPaths[12].set(0, trace);
        this.fNormalPaths[12].set(2, cpus);
        this.fNormalPaths[13].set(0, trace);
        this.fNormalPaths[13].set(2, cpus);
        this.fNormalPaths[13].set(4, mode);
        this.fNormalPaths[14].set(0, trace);
        this.fNormalPaths[14].set(2, cpus);
        this.fNormalPaths[14].set(4, mode);
        this.fNormalPaths[14].set(6, submode);
        return this.fNormalPaths;
    }

    private FixedArray[] getTypePaths(LttngEvent event, LttngTraceState traceState) {
        int trace = (int)traceState.getContext().getIdentifier();
        Long cpu = event.getCpuId();
        int cpus = cpu.intValue() | 0x70000000;
        LttngProcessState process = (LttngProcessState)traceState.getRunning_process().get(cpu);
        int processName = this.fPidKeys.getUniqueId(process.getPid().intValue(), process.getCpu().intValue(), process.getCreation_time());
        int mode = process.getState().getExec_mode().ordinal() | Integer.MIN_VALUE;
        int submode = this.fSubModeKeys.getUniqueId(process.getState().getExec_submode_id(), process.getState().getExec_submode());
        int function = process.getCurrent_function().intValue() | 0x90000000;
        int type = this.fTypeKeys.getUniqueId(event.getMarkerId(), event.getMarkerName());
        this.fTypedPaths[0].set(0, trace);
        this.fTypedPaths[0].set(2, type);
        this.fTypedPaths[1].set(0, trace);
        this.fTypedPaths[1].set(2, mode);
        this.fTypedPaths[1].set(4, type);
        this.fTypedPaths[2].set(0, trace);
        this.fTypedPaths[2].set(2, mode);
        this.fTypedPaths[2].set(4, submode);
        this.fTypedPaths[2].set(6, type);
        this.fTypedPaths[3].set(0, trace);
        this.fTypedPaths[3].set(2, processName);
        this.fTypedPaths[3].set(4, type);
        this.fTypedPaths[4].set(0, trace);
        this.fTypedPaths[4].set(2, processName);
        this.fTypedPaths[4].set(4, cpus);
        this.fTypedPaths[4].set(6, type);
        this.fTypedPaths[5].set(0, trace);
        this.fTypedPaths[5].set(2, processName);
        this.fTypedPaths[5].set(4, cpus);
        this.fTypedPaths[5].set(6, function);
        this.fTypedPaths[5].set(8, type);
        this.fTypedPaths[6].set(0, trace);
        this.fTypedPaths[6].set(2, processName);
        this.fTypedPaths[6].set(4, cpus);
        this.fTypedPaths[6].set(6, function);
        this.fTypedPaths[6].set(8, mode);
        this.fTypedPaths[6].set(10, type);
        this.fTypedPaths[7].set(0, trace);
        this.fTypedPaths[7].set(2, processName);
        this.fTypedPaths[7].set(4, cpus);
        this.fTypedPaths[7].set(6, function);
        this.fTypedPaths[7].set(8, mode);
        this.fTypedPaths[7].set(10, submode);
        this.fTypedPaths[7].set(12, type);
        this.fTypedPaths[8].set(0, trace);
        this.fTypedPaths[8].set(2, processName);
        this.fTypedPaths[8].set(4, cpus);
        this.fTypedPaths[8].set(6, mode);
        this.fTypedPaths[8].set(8, type);
        this.fTypedPaths[9].set(0, trace);
        this.fTypedPaths[9].set(2, processName);
        this.fTypedPaths[9].set(4, cpus);
        this.fTypedPaths[9].set(6, mode);
        this.fTypedPaths[9].set(8, submode);
        this.fTypedPaths[9].set(10, type);
        this.fTypedPaths[10].set(0, trace);
        this.fTypedPaths[10].set(2, processName);
        this.fTypedPaths[10].set(4, mode);
        this.fTypedPaths[10].set(6, type);
        this.fTypedPaths[11].set(0, trace);
        this.fTypedPaths[11].set(2, processName);
        this.fTypedPaths[11].set(4, mode);
        this.fTypedPaths[11].set(6, submode);
        this.fTypedPaths[11].set(8, type);
        this.fTypedPaths[12].set(0, trace);
        this.fTypedPaths[12].set(2, cpus);
        this.fTypedPaths[12].set(4, type);
        this.fTypedPaths[13].set(0, trace);
        this.fTypedPaths[13].set(2, cpus);
        this.fTypedPaths[13].set(4, mode);
        this.fTypedPaths[13].set(6, type);
        this.fTypedPaths[14].set(0, trace);
        this.fTypedPaths[14].set(2, cpus);
        this.fTypedPaths[14].set(4, mode);
        this.fTypedPaths[14].set(6, submode);
        this.fTypedPaths[14].set(8, type);
        return this.fTypedPaths;
    }

    @Override
    public void process_exit(LttngEvent event, LttngTraceState traceState) {
        FixedArray[] paths = this.getNormalPaths(event, traceState);
        Long cpu = event.getCpuId();
        LttngProcessState process = (LttngProcessState)traceState.getRunning_process().get(cpu);
        int j = 0;
        while (j < paths.length) {
            StatisticsTreeNode node = this.getOrCreate(paths[j], event, traceState, j, false);
            if (!process.getState().getExec_mode().equals((Object)StateStrings.ExecutionMode.LTTV_STATE_MODE_UNKNOWN)) {
                node.getValue().cpuTime += event.getTimestamp().getValue() - process.getState().getChange_LttTime();
            }
            ++j;
        }
    }

    @Override
    public void increase(LttngEvent event, LttngTraceState traceState, int values) {
        long delta;
        long cumulativeCpuTime;
        FixedArray[] paths = this.getNormalPaths(event, traceState);
        Long cpu = event.getCpuId();
        LttngProcessState process = (LttngProcessState)traceState.getRunning_process().get(cpu);
        if ((values & 8) != 0 && process.getState().getProc_status().equals((Object)StateStrings.ProcessStatus.LTTV_STATE_RUN) && !process.getState().getExec_mode().equals((Object)StateStrings.ExecutionMode.LTTV_STATE_MODE_UNKNOWN)) {
            cumulativeCpuTime = process.getState().getCum_cpu_time();
            delta = event.getTimestamp().getValue() - process.getState().getChange_LttTime();
            process.getState().setCum_cpu_time(Long.valueOf(cumulativeCpuTime + delta));
        }
        if ((values & 2) != 0) {
            long newCumulativeCpuTime;
            if (!process.getState().getExec_mode().equals((Object)StateStrings.ExecutionMode.LTTV_STATE_MODE_UNKNOWN)) {
                cumulativeCpuTime = process.getState().getCum_cpu_time();
                delta = event.getTimestamp().getValue() - process.getState().getEntry_LttTime();
                newCumulativeCpuTime = cumulativeCpuTime + delta;
                process.getState().setCum_cpu_time(Long.valueOf(newCumulativeCpuTime));
            } else if (process.getState().getProc_status().equals((Object)StateStrings.ProcessStatus.LTTV_STATE_RUN) && !process.getState().getExec_mode().equals((Object)StateStrings.ExecutionMode.LTTV_STATE_MODE_UNKNOWN)) {
                cumulativeCpuTime = process.getState().getCum_cpu_time();
                delta = event.getTimestamp().getValue() - process.getState().getChange_LttTime();
                newCumulativeCpuTime = cumulativeCpuTime + delta;
                process.getState().setCum_cpu_time(Long.valueOf(newCumulativeCpuTime));
            }
        }
        int j = 0;
        while (j < paths.length) {
            StatisticsTreeNode node = this.getOrCreate(paths[j], event, traceState, j, false);
            if ((values & 1) != 0 && process.getState().getProc_status().equals((Object)StateStrings.ProcessStatus.LTTV_STATE_RUN) && !process.getState().getExec_mode().equals((Object)StateStrings.ExecutionMode.LTTV_STATE_MODE_UNKNOWN)) {
                node.getValue().cpuTime += event.getTimestamp().getValue() - process.getState().getChange_LttTime();
            }
            if ((values & 2) != 0) {
                if (!process.getState().getExec_mode().equals((Object)StateStrings.ExecutionMode.LTTV_STATE_MODE_UNKNOWN)) {
                    node.getValue().cumulativeCpuTime += process.getState().getCum_cpu_time().longValue();
                } else if (process.getState().getProc_status().equals((Object)StateStrings.ProcessStatus.LTTV_STATE_RUN) && !process.getState().getExec_mode().equals((Object)StateStrings.ExecutionMode.LTTV_STATE_MODE_UNKNOWN)) {
                    node.getValue().cumulativeCpuTime += process.getState().getCum_cpu_time().longValue();
                }
            }
            if ((values & 4) != 0 && !process.getState().getExec_mode().equals((Object)StateStrings.ExecutionMode.LTTV_STATE_MODE_UNKNOWN)) {
                node.getValue().elapsedTime += event.getTimestamp().getValue() - process.getState().getEntry_LttTime();
            }
            ++j;
        }
    }

    @Override
    public void registerEvent(LttngEvent event, LttngTraceState traceState) {
        FixedArray[] paths = this.getNormalPaths(event, traceState);
        int i = 0;
        while (i < paths.length) {
            ++this.getOrCreate((FixedArray)paths[i], (LttngEvent)event, (LttngTraceState)traceState, (int)i, (boolean)false).getValue().nbEvents;
            ++i;
        }
        paths = this.getTypePaths(event, traceState);
        i = 0;
        while (i < paths.length) {
            ++this.getOrCreate((FixedArray)paths[i], (LttngEvent)event, (LttngTraceState)traceState, (int)i, (boolean)true).getValue().nbEvents;
            ++i;
        }
    }

    @Override
    protected void registerName(FixedArray path) {
        if (path.size() == 1) {
            if (!path.equals(ROOT)) {
                this.getKeys().get(ROOT.get(0)).add(path.get(0));
            }
        } else if (path.size() % 2 != 0) {
            this.getKeys().get(path.get(path.size() - 2)).add(path.get(path.size() - 1));
        }
    }

    public StatisticsTreeNode getOrCreate(FixedArray path, LttngEvent event, LttngTraceState traceState, int index, boolean isType) {
        StatisticsTreeNode current = this.get(path);
        if (current == null) {
            FixedArray newPath = (FixedArray)path.clone();
            String name = isType ? this.getTypeStatsName(event, traceState, index) : this.getOtherStatsName(event, traceState, index);
            this.registerName(path);
            current = new StatisticsTreeNode(newPath, this, name);
            this.put(newPath, current);
        } else if (index == 3 && !isType && StateStrings.Events.LTT_EVENT_EXEC.getInName().equals(event.getMarkerName())) {
            String name = this.getOtherStatsName(event, traceState, index);
            current.setName(name);
        }
        return current;
    }

    private String getOtherStatsName(LttngEvent event, LttngTraceState traceState, int index) {
        Long cpu = event.getCpuId();
        LttngProcessState process = (LttngProcessState)traceState.getRunning_process().get(cpu);
        switch (index) {
            case 0: {
                return traceState.getContext().getTraceId();
            }
            case 1: {
                return process.getState().getExec_mode().getInName();
            }
            case 2: {
                return process.getState().getExec_submode();
            }
            case 3: {
                return this.getProcessName(process);
            }
            case 4: {
                return String.valueOf(cpu);
            }
            case 5: {
                return process.getCurrent_function().toString();
            }
            case 6: {
                return process.getState().getExec_mode().getInName();
            }
            case 7: {
                return process.getState().getExec_submode();
            }
            case 8: {
                return process.getState().getExec_mode().getInName();
            }
            case 9: {
                return process.getState().getExec_submode();
            }
            case 10: {
                return process.getState().getExec_mode().getInName();
            }
            case 11: {
                return process.getState().getExec_submode();
            }
            case 12: {
                return String.valueOf(cpu);
            }
            case 13: {
                return process.getState().getExec_mode().getInName();
            }
            case 14: {
                return process.getState().getExec_submode();
            }
        }
        return "";
    }

    private String getTypeStatsName(LttngEvent event, LttngTraceState traceState, int index) {
        return event.getMarkerName();
    }

    private String getProcessName(LttngProcessState process) {
        if (process.getPid() == -1L) {
            return Messages.StatisticsData_UnknowProcess;
        }
        if (process.getName() == null) {
            return KernelStatisticsData.mergeString(String.valueOf(Messages.StatisticsData_UnknowProcess) + " - ", String.valueOf(process.getPid()));
        }
        if (process.getName().equals("")) {
            return process.getPid().toString();
        }
        return KernelStatisticsData.mergeString(process.getName(), " - ", String.valueOf(process.getPid()));
    }

    public static String getCategoryFromId(int value) {
        switch (value) {
            case -1073741568: {
                return HEADER_CPUS;
            }
            case -1073741567: {
                return HEADER_EVENT_TYPES;
            }
            case -1073741566: {
                return HEADER_FUNCTIONS;
            }
            case -1073741565: {
                return HEADER_MODES;
            }
            case -1073741564: {
                return HEADER_PROCESSES;
            }
            case -1073741563: {
                return HEADER_SUBMODES;
            }
        }
        return "";
    }

    private static final class KeyHelper
    implements Cloneable {
        private static final String UNKNOWN_PREFIX = "P";
        private String fName = "P";
        private int fValue = -1;

        private KeyHelper() {
        }

        public int hashCode() {
            return this.fValue;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (!(o instanceof KeyHelper)) {
                return false;
            }
            KeyHelper kh = (KeyHelper)o;
            return this.fValue == kh.fValue && this.fName.equals(kh.fName);
        }

        public KeyHelper clone() {
            KeyHelper clone = null;
            try {
                clone = (KeyHelper)super.clone();
                clone.fName = this.fName;
                clone.fValue = this.fValue;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            return clone;
        }

        public void setName(String name) {
            this.fName = this.fName != null ? name : UNKNOWN_PREFIX;
        }

        public void setValue(int value) {
            this.fValue = value;
        }
    }

    private static final class KeyProvider {
        private int fCount = 0;
        private HashMap<KeyHelper, Integer> fKeyMap = new HashMap(65535);
        private final KeyHelper fHelper = new KeyHelper();
        private int fBitMask = 0;

        KeyProvider(int bitMask) {
            this.fBitMask = bitMask;
        }

        KeyProvider() {
            this(0);
        }

        public int getUniqueId(int value, String name) {
            this.fHelper.setName(name);
            this.fHelper.setValue(value);
            Integer returnKey = this.fKeyMap.get(this.fHelper);
            if (returnKey == null) {
                returnKey = ++this.fCount | this.fBitMask;
                KeyHelper newHelper = this.fHelper.clone();
                this.fKeyMap.put(newHelper, returnKey);
            }
            return returnKey;
        }
    }

    private static final class ProcessKey
    implements Cloneable {
        private int fPid = 0;
        private int fCpuId = 0;
        private long fCreationTime = 0L;

        private ProcessKey() {
        }

        public void setPid(int pid) {
            this.fPid = pid;
        }

        public void setCpuId(int cpuId) {
            this.fCpuId = cpuId;
        }

        public void setCreationTime(long creationTime) {
            this.fCreationTime = creationTime;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ProcessKey)) {
                return false;
            }
            ProcessKey procKey = (ProcessKey)obj;
            if (procKey.fPid != this.fPid) {
                return false;
            }
            if (procKey.fCreationTime != this.fCreationTime) {
                return false;
            }
            return (long)procKey.fPid != 0L || procKey.fCpuId == this.fCpuId;
        }

        public int hashCode() {
            return this.fPid;
        }

        public ProcessKey clone() {
            ProcessKey clone = null;
            try {
                clone = (ProcessKey)super.clone();
                clone.fPid = this.fPid;
                clone.fCpuId = this.fCpuId;
                clone.fCreationTime = this.fCreationTime;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            return clone;
        }
    }

    private static final class ProcessKeyProvider {
        private int fCount = 0;
        private HashMap<ProcessKey, Integer> fKeyMap = new HashMap(65535);
        private ProcessKey fHelper = new ProcessKey();
        private int fBitMask = 0;

        public ProcessKeyProvider(int bitMask) {
            this.fBitMask = bitMask;
        }

        public int getUniqueId(int value, int cpuId, long creationTime) {
            this.fHelper.setPid(value);
            this.fHelper.setCpuId(cpuId);
            this.fHelper.setCreationTime(creationTime);
            Integer returnKey = this.fKeyMap.get(this.fHelper);
            if (returnKey == null) {
                returnKey = ++this.fCount | this.fBitMask;
                ProcessKey newHelper = this.fHelper.clone();
                this.fKeyMap.put(newHelper, returnKey);
            }
            return returnKey;
        }
    }
}

