/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.event;

import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;

public class TmfSimpleTimestamp
extends TmfTimestamp {
    public TmfSimpleTimestamp() {
        this(0L);
    }

    public TmfSimpleTimestamp(long value) {
        super(value, 0, 0);
    }

    public TmfSimpleTimestamp(ITmfTimestamp timestamp) {
        if (timestamp == null || timestamp.getScale() != 0 || timestamp.getPrecision() != 0) {
            throw new IllegalArgumentException();
        }
        this.setValue(timestamp.getValue(), 0, 0);
    }

    @Override
    public ITmfTimestamp normalize(long offset, int scale) throws ArithmeticException {
        if (scale == 0) {
            return new TmfSimpleTimestamp(this.getValue() + offset);
        }
        return super.normalize(offset, scale);
    }

    @Override
    public int compareTo(ITmfTimestamp ts, boolean withinPrecision) {
        if (ts instanceof TmfSimpleTimestamp) {
            long delta = this.getValue() - ts.getValue();
            return delta == 0L ? 0 : (delta > 0L ? 1 : -1);
        }
        return super.compareTo(ts, withinPrecision);
    }

    @Override
    public ITmfTimestamp getDelta(ITmfTimestamp ts) {
        if (ts instanceof TmfSimpleTimestamp) {
            return new TmfSimpleTimestamp(this.getValue() - ts.getValue());
        }
        return super.getDelta(ts);
    }

    @Override
    public TmfSimpleTimestamp clone() {
        return (TmfSimpleTimestamp)super.clone();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof TmfSimpleTimestamp)) {
            return super.equals(other);
        }
        TmfSimpleTimestamp ts = (TmfSimpleTimestamp)other;
        return this.compareTo(ts, false) == 0;
    }

    @Override
    public String toString() {
        return "TmfSimpleTimestamp [fValue=" + this.getValue() + "]";
    }
}

