/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.request;

import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.request.ITmfEventRequest;
import org.eclipse.linuxtools.tmf.core.request.TmfDataRequest;

public abstract class TmfEventRequest<T extends ITmfEvent>
extends TmfDataRequest<T>
implements ITmfEventRequest<T> {
    private final TmfTimeRange fRange;

    public TmfEventRequest(Class<T> dataType) {
        this(dataType, TmfTimeRange.ETERNITY, 0, Integer.MAX_VALUE, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfEventRequest(Class<T> dataType, ITmfDataRequest.ExecutionType priority) {
        this(dataType, TmfTimeRange.ETERNITY, 0, Integer.MAX_VALUE, 1000, priority);
    }

    public TmfEventRequest(Class<T> dataType, TmfTimeRange range) {
        this(dataType, range, 0, Integer.MAX_VALUE, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfEventRequest(Class<T> dataType, TmfTimeRange range, ITmfDataRequest.ExecutionType priority) {
        this(dataType, range, 0, Integer.MAX_VALUE, 1000, priority);
    }

    public TmfEventRequest(Class<T> dataType, TmfTimeRange range, int nbRequested) {
        this(dataType, range, 0, nbRequested, 1000, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfEventRequest(Class<T> dataType, TmfTimeRange range, int nbRequested, ITmfDataRequest.ExecutionType priority) {
        this(dataType, range, 0, nbRequested, 1000, priority);
    }

    public TmfEventRequest(Class<T> dataType, TmfTimeRange range, int nbRequested, int blockSize) {
        this(dataType, range, 0, nbRequested, blockSize, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfEventRequest(Class<T> dataType, TmfTimeRange range, int index, int nbRequested, int blockSize) {
        this(dataType, range, index, nbRequested, blockSize, ITmfDataRequest.ExecutionType.FOREGROUND);
    }

    public TmfEventRequest(Class<T> dataType, TmfTimeRange range, int nbRequested, int blockSize, ITmfDataRequest.ExecutionType priority) {
        this(dataType, range, 0, nbRequested, blockSize, priority);
    }

    public TmfEventRequest(Class<T> dataType, TmfTimeRange range, int index, int nbRequested, int blockSize, ITmfDataRequest.ExecutionType priority) {
        super(dataType, index, nbRequested, blockSize, priority);
        this.fRange = range;
    }

    @Override
    public TmfTimeRange getRange() {
        return this.fRange;
    }

    @Override
    public void setStartIndex(int index) {
        this.setIndex(index);
    }

    @Override
    public int hashCode() {
        return this.getRequestId();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof TmfEventRequest) {
            TmfEventRequest request = (TmfEventRequest)other;
            return super.equals(other) && request.fRange.equals(this.fRange);
        }
        return false;
    }

    @Override
    public String toString() {
        return "[TmfEventRequest(" + this.getRequestId() + "," + this.getDataType().getSimpleName() + "," + this.getRange() + "," + this.getIndex() + "," + this.getNbRequested() + "," + this.getBlockSize() + ")]";
    }
}

