/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.trace;

import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfCheckpoint;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;

public class TmfCheckpoint
implements ITmfCheckpoint {
    private ITmfLocation<? extends Comparable<?>> fLocation;
    private ITmfTimestamp fTimestamp;

    private TmfCheckpoint() {
    }

    public TmfCheckpoint(ITmfTimestamp timestamp, ITmfLocation<? extends Comparable<?>> location) {
        this.fTimestamp = timestamp;
        this.fLocation = location;
    }

    public TmfCheckpoint(TmfCheckpoint other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        this.fTimestamp = other.fTimestamp;
        this.fLocation = other.fLocation;
    }

    @Override
    public TmfCheckpoint clone() {
        TmfCheckpoint clone = null;
        try {
            clone = (TmfCheckpoint)super.clone();
            clone.fLocation = this.fLocation != null ? this.fLocation.clone() : null;
            clone.fTimestamp = this.fTimestamp != null ? this.fTimestamp.clone() : null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    @Override
    public ITmfTimestamp getTimestamp() {
        return this.fTimestamp;
    }

    public ITmfLocation<?> getLocation() {
        return this.fLocation;
    }

    @Override
    public int compareTo(ITmfCheckpoint other) {
        if (this.fTimestamp == null || other.getTimestamp() == null) {
            Comparable<?> location1 = this.fLocation.getLocation();
            Comparable<?> location2 = other.getLocation().getLocation();
            return location1.compareTo(location2);
        }
        return this.fTimestamp.compareTo(other.getTimestamp(), false);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fLocation == null ? 0 : this.fLocation.hashCode());
        result = 31 * result + (this.fTimestamp == null ? 0 : this.fTimestamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TmfCheckpoint)) {
            return false;
        }
        TmfCheckpoint other = (TmfCheckpoint)obj;
        if (this.fLocation == null ? other.fLocation != null : !this.fLocation.equals(other.fLocation)) {
            return false;
        }
        return !(this.fTimestamp == null ? other.fTimestamp != null : !this.fTimestamp.equals(other.fTimestamp));
    }

    public String toString() {
        return "TmfCheckpoint [fLocation=" + this.fLocation + ", fTimestamp=" + this.fTimestamp + "]";
    }
}

