/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.timechart;

import java.util.Map;
import org.eclipse.linuxtools.tmf.ui.views.colors.ColorSettingsManager;
import org.eclipse.linuxtools.tmf.ui.views.timechart.TimeChartEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class TimeChartAnalysisProvider
extends TimeGraphProvider {
    private static final Color BOOKMARK_INNER_COLOR = new Color((Device)Display.getDefault(), 115, 165, 224);
    private static final Color BOOKMARK_OUTER_COLOR = new Color((Device)Display.getDefault(), 2, 70, 140);
    private static final Color SEARCH_MATCH_COLOR = new Color((Device)Display.getDefault(), 177, 118, 14);
    private int lastX = Integer.MIN_VALUE;
    private int currX = Integer.MIN_VALUE;
    private int lastPriority;
    private int lastBookmarkX = Integer.MIN_VALUE;

    @Override
    public TimeGraphProvider.StateColor getEventColor(ITimeEvent event) {
        return TimeGraphProvider.StateColor.BLACK;
    }

    @Override
    public int getEventColorVal(ITimeEvent event) {
        int priority = ((TimeChartEvent)event).getColorSettingPriority();
        if (this.currX == this.lastX) {
            priority = Math.min(priority, this.lastPriority);
        }
        this.lastPriority = priority;
        return ColorSettingsManager.getColorSetting(priority).getTickColorIndex();
    }

    @Override
    public String getTraceClassName(ITimeGraphEntry entry) {
        return null;
    }

    @Override
    public String getEventName(ITimeEvent event, boolean upper, boolean extInfo) {
        return null;
    }

    @Override
    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event) {
        return null;
    }

    @Override
    public String getStateName(TimeGraphProvider.StateColor color) {
        return null;
    }

    @Override
    public void drawState(TimeGraphColorScheme colors, ITimeEvent event, Rectangle rect, GC gc, boolean selected, boolean rectBound, boolean timeSelected) {
        if (!((TimeChartEvent)event).isVisible()) {
            return;
        }
        this.lastX = this.currX;
        this.currX = rect.x;
        super.drawState(colors, event, rect, gc, selected, rectBound, timeSelected);
        if (this.lastBookmarkX == rect.x || ((TimeChartEvent)event).isBookmarked()) {
            this.drawBookmark(rect, gc);
            this.lastBookmarkX = rect.x;
        } else if (this.lastBookmarkX == rect.x - 1) {
            Rectangle r = new Rectangle(this.lastBookmarkX, rect.y, rect.width, rect.height);
            this.drawBookmark(r, gc);
        } else {
            this.lastBookmarkX = Integer.MIN_VALUE;
        }
        if (((TimeChartEvent)event).isSearchMatch()) {
            this.drawSearchMatch(rect, gc);
        }
    }

    private void drawBookmark(Rectangle r, GC gc) {
        gc.setForeground(BOOKMARK_OUTER_COLOR);
        gc.drawLine(r.x - 1, r.y - 2, r.x - 1, r.y + 2);
        gc.drawLine(r.x + 1, r.y - 2, r.x + 1, r.y + 2);
        gc.drawPoint(r.x, r.y - 2);
        gc.setForeground(BOOKMARK_INNER_COLOR);
        gc.drawLine(r.x, r.y - 1, r.x, r.y + 1);
        gc.setForeground(Display.getDefault().getSystemColor(1));
        gc.drawPoint(r.x - 1, r.y + 3);
        gc.drawPoint(r.x, r.y + 2);
        gc.drawPoint(r.x + 1, r.y + 3);
    }

    private void drawSearchMatch(Rectangle r, GC gc) {
        gc.setForeground(SEARCH_MATCH_COLOR);
        gc.drawPoint(r.x, r.y + r.height);
        gc.drawLine(r.x - 1, r.y + r.height + 1, r.x + 1, r.y + r.height + 1);
        gc.drawLine(r.x - 2, r.y + r.height + 2, r.x + 2, r.y + r.height + 2);
    }
}

