/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.ITimeDataProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDraw;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawAbsDay;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawAbsHrs;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawAbsMicroSec;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawAbsMillisec;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawAbsMin;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawAbsMonth;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawAbsNanoSec;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawAbsSec;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawAbsYear;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawMicrosec;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawMillisec;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawNanosec;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeDrawSec;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphBaseControl;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class TimeGraphScale
extends TimeGraphBaseControl
implements MouseListener,
MouseMoveListener {
    private static final long SEC_IN_NS = 1000000000L;
    private static final long MIN_IN_NS = 60000000000L;
    private static final long HOUR_IN_NS = 3600000000000L;
    private static final long DAY_IN_NS = 86400000000000L;
    private static final long MONTH_IN_NS = 2678400000000000L;
    private static final long YEAR_IN_NS = 31622400000000000L;
    private static final double LOG10_1 = Math.log10(1.0);
    private static final double LOG10_2 = Math.log10(2.0);
    private static final double LOG10_3 = Math.log10(3.0);
    private static final double LOG10_5 = Math.log10(5.0);
    private static final Calendar GREGORIAN_CALENDAR = GregorianCalendar.getInstance(TimeZone.getTimeZone("GMT"));
    private ITimeDataProvider _timeProvider;
    private int _dragState = 0;
    private int _dragX0 = 0;
    private int _dragX = 0;
    private long _time0bak;
    private long _time1bak;
    private boolean _isInUpdate;
    private Rectangle _rect0 = new Rectangle(0, 0, 0, 0);
    private int _height;
    private long _timeDelta;
    private static TimeDraw TIMEDRAW_NANOSEC = new TimeDrawNanosec();
    private static TimeDraw TIMEDRAW_MICROSEC = new TimeDrawMicrosec();
    private static TimeDraw TIMEDRAW_MILLISEC = new TimeDrawMillisec();
    private static TimeDraw TIMEDRAW_SEC = new TimeDrawSec();
    private static TimeDraw TIMEDRAW_ABS_NANOSEC = new TimeDrawAbsNanoSec();
    private static TimeDraw TIMEDRAW_ABS_MICROSEC = new TimeDrawAbsMicroSec();
    private static TimeDraw TIMEDRAW_ABS_MILLISEC = new TimeDrawAbsMillisec();
    private static TimeDraw TIMEDRAW_ABS_SEC = new TimeDrawAbsSec();
    private static TimeDraw TIMEDRAW_ABS_MIN = new TimeDrawAbsMin();
    private static TimeDraw TIMEDRAW_ABS_HRS = new TimeDrawAbsHrs();
    private static TimeDraw TIMEDRAW_ABS_DAY = new TimeDrawAbsDay();
    private static TimeDraw TIMEDRAW_ABS_MONTH = new TimeDrawAbsMonth();
    private static TimeDraw TIMEDRAW_ABS_YEAR = new TimeDrawAbsYear();

    public TimeGraphScale(Composite parent, TimeGraphColorScheme colors) {
        super(parent, colors, 0x200C0000);
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
    }

    public void setTimeProvider(ITimeDataProvider timeProvider) {
        this._timeProvider = timeProvider;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return super.computeSize(wHint, this._height, changed);
    }

    public void setHeight(int height) {
        this._height = height;
    }

    private void calcTimeDelta(int width, double pixelsPerNanoSec) {
        long pow10;
        double log;
        double remainder;
        double minDelta = pixelsPerNanoSec == 0.0 ? 3.16224E16 : (double)width / pixelsPerNanoSec;
        long unit = 1L;
        if (this._timeProvider != null && this._timeProvider.isCalendarFormat()) {
            if (minDelta > 1.60704E16) {
                unit = 31622400000000000L;
            } else if (minDelta > 8.0352E15) {
                unit = 16070400000000000L;
            } else if (minDelta > 8.64E14) {
                unit = 2678400000000000L;
            } else if (minDelta > 4.32E13) {
                unit = 86400000000000L;
            } else if (minDelta > 1.08E13) {
                unit = 21600000000000L;
            } else if (minDelta > 1.8E12) {
                unit = 3600000000000L;
            } else if (minDelta > 6.0E11) {
                unit = 900000000000L;
            } else if (minDelta > 3.0E10) {
                unit = 60000000000L;
            } else if (minDelta > 2.0E10) {
                unit = 30000000000L;
            } else if (minDelta <= 1.0) {
                this._timeDelta = 1L;
                return;
            }
        }
        this._timeDelta = (remainder = (log = Math.log10(minDelta / (double)unit)) - (double)(pow10 = (long)log)) < LOG10_1 ? (long)Math.pow(10.0, pow10) * unit : (remainder < LOG10_2 ? 2L * (long)Math.pow(10.0, pow10) * unit : (remainder < LOG10_3 && unit >= 3600000000000L && unit < 31622400000000000L ? 3L * (long)Math.pow(10.0, pow10) * unit : (remainder < LOG10_5 ? 5L * (long)Math.pow(10.0, pow10) * unit : 10L * (long)Math.pow(10.0, pow10) * unit)));
    }

    TimeDraw getTimeDraw(long timeDelta) {
        if (this._timeProvider != null && this._timeProvider.isCalendarFormat()) {
            TimeDraw timeDraw = timeDelta >= 31622400000000000L ? TIMEDRAW_ABS_YEAR : (timeDelta >= 2678400000000000L ? TIMEDRAW_ABS_MONTH : (timeDelta >= 86400000000000L ? TIMEDRAW_ABS_DAY : (timeDelta >= 3600000000000L ? TIMEDRAW_ABS_HRS : (timeDelta >= 60000000000L ? TIMEDRAW_ABS_MIN : (timeDelta >= 1000000000L ? TIMEDRAW_ABS_SEC : (timeDelta >= 1000000L ? TIMEDRAW_ABS_MILLISEC : (timeDelta >= 1000L ? TIMEDRAW_ABS_MICROSEC : TIMEDRAW_ABS_NANOSEC)))))));
            return timeDraw;
        }
        TimeDraw timeDraw = timeDelta >= 1000000000L ? TIMEDRAW_SEC : (timeDelta >= 1000000L ? TIMEDRAW_MILLISEC : (timeDelta >= 1000L ? TIMEDRAW_MICROSEC : TIMEDRAW_NANOSEC));
        return timeDraw;
    }

    @Override
    void paint(Rectangle rect, PaintEvent e) {
        if (this._isInUpdate || this._timeProvider == null) {
            return;
        }
        GC gc = e.gc;
        gc.fillRectangle(rect);
        long time0 = this._timeProvider.getTime0();
        long time1 = this._timeProvider.getTime1();
        long selectedTime = this._timeProvider.getSelectedTime();
        int leftSpace = this._timeProvider.getNameSpace();
        int timeSpace = this._timeProvider.getTimeSpace();
        gc.setBackground(this._colors.getColor(38));
        gc.setForeground(this._colors.getColor(39));
        Utils.init(this._rect0, rect);
        this._rect0.width = leftSpace;
        this._rect0.x += 4;
        this._rect0.width -= 4;
        Rectangle absHeaderRect = new Rectangle(this._rect0.x, this._rect0.y, this._rect0.width, this._rect0.height);
        this._rect0.x -= 4;
        this._rect0.width += 4;
        this._rect0.x += leftSpace;
        this._rect0.width = rect.width - leftSpace;
        gc.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
        --this._rect0.height;
        gc.fillRectangle(this._rect0);
        if (time1 <= time0 || timeSpace < 2) {
            return;
        }
        int numDigits = this.calculateDigits(time0, time1);
        int labelWidth = gc.getCharWidth('0') * numDigits;
        double pixelsPerNanoSec = timeSpace <= 2 ? 0.0 : (double)(timeSpace - 2) / (double)(time1 - time0);
        this.calcTimeDelta(labelWidth, pixelsPerNanoSec);
        TimeDraw timeDraw = this.getTimeDraw(this._timeDelta);
        if (3 == this._dragState && this._timeProvider != null) {
            if (this._dragX0 < this._dragX) {
                gc.drawRectangle(leftSpace + this._dragX0, rect.y, this._dragX - this._dragX0 - 1, rect.height - 8);
            } else if (this._dragX0 > this._dragX) {
                gc.drawRectangle(leftSpace + this._dragX, rect.y, this._dragX0 - this._dragX - 1, rect.height - 8);
            }
        }
        if (this._rect0.isEmpty()) {
            return;
        }
        int x = this._rect0.x + (int)((double)(selectedTime - time0) * pixelsPerNanoSec);
        if (x >= this._rect0.x && x < this._rect0.x + this._rect0.width) {
            gc.setForeground(this._colors.getColor(68));
            gc.drawLine(x, this._rect0.y + this._rect0.height - 6, x, this._rect0.y + this._rect0.height);
            gc.setForeground(this._colors.getColor(39));
        }
        this._rect0.y = rect.y;
        this._rect0.height = rect.height - 4;
        this._rect0.width = labelWidth;
        long time = this._timeProvider != null && this._timeProvider.isCalendarFormat() ? this.floorToCalendar(time0, this._timeDelta) : (long)(Math.ceil((double)time0 / (double)this._timeDelta) * (double)this._timeDelta);
        int y = this._rect0.y + this._rect0.height;
        if (this._timeProvider != null && this._timeProvider.isCalendarFormat()) {
            timeDraw.drawAbsHeader(gc, time, absHeaderRect);
        }
        while (true) {
            x = rect.x + leftSpace + (int)Math.floor((double)(time - time0) * pixelsPerNanoSec);
            gc.drawLine(x, y, x, y + 4);
            if (x >= rect.x + leftSpace + rect.width - this._rect0.width) break;
            if (x >= rect.x + leftSpace) {
                this._rect0.x = x;
                if (x + this._rect0.width <= rect.x + rect.width) {
                    timeDraw.draw(gc, time, this._rect0);
                }
            }
            if (pixelsPerNanoSec == 0.0 || time > Long.MAX_VALUE - this._timeDelta || this._timeDelta == 0L) break;
            time += this._timeDelta;
            if (this._timeProvider == null || !this._timeProvider.isCalendarFormat()) continue;
            if (this._timeDelta >= 31622400000000000L) {
                GREGORIAN_CALENDAR.setTime(new Date(time / 1000000L));
                GREGORIAN_CALENDAR.set(2, 0);
                GREGORIAN_CALENDAR.set(5, 1);
                time = GREGORIAN_CALENDAR.getTimeInMillis() * 1000000L;
                continue;
            }
            if (this._timeDelta < 2678400000000000L) continue;
            GREGORIAN_CALENDAR.setTime(new Date(time / 1000000L));
            GREGORIAN_CALENDAR.set(5, 1);
            time = GREGORIAN_CALENDAR.getTimeInMillis() * 1000000L;
        }
    }

    private long floorToCalendar(long time, long timeDelta) {
        if (this._timeDelta >= 31622400000000000L) {
            GREGORIAN_CALENDAR.setTime(new Date(time / 1000000L));
            int year = GREGORIAN_CALENDAR.get(1);
            int yearDelta = (int)(timeDelta / 31622400000000000L);
            year = year / yearDelta * yearDelta;
            GREGORIAN_CALENDAR.set(1, year);
            GREGORIAN_CALENDAR.set(2, 0);
            GREGORIAN_CALENDAR.set(5, 1);
            GREGORIAN_CALENDAR.set(11, 0);
            GREGORIAN_CALENDAR.set(12, 0);
            GREGORIAN_CALENDAR.set(13, 0);
            GREGORIAN_CALENDAR.set(14, 0);
            time = GREGORIAN_CALENDAR.getTimeInMillis() * 1000000L;
        } else if (this._timeDelta >= 2678400000000000L) {
            GREGORIAN_CALENDAR.setTime(new Date(time / 1000000L));
            int month = GREGORIAN_CALENDAR.get(2);
            int monthDelta = (int)(timeDelta / 2678400000000000L);
            month = month / monthDelta * monthDelta;
            GREGORIAN_CALENDAR.set(2, month);
            GREGORIAN_CALENDAR.set(5, 1);
            GREGORIAN_CALENDAR.set(11, 0);
            GREGORIAN_CALENDAR.set(12, 0);
            GREGORIAN_CALENDAR.set(13, 0);
            GREGORIAN_CALENDAR.set(14, 0);
            time = GREGORIAN_CALENDAR.getTimeInMillis() * 1000000L;
        } else {
            time = time / timeDelta * timeDelta;
        }
        return time;
    }

    private int calculateDigits(long time0, long time1) {
        int numDigits = 5;
        long timeRange = time1 - time0;
        if (this._timeProvider.isCalendarFormat()) {
            numDigits += 8;
            if (timeRange < 10000L) {
                numDigits += 10;
            } else if (timeRange < 10000000L) {
                numDigits += 6;
            }
        } else {
            long min = (long)((double)time1 * 1.0E-9 / 60.0);
            String strMinutes = String.valueOf(min);
            numDigits = strMinutes != null ? (numDigits += strMinutes.length()) : (numDigits += 2);
            if (timeRange < 10000L) {
                numDigits += 8;
            } else if (timeRange < 10000000L) {
                numDigits += 4;
            }
        }
        return numDigits;
    }

    public void mouseDown(MouseEvent e) {
        if (this._dragState == 0 && this._timeProvider != null) {
            if (1 == e.button) {
                this.setCapture(true);
                this._dragState = 1;
            } else if (3 == e.button) {
                this._dragState = 3;
            }
            int x = e.x - this._timeProvider.getNameSpace();
            if (x < 0) {
                x = 0;
            } else if (x > this.getSize().x - this._timeProvider.getNameSpace()) {
                x = this.getSize().x - this._timeProvider.getNameSpace();
            }
            this._dragX = this._dragX0 = x;
            this._time0bak = this._timeProvider.getTime0();
            this._time1bak = this._timeProvider.getTime1();
        }
    }

    public void mouseUp(MouseEvent e) {
        if (e.button == 1 && this._dragState == 1) {
            this.setCapture(false);
            this._dragState = 0;
            if (this._dragX != this._dragX0) {
                this._timeProvider.setStartFinishTimeNotify(this._timeProvider.getTime0(), this._timeProvider.getTime1());
            }
        } else if (e.button == 3 && this._dragState == 3 && this._timeProvider != null) {
            this._dragState = 0;
            if (this._dragX0 == this._dragX) {
                return;
            }
            int timeSpace = this._timeProvider.getTimeSpace();
            int leftSpace = this._timeProvider.getNameSpace();
            int x = e.x - leftSpace;
            if (timeSpace > 0) {
                this._dragX = x;
                if (this._dragX0 > this._dragX) {
                    this._dragX = this._dragX0;
                    this._dragX0 = x;
                }
                long time0 = this._time0bak + (long)((double)(this._time1bak - this._time0bak) * ((double)this._dragX0 / (double)timeSpace));
                long time1 = this._time0bak + (long)((double)(this._time1bak - this._time0bak) * ((double)this._dragX / (double)timeSpace));
                this._timeProvider.setStartFinishTimeNotify(time0, time1);
                this._time0bak = this._timeProvider.getTime0();
                this._time1bak = this._timeProvider.getTime1();
            }
        }
    }

    public void mouseMove(MouseEvent e) {
        if (this._dragX0 < 0 || this._dragState == 0 || this._timeProvider == null) {
            return;
        }
        Point size = this.getSize();
        int leftSpace = this._timeProvider.getNameSpace();
        int timeSpace = this._timeProvider.getTimeSpace();
        int x = e.x - leftSpace;
        if (1 == this._dragState) {
            if (x > 0 && size.x > leftSpace && this._dragX != x) {
                this._dragX = x;
                long time1 = this._time0bak + (long)((double)(this._time1bak - this._time0bak) * ((double)this._dragX0 / (double)this._dragX));
                this._timeProvider.setStartFinishTime(this._time0bak, time1);
            }
        } else if (3 == this._dragState) {
            this._dragX = x < 0 ? 0 : (x > timeSpace ? timeSpace : x);
            this.redraw();
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (this._timeProvider != null) {
            this._timeProvider.resetStartFinishTime();
            this._time0bak = this._timeProvider.getTime0();
            this._time1bak = this._timeProvider.getTime1();
        }
    }
}

