/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.colors;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.linuxtools.internal.tmf.ui.Messages;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.widgets.TimeGraphColorScheme;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TickColorDialog
extends Dialog {
    int selectedIndex = 0;
    Composite colorComposite;
    TimeGraphColorScheme traceColorScheme = new TimeGraphColorScheme();

    protected TickColorDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(Messages.TickColorDialog_TickColorDialogTitle);
        Composite composite = (Composite)super.createDialogArea(parent);
        this.colorComposite = new Composite(composite, 0);
        this.colorComposite.setLayout((Layout)new GridLayout(4, false));
        int i = 0;
        while (i < 16) {
            TickColorCanvas tickColorCanvas = new TickColorCanvas(this.colorComposite, 0);
            tickColorCanvas.setColorIndex(i);
            ++i;
        }
        return composite;
    }

    public void setColorIndex(int colorIndex) {
        this.selectedIndex = colorIndex;
    }

    public int getColorIndex() {
        return this.selectedIndex;
    }

    private class TickColorCanvas
    extends Canvas {
        int colorIndex;

        public TickColorCanvas(Composite parent, int style) {
            super(parent, style);
            GridData gd = new GridData(0x1000000, 4, true, false);
            gd.widthHint = 40;
            gd.heightHint = 25;
            this.setLayoutData(gd);
            this.setBackground(TickColorDialog.this.traceColorScheme.getBkColor(false, false, false));
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.setForeground(((TickColorCanvas)TickColorCanvas.this).TickColorDialog.this.traceColorScheme.getColor(61));
                    int midy = e.y + e.height / 2;
                    e.gc.drawLine(e.x, midy, e.x + e.width, midy);
                    int midx = e.x + e.width / 2;
                    Rectangle rect = new Rectangle(midx - 10, e.y + 3, 0, e.height - 6);
                    int i = 1;
                    while (i <= 3) {
                        rect.x += i;
                        rect.width = i++;
                        e.gc.setBackground(((TickColorCanvas)TickColorCanvas.this).TickColorDialog.this.traceColorScheme.getColor(TickColorCanvas.this.colorIndex));
                        e.gc.fillRectangle(rect);
                    }
                    i = 3;
                    while (i > 0) {
                        rect.x += i + 2;
                        rect.width = i--;
                        e.gc.setBackground(((TickColorCanvas)TickColorCanvas.this).TickColorDialog.this.traceColorScheme.getColor(TickColorCanvas.this.colorIndex));
                        e.gc.fillRectangle(rect);
                    }
                    if (((TickColorCanvas)TickColorCanvas.this).TickColorDialog.this.selectedIndex == TickColorCanvas.this.colorIndex) {
                        Color borderColor = Display.getDefault().getSystemColor(2);
                        Point p = TickColorCanvas.this.getSize();
                        rect = new Rectangle(0, 0, p.x - 1, p.y - 1);
                        GC gc = e.gc;
                        gc.setForeground(borderColor);
                        gc.drawRectangle(rect);
                    }
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    ((TickColorCanvas)TickColorCanvas.this).TickColorDialog.this.selectedIndex = TickColorCanvas.this.colorIndex;
                    ((TickColorCanvas)TickColorCanvas.this).TickColorDialog.this.colorComposite.redraw(0, 0, ((TickColorCanvas)TickColorCanvas.this).TickColorDialog.this.colorComposite.getBounds().width, ((TickColorCanvas)TickColorCanvas.this).TickColorDialog.this.colorComposite.getBounds().height, true);
                }
            });
        }

        public void setColorIndex(int index) {
            this.colorIndex = index;
        }
    }
}

