/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.timechart;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.internal.tmf.ui.TmfUiPlugin;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.filter.ITmfFilter;

public class TimeChartDecorationProvider {
    private IFile fBookmarksFile;
    private Set<Long> fBookmarksSet = new HashSet<Long>();
    private ITmfFilter fFilterFilter;
    private ITmfFilter fSearchFilter;

    public TimeChartDecorationProvider(IFile bookmarksFile) {
        this.fBookmarksFile = bookmarksFile;
        this.refreshBookmarks();
    }

    public IFile getBookmarksFile() {
        return this.fBookmarksFile;
    }

    public boolean isBookmark(long rank) {
        return this.fBookmarksSet.contains(rank);
    }

    public void refreshBookmarks() {
        try {
            this.fBookmarksSet.clear();
            IMarker[] iMarkerArray = this.fBookmarksFile.findMarkers("org.eclipse.core.resources.bookmark", false, 0);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker bookmark = iMarkerArray[n2];
                int location = bookmark.getAttribute("location", -1);
                if (location != -1) {
                    Long rank = location;
                    this.fBookmarksSet.add(rank);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            TmfUiPlugin.getDefault().logError("Error refreshing bookmarks", e);
        }
    }

    public void filterApplied(ITmfFilter filter) {
        this.fFilterFilter = filter;
    }

    public boolean isVisible(ITmfEvent event) {
        if (this.fFilterFilter != null) {
            return this.fFilterFilter.matches(event);
        }
        return true;
    }

    public void searchApplied(ITmfFilter filter) {
        this.fSearchFilter = filter;
    }

    public boolean isSearchMatch(ITmfEvent event) {
        if (this.fSearchFilter != null) {
            return this.fSearchFilter.matches(event);
        }
        return false;
    }
}

