/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.jni.factory;

import org.eclipse.linuxtools.internal.lttng.jni.exception.JniException;
import org.eclipse.linuxtools.internal.lttng.jni.exception.JniTraceVersionException;
import org.eclipse.linuxtools.internal.lttng.jni_v2_3.JniTrace_v2_3;
import org.eclipse.linuxtools.internal.lttng.jni_v2_5.JniTrace_v2_5;
import org.eclipse.linuxtools.internal.lttng.jni_v2_6.JniTrace_v2_6;
import org.eclipse.linuxtools.lttng.jni.JniTrace;
import org.eclipse.linuxtools.lttng.jni.factory.JniTraceVersion;

public class JniTraceFactory {
    static final String TraceVersion_v2_3 = "2.3";
    static final String TraceVersion_v2_5 = "2.5";
    static final String TraceVersion_v2_6 = "2.6";

    private JniTraceFactory() {
    }

    public static JniTrace getJniTrace(String path, String traceLibPath, boolean show_debug) throws JniException {
        try {
            JniTraceVersion traceVersion = new JniTraceVersion(path, traceLibPath);
            JniTrace trace = null;
            if (traceVersion.getVersionAsString().equals(TraceVersion_v2_6)) {
                trace = new JniTrace_v2_6(path, show_debug);
            } else if (traceVersion.getVersionAsString().equals(TraceVersion_v2_5)) {
                trace = new JniTrace_v2_5(path, show_debug);
            } else if (traceVersion.getVersionAsString().equals(TraceVersion_v2_3)) {
                trace = new JniTrace_v2_3(path, show_debug);
            }
            if (trace != null) {
                if (traceLibPath != null) {
                    trace.setTraceLibPath(traceLibPath);
                }
                trace.openTrace(path);
                return trace;
            }
            String errMsg = "Unrecognized/unsupported trace version\n\nLibrary reported trace version " + traceVersion.getVersionAsString() + "\n\n" + "Make sure that you installed the corresponding parsing library (liblttvtraceread-" + traceVersion.getVersionAsString() + ".so) " + "and that it can be found from either your LD_LIBRARY_PATH or the Trace Library Path (in LTTng project properties)\n\n" + "Refer to the LTTng User Guide for more information";
            throw new JniException(errMsg);
        }
        catch (JniTraceVersionException jniTraceVersionException) {
            String errMsg = "Couldn't obtain the trace version\n\nThis usually means that the library loader (liblttvtraceread_loader.so) could not be found.\n\nMake sure you installed the parsing library and that your LD_LIBRARY_PATH or Trace Library Path is set correctly\n\nRefer to the LTTng User Guide for more information";
            throw new JniException(errMsg);
        }
    }
}

