/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.dashboardextension.actions;

import java.io.FileInputStream;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.DashboardModule;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.ModuleTreeNode;
import org.eclipse.linuxtools.systemtap.ui.editor.SimpleEditor;
import org.eclipse.linuxtools.systemtap.ui.ide.IDEPerspective;
import org.eclipse.linuxtools.systemtap.ui.ide.actions.TempFileAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class AddScriptAction
extends Action
implements IViewActionDelegate {
    private ModuleTreeNode selectedItem;

    public void init(IViewPart view) {
        this.selectedItem = null;
    }

    public void run(IAction act) {
        DashboardModule data = (DashboardModule)this.selectedItem.getData();
        try {
            IWorkbenchPage p = PlatformUI.getWorkbench().showPerspective(IDEPerspective.ID, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            TempFileAction tfa = new TempFileAction();
            tfa.run();
            IEditorPart edit = p.getActiveEditor();
            if (edit != null && edit instanceof SimpleEditor) {
                SimpleEditor editor = (SimpleEditor)edit;
                try {
                    int c;
                    FileInputStream fin = new FileInputStream(data.script);
                    StringBuilder sb = new StringBuilder();
                    while ((c = fin.read()) != -1) {
                        sb.append((char)c);
                    }
                    fin.close();
                    editor.insertText(sb.toString());
                }
                catch (IOException iOException) {}
            }
        }
        catch (WorkbenchException workbenchException) {}
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection selected;
        Object o;
        if (selection instanceof IStructuredSelection && (o = (selected = (IStructuredSelection)selection).getFirstElement()) instanceof ModuleTreeNode) {
            this.selectedItem = (ModuleTreeNode)o;
            o = this.selectedItem.getData();
            if (o != null) {
                this.setEnabled(true);
                return;
            }
        }
        this.setEnabled(false);
    }
}

