/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.ui.project.handlers;

import org.eclipse.jface.action.IAction;
import org.eclipse.linuxtools.internal.tmf.ui.project.handlers.DeleteAction;
import org.eclipse.linuxtools.internal.tmf.ui.project.handlers.OpenAction;
import org.eclipse.linuxtools.internal.tmf.ui.project.handlers.RefreshAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;

public class TmfActionProvider
extends CommonActionProvider {
    private OpenAction openAction;
    private DeleteAction deleteAction;
    private RefreshAction refreshAction;

    public void init(ICommonActionExtensionSite aSite) {
        ICommonViewerSite viewSite = aSite.getViewSite();
        if (viewSite instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite workbenchSite = (ICommonViewerWorkbenchSite)viewSite;
            this.openAction = new OpenAction(workbenchSite.getPage(), workbenchSite.getSelectionProvider());
            this.deleteAction = new DeleteAction(workbenchSite.getPage(), workbenchSite.getSelectionProvider());
            this.refreshAction = new RefreshAction(workbenchSite.getPage(), workbenchSite.getSelectionProvider());
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        if (this.openAction.isEnabled()) {
            actionBars.setGlobalActionHandler("org.eclipse.ui.navigator.Open", (IAction)this.openAction);
        }
        if (this.deleteAction.isEnabled()) {
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        }
        if (this.refreshAction.isEnabled()) {
            actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
        }
    }
}

