/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.binutils.utils;

import java.io.IOException;
import org.eclipse.cdt.utils.Addr2line;
import org.eclipse.cdt.utils.CPPFilt;
import org.eclipse.core.resources.IProject;
import org.eclipse.linuxtools.binutils.utils.ISTBinutilsFactory;
import org.eclipse.linuxtools.binutils.utils.STNM;
import org.eclipse.linuxtools.binutils.utils.STNMSymbolsHandler;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;

public class DefaultBinutilsFactory
implements ISTBinutilsFactory {
    private static final String CPPFILT_CMD = "c++filt";
    private static final String ADDR2LINE_CMD = "addr2line";

    @Override
    public Addr2line getAddr2line(String path, IProject project) throws IOException {
        String addr2line = RuntimeProcessFactory.getFactory().whichCommand(ADDR2LINE_CMD, project);
        return new Addr2line(addr2line, path);
    }

    @Override
    public CPPFilt getCPPFilt(IProject project) throws IOException {
        return new CPPFilt(RuntimeProcessFactory.getFactory().whichCommand(CPPFILT_CMD, project));
    }

    @Override
    public STNM getNM(String path, STNMSymbolsHandler handler, IProject project) throws IOException {
        return new STNM("nm", null, path, handler, project);
    }

    @Override
    public boolean testAvailability() {
        return true;
    }
}

