/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.cdt.libhover;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.linuxtools.cdt.libhover.MemberInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String[] templateParms = new String[0];
    private boolean templateParmsFilled = false;
    private String className;
    private String id;
    private String include;
    private ArrayList<ClassInfo> baseClasses = new ArrayList();
    private HashMap<String, MemberInfo> members = new HashMap();
    private transient Document document;
    public transient Node classNode;
    private ArrayList<ClassInfo> children = null;

    public ClassInfo(String className, String id, Node classNode) {
        this.className = className;
        this.id = id;
        this.classNode = classNode;
    }

    public String getClassName() {
        return this.className;
    }

    public Node getClassNode() {
        if (this.classNode == null) {
            this.classNode = this.document.getElementById(this.id);
        }
        return this.classNode;
    }

    public void setDocument(Document d) {
        this.document = d;
    }

    public void setClassName(String newName) {
        this.className = newName;
    }

    public void addTemplate(ClassInfo child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
    }

    public boolean areTemplateParmsFilled() {
        return this.templateParmsFilled;
    }

    public String[] getTemplateParms() {
        return this.templateParms;
    }

    public void setTemplateParms(String[] templateParms) {
        this.templateParmsFilled = true;
        this.templateParms = templateParms;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public ArrayList<ClassInfo> getChildren() {
        return this.children;
    }

    public MemberInfo getMember(String name) {
        return this.members.get(name);
    }

    public void addMember(MemberInfo info) {
        String name = info.getName();
        MemberInfo member = this.members.get(name);
        if (member != null) {
            member.addChild(info);
        } else {
            this.members.put(name, info);
        }
    }

    public MemberInfo[] getMembers(String nameStart) {
        ArrayList<MemberInfo> matchList = new ArrayList<MemberInfo>();
        Collection<MemberInfo> values = this.members.values();
        Iterator<MemberInfo> i = values.iterator();
        while (i.hasNext()) {
            MemberInfo k = i.next();
            if (!k.getName().startsWith(nameStart)) continue;
            matchList.add(k);
            ArrayList<MemberInfo> children = k.getChildren();
            if (children == null) continue;
            Iterator<MemberInfo> j = children.iterator();
            while (j.hasNext()) {
                MemberInfo child = i.next();
                matchList.add(child);
            }
        }
        MemberInfo[] matches = new MemberInfo[matchList.size()];
        return matchList.toArray(matches);
    }

    public ArrayList<ClassInfo> getBaseClasses() {
        return this.baseClasses;
    }

    public void addBaseClass(ClassInfo info) {
        this.baseClasses.add(info);
    }
}

