/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ctf.core.trace;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInputPacketIndexEntry;

public class StreamInputPacketIndex {
    private final Vector<StreamInputPacketIndexEntry> entries = new Vector();

    public Vector<StreamInputPacketIndexEntry> getEntries() {
        return this.entries;
    }

    public ListIterator<StreamInputPacketIndexEntry> listIterator() {
        return this.entries.listIterator();
    }

    public ListIterator<StreamInputPacketIndexEntry> listIterator(int n) {
        return this.entries.listIterator(n);
    }

    public void addEntry(StreamInputPacketIndexEntry entry) throws CTFReaderException {
        assert (entry.getContentSizeBits() != 0);
        assert (entry.getContentSizeBits() != 0);
        if (entry.getTimestampBegin() > entry.getTimestampEnd()) {
            throw new CTFReaderException("Packet begin timestamp is after end timestamp");
        }
        if (!this.entries.isEmpty() && entry.getTimestampBegin() < this.entries.lastElement().getTimestampBegin()) {
            throw new CTFReaderException("Packets begin timestamp decreasing");
        }
        this.entries.add(entry);
    }

    public ListIterator<StreamInputPacketIndexEntry> search(long timestamp) {
        int guessI;
        int max = this.entries.size() - 1;
        int min = 0;
        StreamInputPacketIndexEntry guessEntry = null;
        if (this.getEntries().isEmpty()) {
            return this.getEntries().listIterator();
        }
        if (timestamp < 0L) {
            throw new IllegalArgumentException("timestamp is negative");
        }
        while (true) {
            guessI = (max + min + 1) / 2;
            guessEntry = this.entries.get(guessI);
            if (min == max) break;
            if (timestamp < guessEntry.getTimestampBegin()) {
                max = guessI - 1;
                continue;
            }
            if (timestamp < guessEntry.getTimestampBegin()) continue;
            min = guessI;
        }
        return this.entries.listIterator(guessI);
    }
}

