/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.latency.listeners;

import org.eclipse.linuxtools.internal.lttng.ui.views.latency.AbstractViewer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractPaintListener
implements PaintListener {
    protected final Color DEFAULT_DATA_COLOR = new Color((Device)Display.getDefault(), 74, 112, 139);
    protected static final Color DEFAULT_LABEL_COLOR = Display.getCurrent().getSystemColor(2);
    protected static final Color DEFAULT_TEXT_COLOR = Display.getCurrent().getSystemColor(16);
    protected static final Color DEFAULT_DATA_BACKGROUND_COLOR = Display.getCurrent().getSystemColor(1);
    protected static final Color DEFAULT_CURRENT_EVENT_COLOR = Display.getCurrent().getSystemColor(3);
    protected final Font DEFAULT_TITLE_FONT = new Font((Device)Display.getDefault(), "Arial", 10, 1);
    protected final Font DEFAULT_VALUES_FONT = new Font((Device)Display.getDefault(), "Arial", 7, 0);
    protected final Font DEFAULT_LABEL_FONT = new Font((Device)Display.getDefault(), "Arial", 8, 0);
    protected AbstractViewer fViewer;
    protected String fGraphTitle;
    protected String fXAxisLabel;
    protected String fYAxisLabel;
    protected int fXAxisLabelOffset;
    protected int fHorizontalAxisYOffset = 20;
    protected int fPadding = 10;
    protected Rectangle fClientArea = new Rectangle(0, 0, 1, 1);
    protected Color fForegroundColor;
    protected Color fBackgroundColor;
    protected Color fDataColor;
    protected Color fLabelColor;
    protected Color fTextColor;
    protected Color fDataBackgroundColor;
    protected Color fCurrentEventColor;
    protected Font fOriginalFont;
    protected Font fTitleFont;
    protected Font fValuesFont;
    protected Font fLabelFont;
    protected final int ARROW_DELTA_X = 10;
    protected final int ARROW_DELTA_Y = 4;
    protected final int MAX_WIDTH_BETWEEN_TICKS = 40;
    protected final int MAX_HEIGHT_BETWEEN_TICKS = 30;
    protected final int MAX_CHAR_VERTICAL_DISPLAY = 5;
    protected int fDrawLabelEachNTicks = 1;
    protected Image fImage;
    protected GC fAxisImage;
    protected boolean fInitialized = false;
    protected Rectangle fDrawArea;
    protected int fPaddingRight = 10;
    protected int fPaddingTop = 10;
    protected int fVerticalAxisOffset = 20;
    protected int fDelta = 0;
    protected int fBarWith = 2;
    protected long fXMin = -1L;
    protected long fXMax = -1L;
    protected long fYMin = -1L;
    protected long fYMax = -1L;

    public AbstractPaintListener(AbstractViewer view) {
        this.fViewer = view;
        this.fDataColor = this.DEFAULT_DATA_COLOR;
        this.fLabelColor = DEFAULT_LABEL_COLOR;
        this.fTextColor = DEFAULT_TEXT_COLOR;
        this.fDataBackgroundColor = DEFAULT_DATA_BACKGROUND_COLOR;
        this.fCurrentEventColor = DEFAULT_CURRENT_EVENT_COLOR;
        this.fTitleFont = this.DEFAULT_TITLE_FONT;
        this.fValuesFont = this.DEFAULT_VALUES_FONT;
        this.fLabelFont = this.DEFAULT_LABEL_FONT;
    }

    public double getHeight() {
        return (double)this.fClientArea.height - 2.0 * (double)this.fPadding - (double)this.fHorizontalAxisYOffset - (double)this.fPaddingTop;
    }

    public double getWidth() {
        return (double)this.fClientArea.width - 2.0 * (double)this.fPadding - (double)this.fVerticalAxisOffset - (double)this.fPaddingRight;
    }

    public int getPadding() {
        return this.fPadding;
    }

    public int getPaddingTop() {
        return this.fPaddingTop;
    }

    public int getVerticalAxisOffset() {
        return this.fVerticalAxisOffset;
    }

    public int getHorizontalAxisYOffset() {
        return this.fHorizontalAxisYOffset;
    }

    public long getXMin() {
        return this.fXMin;
    }

    public long getXMax() {
        return this.fXMax;
    }

    public long getYMin() {
        return this.fYMin;
    }

    public long getYMax() {
        return this.fYMax;
    }

    public void dispose() {
        this.DEFAULT_DATA_COLOR.dispose();
        this.DEFAULT_TITLE_FONT.dispose();
        this.DEFAULT_VALUES_FONT.dispose();
        this.DEFAULT_LABEL_FONT.dispose();
    }

    public void paintControl(PaintEvent e) {
        this.fClientArea = this.fViewer.getClientArea();
        this.fForegroundColor = e.gc.getForeground();
        this.fBackgroundColor = e.gc.getBackground();
        this.fOriginalFont = e.gc.getFont();
        this.scale();
        if (!this.fInitialized) {
            this.fImage = new Image((Device)Display.getDefault(), this.fViewer.getBounds());
            this.fAxisImage = new GC((Drawable)this.fImage);
            this.fAxisImage.setForeground(this.fForegroundColor);
            this.fAxisImage.setBackground(this.fBackgroundColor);
            this.fAxisImage.fillRectangle(this.fImage.getBounds());
            this.fInitialized = true;
        }
        this.paintGraphTitle();
        this.paintBackground();
        this.paintHorizontalAxis();
        this.paintVerticalAxis();
        this.paintContent();
        e.gc.drawImage(this.fImage, 0, 0);
    }

    public void paintGraphTitle() {
        if (this.fGraphTitle != null) {
            this.fAxisImage.setFont(this.fTitleFont);
            this.fAxisImage.setForeground(this.fLabelColor);
            this.fAxisImage.setBackground(this.fBackgroundColor);
            int zoomFactor = this.fViewer.getZoomFactor() / this.fViewer.getZoomIncrement() + 1;
            int labelWidth = this.fAxisImage.stringExtent((String)this.fGraphTitle).x;
            if (this.fViewer.getZoomFactor() > 1) {
                this.fAxisImage.drawText(String.valueOf(this.fGraphTitle) + " (" + zoomFactor + "x)", (this.fViewer.getBounds().width - this.fPadding - labelWidth) / 2, 0);
            } else {
                this.fAxisImage.drawText(this.fGraphTitle, (this.fViewer.getBounds().width - this.fPadding - labelWidth) / 2, 0);
            }
        }
    }

    public void paintBackground() {
        this.fAxisImage.setBackground(this.fDataBackgroundColor);
        this.fAxisImage.fillRectangle(this.fPadding + this.fVerticalAxisOffset, this.fPadding + this.fPaddingTop, (int)this.getWidth() + 1, (int)this.getHeight());
    }

    public void paintHorizontalAxis() {
        this.fAxisImage.setForeground(this.fForegroundColor);
        int y = this.fClientArea.height - this.fPadding - this.fHorizontalAxisYOffset;
        this.fAxisImage.drawLine(this.fClientArea.x + this.fPadding + this.fVerticalAxisOffset, y, this.fClientArea.width - this.fPadding, y);
        this.paintHorizontalArrow(this.fClientArea.width - this.fPadding, y);
        if (this.fXMin != Long.MAX_VALUE && this.fXMax != Long.MIN_VALUE && this.fXMin != this.fXMax) {
            this.paintHorizontalTicks(y);
            this.paintHorizontalAxisValues(y + 30);
        }
        this.paintHorizontalAxisLabel(y + this.fHorizontalAxisYOffset - 5);
    }

    public void paintVerticalAxis() {
        this.fAxisImage.setForeground(this.fForegroundColor);
        int x = this.fClientArea.x + this.fPadding + this.fVerticalAxisOffset;
        this.fAxisImage.drawLine(x, this.fPadding, x, this.fClientArea.height - this.fPadding - this.fHorizontalAxisYOffset);
        this.paintVerticalArrow(x, this.fClientArea.y + this.fPadding);
        if (this.fXMin != Long.MAX_VALUE && this.fXMax != Long.MIN_VALUE && this.fXMin != this.fXMax) {
            this.paintVerticalTicks(x);
            this.paintVerticalAxisValues(x);
        }
        this.paintVerticalAxisLabel(x);
    }

    public void paintHorizontalArrow(int x, int y) {
        this.fAxisImage.drawLine(x - 10, y - 4, x, y);
        this.fAxisImage.drawLine(x - 10, y + 4, x, y);
    }

    public void paintVerticalArrow(int x, int y) {
        this.fAxisImage.drawLine(x - 4, y + 10, x, y);
        this.fAxisImage.drawLine(x + 4, y + 10, x, y);
    }

    public void paintHorizontalTicks(int y) {
        if (this.fXMin >= 0L && this.fXMax >= 0L) {
            int nbTicks = (int)this.getWidth() / 40 + 1;
            int i = 0;
            while (i < nbTicks) {
                if (i % this.fDrawLabelEachNTicks == 0) {
                    int x = i * 40 + this.fPadding + this.fVerticalAxisOffset;
                    this.fAxisImage.drawLine(x, y, x, y + 3);
                }
                ++i;
            }
        }
    }

    public void paintHorizontalAxisValues(int y) {
        if (this.fXMin >= 0L && this.fXMax >= 0L) {
            this.fAxisImage.setForeground(this.fTextColor);
            this.fAxisImage.setBackground(this.fBackgroundColor);
            double width = this.getWidth();
            int nbTicks = (int)this.getWidth() / 40 + 1;
            int i = 0;
            while (i < nbTicks) {
                if (i % this.fDrawLabelEachNTicks == 0) {
                    int x = i * 40 + this.fPadding + this.fVerticalAxisOffset;
                    long currentValue = (long)(i * 40) * (long)((double)(this.fXMax - this.fXMin) / width) + this.fXMin;
                    String currentLabel = this.formatStringForHorizontalAxis(currentValue);
                    this.fAxisImage.setFont(this.fValuesFont);
                    this.fAxisImage.drawText(currentLabel, x, y - 24);
                }
                ++i;
            }
        }
    }

    public void paintHorizontalAxisLabel(int y) {
        if (this.fXAxisLabel != null) {
            this.fAxisImage.setFont(this.fLabelFont);
            this.fAxisImage.setForeground(this.fLabelColor);
            int labelWidth = this.fAxisImage.stringExtent((String)this.fXAxisLabel).x;
            this.fAxisImage.drawText(this.fXAxisLabel, this.fClientArea.width - this.fPadding - labelWidth, y);
        }
    }

    public void paintVerticalTicks(int x) {
        if (this.fYMin != 0L && this.fYMax != 0L) {
            int nbTicks = (int)(this.getHeight() / 30.0 + 1.0);
            int i = 0;
            while (i < nbTicks) {
                int y = this.fClientArea.height - this.fPadding - this.fHorizontalAxisYOffset - i * 30;
                this.fAxisImage.drawLine(x - 3, y, x, y);
                ++i;
            }
        }
    }

    public void paintVerticalAxisValues(int x) {
        if (this.fYMin >= 0L && this.fYMax >= 0L) {
            this.fAxisImage.setForeground(this.fTextColor);
            this.fAxisImage.setBackground(this.fBackgroundColor);
            double height = this.getHeight();
            int nbTicks = (int)(height / 30.0 + 1.0);
            int i = 0;
            while (i < nbTicks) {
                int y = this.fClientArea.height - this.fPadding - this.fHorizontalAxisYOffset - i * 30;
                long currentValue = (long)(i * 30) * (long)((double)(this.fYMax - this.fYMin) / height) + this.fYMin;
                String currentLabel = this.formatStringForVerticalAxis(currentValue);
                this.fAxisImage.setFont(this.fValuesFont);
                Point textDimensions = this.fAxisImage.stringExtent(currentLabel);
                this.fAxisImage.drawText(currentLabel, x - textDimensions.x - 5, y - textDimensions.y / 2);
                ++i;
            }
        }
    }

    public void increaseBarWitdh() {
        this.fBarWith <<= 1;
        if (this.fBarWith > 16) {
            this.fBarWith = 16;
        }
    }

    public void decreaseBarWitdh() {
        this.fBarWith >>= 1;
        if (this.fBarWith < 1) {
            this.fBarWith = 1;
        }
    }

    public void paintVerticalAxisLabel(int x) {
        if (this.fYAxisLabel != null) {
            this.fAxisImage.setFont(this.fLabelFont);
            this.fAxisImage.setForeground(this.fLabelColor);
            this.fAxisImage.setBackground(this.fBackgroundColor);
            if (this.fDelta >= 1) {
                this.fAxisImage.drawText(String.valueOf(this.fYAxisLabel) + " (x10^" + this.fDelta + ")", x + 10, this.fHorizontalAxisYOffset - 5);
            } else {
                this.fAxisImage.drawText(this.fYAxisLabel, x + 10, this.fPadding);
            }
        }
    }

    public abstract String formatToolTipLabel(int var1, int var2);

    public abstract void scale();

    public abstract void paintContent();

    public void clear() {
        this.fInitialized = false;
        this.fXMin = -1L;
        this.fXMax = -1L;
        this.fYMin = -1L;
        this.fYMax = -1L;
    }

    public void setDrawLabelEachNTicks(int nbTicks) {
        this.fDrawLabelEachNTicks = nbTicks;
    }

    public void setGraphTitle(String graphTitle) {
        this.fGraphTitle = graphTitle;
    }

    public void setXAxisLabel(String xAxisLabel, int offset) {
        this.fXAxisLabel = xAxisLabel;
        this.fXAxisLabelOffset = offset;
    }

    public void setYAxisLabel(String yAxisLabel) {
        this.fYAxisLabel = yAxisLabel;
    }

    public String formatStringForHorizontalAxis(long value) {
        return String.valueOf(value);
    }

    public String formatStringForVerticalAxis(long value) {
        return String.valueOf(value);
    }
}

