/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.resources.evProcessor;

import org.eclipse.linuxtools.internal.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.internal.lttng.core.state.StateStrings;
import org.eclipse.linuxtools.internal.lttng.core.state.evProcessor.ILttngEventProcessor;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngTraceState;
import org.eclipse.linuxtools.internal.lttng.ui.TraceDebug;
import org.eclipse.linuxtools.internal.lttng.ui.model.trange.TimeRangeEventResource;
import org.eclipse.linuxtools.internal.lttng.ui.views.resources.evProcessor.AbsResourcesTRangeUpdate;

public class ResourcesFinishUpdateHandler
extends AbsResourcesTRangeUpdate
implements ILttngEventProcessor {
    public StateStrings.Events getEventHandleType() {
        return null;
    }

    public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
        long endOfTrace = traceSt.getContext().getTraceTimeWindow().getEndTime().getValue();
        long halfWindow = (this.params.getEndTime() - this.params.getStartTime()) / 2L;
        long endOfEvent = this.params.getEndTime() + halfWindow;
        if (endOfEvent > endOfTrace) {
            endOfEvent = endOfTrace;
        }
        TraceDebug.debug("Number of localResources: " + this.resContainer.readItems().length);
        TimeRangeEventResource[] timeRangeEventResourceArray = this.resContainer.readItems();
        int n = timeRangeEventResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeRangeEventResource localResource = timeRangeEventResourceArray[n2];
            long stime = localResource.getNext_good_time();
            String stateMode = localResource.getStateMode(traceSt);
            this.makeDraw(traceSt, stime, endOfEvent, localResource, this.params, stateMode);
            ++n2;
        }
        return false;
    }
}

