/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.statistics.model;

import java.util.Arrays;
import java.util.RandomAccess;

public final class FixedArray
implements RandomAccess,
Cloneable {
    private final int[] fArray;

    private static int[] copyOf(int[] array, int newLength) {
        int[] result = new int[newLength];
        System.arraycopy(array, 0, result, 0, Math.min(array.length, newLength));
        return result;
    }

    private static int[] copyOfRange(int[] array, int start, int end) {
        int[] result = new int[end - start];
        System.arraycopy(array, start, result, 0, end - start);
        return result;
    }

    public FixedArray(int ... array) {
        this.fArray = array;
    }

    public FixedArray append(FixedArray value) {
        FixedArray result = new FixedArray(FixedArray.copyOf(this.fArray, this.fArray.length + value.size()));
        System.arraycopy(value.fArray, 0, result.fArray, this.fArray.length, value.fArray.length);
        return result;
    }

    public FixedArray append(FixedArray ... values) {
        int newLength = 0;
        FixedArray[] fixedArrayArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            FixedArray value = fixedArrayArray[n2];
            newLength += value.size();
            ++n2;
        }
        FixedArray result = new FixedArray(FixedArray.copyOf(this.fArray, this.fArray.length + newLength));
        newLength = this.fArray.length;
        FixedArray[] fixedArrayArray2 = values;
        int n3 = values.length;
        n = 0;
        while (n < n3) {
            FixedArray value = fixedArrayArray2[n];
            System.arraycopy(value.fArray, 0, result.fArray, newLength, value.fArray.length);
            newLength += value.fArray.length;
            ++n;
        }
        return result;
    }

    public FixedArray append(int value) {
        FixedArray result = new FixedArray(FixedArray.copyOf(this.fArray, this.fArray.length + 1));
        result.fArray[this.fArray.length] = value;
        return result;
    }

    public FixedArray append(int ... values) {
        FixedArray result = new FixedArray(FixedArray.copyOf(this.fArray, this.fArray.length + values.length));
        int i = 0;
        while (i < values.length) {
            result.fArray[this.fArray.length + i] = values[i];
            ++i;
        }
        return result;
    }

    public Object clone() {
        return new FixedArray(FixedArray.copyOf(this.fArray, this.fArray.length));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof FixedArray)) {
            return false;
        }
        FixedArray array = (FixedArray)other;
        return Arrays.equals(this.fArray, array.fArray);
    }

    public int get(int index) {
        return this.fArray[index];
    }

    public int[] getArray() {
        return this.fArray;
    }

    public int hashCode() {
        return Arrays.hashCode(this.fArray);
    }

    public int set(int index, int value) {
        int temp = this.fArray[index];
        this.fArray[index] = value;
        return temp;
    }

    public int size() {
        return this.fArray.length;
    }

    public FixedArray subArray(int start) {
        return new FixedArray(FixedArray.copyOfRange(this.fArray, start, this.fArray.length - 1));
    }

    public FixedArray subArray(int start, int length) {
        return new FixedArray(FixedArray.copyOfRange(this.fArray, start, length + start));
    }

    public String toString() {
        return Arrays.toString(this.fArray);
    }
}

