/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.linuxtools.internal.lttng2.ui.Activator;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.IImportConfirmationDialog;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.IImportDialog;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.ImportFileInfo;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.dialogs.TraceControlDialogFactory;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.messages.Messages;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.model.impl.TraceSessionComponent;
import org.eclipse.linuxtools.internal.lttng2.ui.views.control.remote.IRemoteSystemProxy;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ImportDialog
extends Dialog
implements IImportDialog {
    public static final String IMPORT_ICON_FILE = "icons/elcl16/import_trace.gif";
    public static final String UST_PARENT_DIRECTORY = "ust";
    private Composite fDialogComposite = null;
    private CheckboxTreeViewer fFolderViewer;
    private CCombo fCombo;
    private Button fOverwriteButton;
    private List<IProject> fProjects;
    private TraceSessionComponent fSession = null;
    private List<ImportFileInfo> fTraces = new ArrayList<ImportFileInfo>();
    private int fProjectIndex;
    private boolean fIsError = false;

    public ImportDialog(Shell shell) {
        super(shell);
        this.setShellStyle(16);
    }

    @Override
    public List<ImportFileInfo> getTracePathes() {
        ArrayList<ImportFileInfo> retList = new ArrayList<ImportFileInfo>();
        retList.addAll(this.fTraces);
        return retList;
    }

    @Override
    public IProject getProject() {
        return this.fProjects.get(this.fProjectIndex);
    }

    @Override
    public void setSession(TraceSessionComponent session) {
        this.fSession = session;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TraceControl_ImportDialogTitle);
        newShell.setImage(Activator.getDefault().loadIcon(IMPORT_ICON_FILE));
    }

    protected Control createDialogArea(Composite parent) {
        this.fDialogComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        this.fDialogComposite.setLayout((Layout)layout);
        this.fDialogComposite.setLayoutData((Object)new GridData(1808));
        Group contextGroup = new Group(this.fDialogComposite, 32);
        contextGroup.setText(Messages.TraceControl_ImportDialogTracesGroupName);
        layout = new GridLayout(1, true);
        contextGroup.setLayout((Layout)layout);
        contextGroup.setLayoutData((Object)new GridData(1808));
        IRemoteSystemProxy proxy = this.fSession.getTargetNode().getRemoteSystemProxy();
        IFileServiceSubSystem fsss = proxy.getFileServiceSubSystem();
        try {
            IRemoteFile remoteFolder = fsss.getRemoteFileObject(this.fSession.getSessionPath(), (IProgressMonitor)new NullProgressMonitor());
            this.fFolderViewer = new CheckboxTreeViewer((Composite)contextGroup, 2048);
            GridData data = new GridData(1808);
            Tree tree = this.fFolderViewer.getTree();
            tree.setLayoutData((Object)data);
            tree.setFont(parent.getFont());
            tree.setToolTipText(Messages.TraceControl_ImportDialogTracesTooltip);
            this.fFolderViewer.setContentProvider((IContentProvider)new FolderContentProvider());
            this.fFolderViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
            this.fFolderViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    Object elem = event.getElement();
                    if (elem instanceof IRemoteFile) {
                        IRemoteFile element = (IRemoteFile)elem;
                        if (!element.isDirectory()) {
                            boolean p = ImportDialog.this.fFolderViewer.getChecked((Object)element.getParentRemoteFile());
                            ImportDialog.this.fFolderViewer.setChecked((Object)element, p);
                            return;
                        }
                        ImportDialog.this.fFolderViewer.setSubtreeChecked(event.getElement(), event.getChecked());
                        if (!event.getChecked()) {
                            ImportDialog.this.fFolderViewer.setChecked((Object)element.getParentRemoteFile(), false);
                        }
                    }
                }
            });
            this.fFolderViewer.setInput((Object)remoteFolder);
            Group projectGroup = new Group(this.fDialogComposite, 32);
            projectGroup.setText(Messages.TraceControl_ImportDialogProjectsGroupName);
            layout = new GridLayout(1, true);
            projectGroup.setLayout((Layout)layout);
            projectGroup.setLayoutData((Object)new GridData(768));
            this.fProjects = new ArrayList<IProject>();
            ArrayList<String> projectNames = new ArrayList<String>();
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                try {
                    if (project.isOpen() && project.hasNature("org.eclipse.linuxtools.tmf.project.nature")) {
                        this.fProjects.add(project);
                        projectNames.add(project.getName());
                    }
                }
                catch (CoreException e) {
                    this.createErrorComposite(parent, e.fillInStackTrace());
                    return this.fDialogComposite;
                }
                ++n2;
            }
            this.fCombo = new CCombo((Composite)projectGroup, 8);
            this.fCombo.setToolTipText(Messages.TraceControl_ImportDialogProjectsTooltip);
            this.fCombo.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
            this.fCombo.setItems(projectNames.toArray(new String[projectNames.size()]));
            Group overrideGroup = new Group(this.fDialogComposite, 32);
            layout = new GridLayout(1, true);
            overrideGroup.setLayout((Layout)layout);
            overrideGroup.setLayoutData((Object)new GridData(768));
            this.fOverwriteButton = new Button((Composite)overrideGroup, 32);
            this.fOverwriteButton.setText(Messages.TraceControl_ImportDialogOverwriteButtonText);
            this.getShell().setMinimumSize(new Point(500, 400));
        }
        catch (SystemMessageException e) {
            this.createErrorComposite(parent, e.fillInStackTrace());
            return this.fDialogComposite;
        }
        return this.fDialogComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "&Cancel", true);
        this.createButton(parent, 0, "&Ok", true);
    }

    protected void okPressed() {
        if (!this.fIsError) {
            this.fTraces.clear();
            this.fProjectIndex = this.fCombo.getSelectionIndex();
            if (this.fProjectIndex < 0) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_ImportDialogTitle, (String)Messages.TraceControl_ImportDialogNoProjectSelectedError);
                return;
            }
            IProject project = this.fProjects.get(this.fProjectIndex);
            IFolder traceFolder = project.getFolder("Traces");
            if (!traceFolder.exists()) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_ImportDialogTitle, (String)(String.valueOf(Messages.TraceControl_ImportDialogInvalidTracingProject) + " (" + "Traces" + ")"));
                return;
            }
            boolean overwriteAll = this.fOverwriteButton.getSelection();
            Object[] checked = this.fFolderViewer.getCheckedElements();
            int i = 0;
            while (i < checked.length) {
                IRemoteFile file = (IRemoteFile)checked[i];
                if (file.isDirectory() && !UST_PARENT_DIRECTORY.equals(file.getName())) {
                    ImportFileInfo info = new ImportFileInfo(file, file.getName(), overwriteAll);
                    String traceName = info.getLocalTraceName();
                    IFolder folder = traceFolder.getFolder(traceName);
                    if (folder.exists() && !overwriteAll) {
                        IImportConfirmationDialog conf = TraceControlDialogFactory.getInstance().getImportConfirmationDialog();
                        conf.setTraceName(traceName);
                        if (conf.open() == 0) {
                            info.setOverwrite(conf.isOverwrite());
                            if (!conf.isOverwrite()) {
                                info.setLocalTraceName(conf.getNewTraceName());
                            }
                            this.fTraces.add(info);
                        }
                    } else {
                        this.fTraces.add(info);
                    }
                }
                ++i;
            }
            if (this.fTraces.isEmpty()) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.TraceControl_ImportDialogTitle, (String)Messages.TraceControl_ImportDialogNoTraceSelectedError);
                return;
            }
        }
        super.okPressed();
    }

    private void createErrorComposite(Composite parent, Throwable e) {
        this.fIsError = true;
        this.fDialogComposite.dispose();
        this.fDialogComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        this.fDialogComposite.setLayout((Layout)layout);
        this.fDialogComposite.setLayoutData((Object)new GridData(1808));
        Text errorText = new Text(this.fDialogComposite, 2);
        StringBuffer error = new StringBuffer();
        error.append(Messages.TraceControl_ImportDialogCreationError);
        error.append(System.getProperty("line.separator"));
        error.append(System.getProperty("line.separator"));
        error.append(e.toString());
        errorText.setText(error.toString());
        errorText.setLayoutData((Object)new GridData(1808));
    }

    public static class FolderContentProvider
    extends WorkbenchContentProvider {
        public Object[] getChildren(Object o) {
            IRemoteFile element;
            if (o instanceof IRemoteFile && !(element = (IRemoteFile)o).isDirectory()) {
                return new Object[0];
            }
            return super.getChildren(o);
        }
    }
}

